/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.LocalDateTime;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBNative;
import org.duckdb.DuckDBTimestamp;

public class DuckDBAppender
implements AutoCloseable {
    protected ByteBuffer appender_ref = null;

    public DuckDBAppender(DuckDBConnection duckDBConnection, String string, String string2) throws SQLException {
        if (duckDBConnection == null) {
            throw new SQLException("Invalid connection");
        }
        this.appender_ref = DuckDBNative.duckdb_jdbc_create_appender(duckDBConnection.conn_ref, string.getBytes(StandardCharsets.UTF_8), string2.getBytes(StandardCharsets.UTF_8));
    }

    public void beginRow() throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_begin_row(this.appender_ref);
    }

    public void endRow() throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_end_row(this.appender_ref);
    }

    public void flush() throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_flush(this.appender_ref);
    }

    public void append(boolean bl) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_boolean(this.appender_ref, bl);
    }

    public void append(byte by) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_byte(this.appender_ref, by);
    }

    public void append(short s) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_short(this.appender_ref, s);
    }

    public void append(int n) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_int(this.appender_ref, n);
    }

    public void append(long l) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_long(this.appender_ref, l);
    }

    public void appendLocalDateTime(LocalDateTime localDateTime) throws SQLException {
        if (localDateTime == null) {
            DuckDBNative.duckdb_jdbc_appender_append_null(this.appender_ref);
        } else {
            long l = DuckDBTimestamp.localDateTime2Micros(localDateTime);
            DuckDBNative.duckdb_jdbc_appender_append_timestamp(this.appender_ref, l);
        }
    }

    public void appendBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            DuckDBNative.duckdb_jdbc_appender_append_null(this.appender_ref);
        } else {
            DuckDBNative.duckdb_jdbc_appender_append_decimal(this.appender_ref, bigDecimal);
        }
    }

    public void append(float f) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_float(this.appender_ref, f);
    }

    public void append(double d) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_double(this.appender_ref, d);
    }

    public void append(String string) throws SQLException {
        if (string == null) {
            DuckDBNative.duckdb_jdbc_appender_append_null(this.appender_ref);
        } else {
            DuckDBNative.duckdb_jdbc_appender_append_string(this.appender_ref, string.getBytes(StandardCharsets.UTF_8));
        }
    }

    public void append(byte[] byArray) throws SQLException {
        if (byArray == null) {
            DuckDBNative.duckdb_jdbc_appender_append_null(this.appender_ref);
        } else {
            DuckDBNative.duckdb_jdbc_appender_append_bytes(this.appender_ref, byArray);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.appender_ref != null) {
            DuckDBNative.duckdb_jdbc_appender_close(this.appender_ref);
            this.appender_ref = null;
        }
    }
}

