/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractMutableVirtualTable
extends AbstractVirtualTable {
    protected AbstractMutableVirtualTable(TableMetadata metadata) {
        super(metadata);
    }

    @Override
    public final void apply(PartitionUpdate update) {
        ColumnValues partitionKey = ColumnValues.from(this.metadata(), update.partitionKey());
        if (update.deletionInfo().isLive()) {
            update.forEach(row -> {
                ColumnValues clusteringColumns = ColumnValues.from(this.metadata(), row.clustering());
                if (row.deletion().isLive()) {
                    if (row.columnCount() == 0) {
                        this.applyColumnUpdate(partitionKey, clusteringColumns, Optional.empty());
                    } else {
                        row.forEach(columnData -> {
                            RequestValidations.checkFalse(columnData.column().isComplex(), "Complex type columns are not supported by table %s", this.metadata);
                            Cell cell = (Cell)columnData;
                            if (cell.isTombstone()) {
                                this.applyColumnDeletion(partitionKey, clusteringColumns, AbstractMutableVirtualTable.columnName(cell));
                            } else {
                                this.applyColumnUpdate(partitionKey, clusteringColumns, Optional.of(ColumnValue.from(cell)));
                            }
                        });
                    }
                } else {
                    this.applyRowDeletion(partitionKey, clusteringColumns);
                }
            });
        } else {
            if (update.deletionInfo().hasRanges()) {
                update.deletionInfo().rangeIterator(false).forEachRemaining(rt -> this.applyRangeTombstone(partitionKey, this.toRange(rt.deletedSlice())));
            }
            if (!update.deletionInfo().getPartitionDeletion().isLive()) {
                this.applyPartitionDeletion(partitionKey);
            }
        }
    }

    protected void applyPartitionDeletion(ColumnValues partitionKey) {
        throw RequestValidations.invalidRequest("Partition deletion is not supported by table %s", this.metadata);
    }

    private Range<ColumnValues> toRange(Slice slice) {
        ClusteringBound<?> startBound = slice.start();
        ClusteringBound<?> endBound = slice.end();
        if (startBound.isBottom()) {
            if (endBound.isTop()) {
                return Range.all();
            }
            return Range.upTo((Comparable)ColumnValues.from(this.metadata(), endBound), (BoundType)AbstractMutableVirtualTable.boundType(endBound));
        }
        if (endBound.isTop()) {
            return Range.downTo((Comparable)ColumnValues.from(this.metadata(), startBound), (BoundType)AbstractMutableVirtualTable.boundType(startBound));
        }
        ColumnValues start = ColumnValues.from(this.metadata(), startBound);
        BoundType startType = AbstractMutableVirtualTable.boundType(startBound);
        ColumnValues end = ColumnValues.from(this.metadata(), endBound);
        BoundType endType = AbstractMutableVirtualTable.boundType(endBound);
        return Range.range((Comparable)start, (BoundType)startType, (Comparable)end, (BoundType)endType);
    }

    private static BoundType boundType(ClusteringBound<?> bound) {
        return bound.isInclusive() ? BoundType.CLOSED : BoundType.OPEN;
    }

    protected void applyRangeTombstone(ColumnValues partitionKey, Range<ColumnValues> range) {
        throw RequestValidations.invalidRequest("Range deletion is not supported by table %s", this.metadata);
    }

    protected void applyRowDeletion(ColumnValues partitionKey, ColumnValues clusteringColumns) {
        throw RequestValidations.invalidRequest("Row deletion is not supported by table %s", this.metadata);
    }

    protected void applyColumnDeletion(ColumnValues partitionKey, ColumnValues clusteringColumns, String columnName) {
        throw RequestValidations.invalidRequest("Column deletion is not supported by table %s", this.metadata);
    }

    protected void applyColumnUpdate(ColumnValues partitionKey, ColumnValues clusteringColumns, Optional<ColumnValue> columnValue) {
        throw RequestValidations.invalidRequest("Column modification is not supported by table %s", this.metadata);
    }

    private static String columnName(Cell<?> cell) {
        return cell.column().name.toCQLString();
    }

    public static final class ColumnValue {
        private final ColumnMetadata metadata;
        private final Object value;

        public static ColumnValue from(Cell<?> cell) {
            ColumnMetadata metadata = cell.column();
            return new ColumnValue(metadata, metadata.type.compose(cell.buffer()));
        }

        private ColumnValue(ColumnMetadata metadata, Object value) {
            this.metadata = metadata;
            this.value = value;
        }

        public String name() {
            return this.metadata.name.toCQLString();
        }

        public <V> V value() {
            return (V)this.value;
        }

        public String toString() {
            return String.format("%s : %s", this.name(), this.value());
        }
    }

    public static final class ColumnValues
    implements Comparable<ColumnValues> {
        private static final ColumnValues EMPTY = new ColumnValues((List<ColumnMetadata>)ImmutableList.of(), ArrayUtils.EMPTY_OBJECT_ARRAY);
        private final ImmutableList<ColumnMetadata> metadata;
        private final Object[] values;

        public static ColumnValues from(TableMetadata metadata, DecoratedKey partitionKey) {
            if (metadata.partitionKeyType instanceof CompositeType) {
                ByteBuffer[] buffers = ((CompositeType)metadata.partitionKeyType).split(partitionKey.getKey());
                return ColumnValues.from(metadata.partitionKeyColumns(), buffers);
            }
            return ColumnValues.from(metadata.partitionKeyColumns(), partitionKey.getKey());
        }

        public static ColumnValues from(TableMetadata metadata, ClusteringPrefix<?> prefix) {
            if (prefix == Clustering.EMPTY) {
                return EMPTY;
            }
            return ColumnValues.from(metadata.clusteringColumns(), prefix.getBufferArray());
        }

        private static ColumnValues from(ImmutableList<ColumnMetadata> metadata, ByteBuffer ... buffers) {
            return new ColumnValues((List<ColumnMetadata>)metadata, ColumnValues.convert(metadata, buffers));
        }

        public ColumnValues(List<ColumnMetadata> metadata, Object ... values) {
            this.metadata = ImmutableList.copyOf(metadata);
            this.values = values;
        }

        private static Object[] convert(ImmutableList<ColumnMetadata> metadata, ByteBuffer[] buffers) {
            Object[] values = new Object[buffers.length];
            for (int i = 0; i < buffers.length; ++i) {
                values[i] = ((ColumnMetadata)metadata.get((int)i)).type.compose(buffers[i]);
            }
            return values;
        }

        public String name(int i) {
            Preconditions.checkPositionIndex((int)i, (int)this.values.length);
            return ((ColumnMetadata)this.metadata.get((int)i)).name.toCQLString();
        }

        public <V> V value(int i) {
            Preconditions.checkPositionIndex((int)i, (int)this.values.length);
            return (V)this.values[i];
        }

        public int size() {
            return this.values.length;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            int m = this.metadata.size();
            for (int i = 0; i < m; ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(((ColumnMetadata)this.metadata.get((int)i)).name.toCQLString()).append(" : ");
                if (i >= this.values.length) continue;
                builder.append(i < this.values.length ? this.values[i].toString() : "unspecified");
            }
            return builder.append(']').toString();
        }

        @Override
        public int compareTo(ColumnValues o) {
            assert (this.metadata.equals(o.metadata));
            int s1 = this.size();
            int s2 = o.size();
            int minSize = Math.min(s1, s2);
            for (int i = 0; i < minSize; ++i) {
                int cmp = this.compare(this.values[i], o.values[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        private <T extends Comparable<T>> int compare(Object c1, Object c2) {
            return ((Comparable)c1).compareTo((Comparable)c2);
        }
    }
}

