/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mailvalidator;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.mailvalidator.ActionMailValidator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionMailValidatorDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionMailValidator.class;
    private Text wName;
    private ActionMailValidator action;
    private Shell shell;
    private boolean changed;
    private LabelTextVar wMailAddress;
    private Label wleMailSender;
    private TextVar weMailSender;
    private Label wlTimeOut;
    private TextVar wTimeOut;
    private Label wlDefaultSMTP;
    private TextVar wDefaultSMTP;
    private Button wSMTPCheck;

    public ActionMailValidatorDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionMailValidator)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wMailAddress = new LabelTextVar(this.variables, (Composite)this.shell, BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.MailAddress.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.MailAddress.Tooltip", (String[])new String[0]));
        this.wMailAddress.addModifyListener(lsMod);
        FormData fdMailAddress = new FormData();
        fdMailAddress.left = new FormAttachment(0, 0);
        fdMailAddress.top = new FormAttachment((Control)this.wName, margin);
        fdMailAddress.right = new FormAttachment(100, 0);
        this.wMailAddress.setLayoutData((Object)fdMailAddress);
        Group wSettingsGroup = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wSettingsGroup);
        wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.Group.SettingsAddress.Label", (String[])new String[0]));
        FormLayout settingsgroupLayout = new FormLayout();
        settingsgroupLayout.marginWidth = 10;
        settingsgroupLayout.marginHeight = 10;
        wSettingsGroup.setLayout((Layout)settingsgroupLayout);
        Label wlSMTPCheck = new Label((Composite)wSettingsGroup, 131072);
        wlSMTPCheck.setText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.SMTPCheck.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSMTPCheck);
        FormData fdlSMTPCheck = new FormData();
        fdlSMTPCheck.left = new FormAttachment(0, 0);
        fdlSMTPCheck.top = new FormAttachment((Control)this.wMailAddress, margin);
        fdlSMTPCheck.right = new FormAttachment(middle, -2 * margin);
        wlSMTPCheck.setLayoutData((Object)fdlSMTPCheck);
        this.wSMTPCheck = new Button((Composite)wSettingsGroup, 32);
        PropsUi.setLook((Widget)this.wSMTPCheck);
        this.wSMTPCheck.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.SMTPCheck.Tooltip", (String[])new String[0]));
        FormData fdSMTPCheck = new FormData();
        fdSMTPCheck.left = new FormAttachment(middle, -margin);
        fdSMTPCheck.top = new FormAttachment((Control)wlSMTPCheck, 0, 0x1000000);
        this.wSMTPCheck.setLayoutData((Object)fdSMTPCheck);
        this.wSMTPCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionMailValidatorDialog.this.activeSMTPCheck();
            }
        });
        this.wlTimeOut = new Label((Composite)wSettingsGroup, 131072);
        this.wlTimeOut.setText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.TimeOutField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTimeOut);
        FormData fdlTimeOut = new FormData();
        fdlTimeOut.left = new FormAttachment(0, 0);
        fdlTimeOut.right = new FormAttachment(middle, -2 * margin);
        fdlTimeOut.top = new FormAttachment((Control)wlSMTPCheck, 2 * margin);
        this.wlTimeOut.setLayoutData((Object)fdlTimeOut);
        this.wTimeOut = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        this.wTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.TimeOutField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTimeOut);
        this.wTimeOut.addModifyListener(lsMod);
        FormData fdTimeOut = new FormData();
        fdTimeOut.left = new FormAttachment(middle, -margin);
        fdTimeOut.top = new FormAttachment((Control)wlSMTPCheck, 2 * margin);
        fdTimeOut.right = new FormAttachment(100, 0);
        this.wTimeOut.setLayoutData((Object)fdTimeOut);
        this.wleMailSender = new Label((Composite)wSettingsGroup, 131072);
        this.wleMailSender.setText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.eMailSenderField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wleMailSender);
        FormData fdleMailSender = new FormData();
        fdleMailSender.left = new FormAttachment(0, 0);
        fdleMailSender.right = new FormAttachment(middle, -2 * margin);
        fdleMailSender.top = new FormAttachment((Control)this.wTimeOut, margin);
        this.wleMailSender.setLayoutData((Object)fdleMailSender);
        this.weMailSender = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        this.weMailSender.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.eMailSenderField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.weMailSender);
        this.weMailSender.addModifyListener(lsMod);
        FormData fdeMailSender = new FormData();
        fdeMailSender.left = new FormAttachment(middle, -margin);
        fdeMailSender.top = new FormAttachment((Control)this.wTimeOut, margin);
        fdeMailSender.right = new FormAttachment(100, 0);
        this.weMailSender.setLayoutData((Object)fdeMailSender);
        this.wlDefaultSMTP = new Label((Composite)wSettingsGroup, 131072);
        this.wlDefaultSMTP.setText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.DefaultSMTPField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlDefaultSMTP);
        FormData fdlDefaultSMTP = new FormData();
        fdlDefaultSMTP.left = new FormAttachment(0, 0);
        fdlDefaultSMTP.right = new FormAttachment(middle, -2 * margin);
        fdlDefaultSMTP.top = new FormAttachment((Control)this.weMailSender, margin);
        this.wlDefaultSMTP.setLayoutData((Object)fdlDefaultSMTP);
        this.wDefaultSMTP = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        this.wDefaultSMTP.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMailValidatorDialog.DefaultSMTPField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wDefaultSMTP);
        this.wDefaultSMTP.addModifyListener(lsMod);
        FormData fdDefaultSMTP = new FormData();
        fdDefaultSMTP.left = new FormAttachment(middle, -margin);
        fdDefaultSMTP.top = new FormAttachment((Control)this.weMailSender, margin);
        fdDefaultSMTP.right = new FormAttachment(100, 0);
        this.wDefaultSMTP.setLayoutData((Object)fdDefaultSMTP);
        FormData fdSettingsGroup = new FormData();
        fdSettingsGroup.left = new FormAttachment(0, margin);
        fdSettingsGroup.top = new FormAttachment((Control)this.wMailAddress, margin);
        fdSettingsGroup.right = new FormAttachment(100, -margin);
        fdSettingsGroup.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wSettingsGroup.setLayoutData((Object)fdSettingsGroup);
        this.getData();
        this.activeSMTPCheck();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    private void activeSMTPCheck() {
        this.wlTimeOut.setEnabled(this.wSMTPCheck.getSelection());
        this.wTimeOut.setEnabled(this.wSMTPCheck.getSelection());
        this.wlDefaultSMTP.setEnabled(this.wSMTPCheck.getSelection());
        this.wDefaultSMTP.setEnabled(this.wSMTPCheck.getSelection());
        this.wleMailSender.setEnabled(this.wSMTPCheck.getSelection());
        this.weMailSender.setEnabled(this.wSMTPCheck.getSelection());
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.action.getName(), (String)""));
        this.wMailAddress.setText(Const.NVL((String)this.action.getEmailAddress(), (String)""));
        this.wTimeOut.setText(Const.NVL((String)this.action.getTimeout(), (String)"0"));
        this.wSMTPCheck.setSelection(this.action.isSmtpCheck());
        this.wDefaultSMTP.setText(Const.NVL((String)this.action.getDefaultSMTP(), (String)""));
        this.weMailSender.setText(Const.NVL((String)this.action.getEmailSender(), (String)""));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setEmailAddress(this.wMailAddress.getText());
        this.action.setTimeout(this.wTimeOut.getText());
        this.action.setDefaultSMTP(this.wDefaultSMTP.getText());
        this.action.setEmailSender(this.weMailSender.getText());
        this.action.setSmtpCheck(this.wSMTPCheck.getSelection());
        this.dispose();
    }
}

