/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filemetadata;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.filemetadata.FileMetadataMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FileMetadataDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = FileMetadataMeta.class;
    private final FileMetadataMeta meta;
    private Label wlFilename;
    private TextVar wFilename;
    private Button wFileInField;
    private Label wlFilenameField;
    private CCombo wFilenameField;
    private TableView wDelimiterCandidates;
    private TableView wEnclosureCandidates;
    private TextVar wLimit;
    private ComboVar wDefaultCharset;
    private boolean gotEncodings = false;
    private boolean getPreviousFields = false;

    public FileMetadataDialog(Shell parent, IVariables variables, FileMetadataMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.meta = transformMeta;
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wDefaultCharset.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wDefaultCharset.add(charSet.displayName());
            }
            String defEncoding = this.meta.getDefaultCharset();
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wDefaultCharset.getItems());
            if (idx >= 0) {
                this.wDefaultCharset.select(idx);
            }
        }
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.meta);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        ModifyListener lsMod = e -> this.meta.setChanged();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FileMetadata.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Button wbbFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbbFilename);
        wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.top = new FormAttachment((Control)lastControl, margin);
        fdbFilename.right = new FormAttachment(100, 0);
        wbbFilename.setLayoutData((Object)fdbFilename);
        this.wlFilename = new Label((Composite)this.shell, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"FileMetadata.Filename", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.top = new FormAttachment((Control)lastControl, margin);
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.top = new FormAttachment((Control)lastControl, margin);
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.right = new FormAttachment((Control)wbbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        Label wlFileInField = new Label((Composite)this.shell, 131072);
        wlFileInField.setText(BaseMessages.getString(PKG, (String)"FileMetadata.FileInField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFileInField);
        FormData fdlFileInField = new FormData();
        fdlFileInField.left = new FormAttachment(0, -margin);
        fdlFileInField.top = new FormAttachment((Control)this.wFilename, margin);
        fdlFileInField.right = new FormAttachment(middle, -2 * margin);
        wlFileInField.setLayoutData((Object)fdlFileInField);
        this.wFileInField = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wFileInField);
        this.wFileInField.setToolTipText(BaseMessages.getString(PKG, (String)"FileMetadata.FileInField.Tooltip", (String[])new String[0]));
        FormData fdFileField = new FormData();
        fdFileField.left = new FormAttachment(middle, -margin);
        fdFileField.top = new FormAttachment((Control)wlFileInField, 0, 0x1000000);
        this.wFileInField.setLayoutData((Object)fdFileField);
        SelectionAdapter lfilefield = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FileMetadataDialog.this.activateFileField();
                FileMetadataDialog.this.meta.setChanged();
            }
        };
        this.wFileInField.addSelectionListener((SelectionListener)lfilefield);
        this.wlFilenameField = new Label((Composite)this.shell, 131072);
        this.wlFilenameField.setText(BaseMessages.getString(PKG, (String)"FileMetadata.FilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameField);
        FormData fdlFilenameField = new FormData();
        fdlFilenameField.left = new FormAttachment(0, -margin);
        fdlFilenameField.top = new FormAttachment((Control)this.wFileInField, margin);
        fdlFilenameField.right = new FormAttachment(middle, -2 * margin);
        this.wlFilenameField.setLayoutData((Object)fdlFilenameField);
        this.wFilenameField = new CCombo((Composite)this.shell, 2056);
        this.wFilenameField.setEditable(true);
        PropsUi.setLook((Widget)this.wFilenameField);
        this.wFilenameField.addModifyListener(lsMod);
        FormData fdFilenameField = new FormData();
        fdFilenameField.left = new FormAttachment(middle, -margin);
        fdFilenameField.top = new FormAttachment((Control)this.wFileInField, margin);
        fdFilenameField.right = new FormAttachment(100, -margin);
        this.wFilenameField.setLayoutData((Object)fdFilenameField);
        this.wFilenameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)FileMetadataDialog.this.shell.getDisplay(), 1);
                FileMetadataDialog.this.shell.setCursor(busy);
                FileMetadataDialog.this.getFields();
                FileMetadataDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Group gDelimitedLayout = new Group((Composite)this.shell, 16);
        gDelimitedLayout.setText(BaseMessages.getString(PKG, (String)"FileMetadata.DelimitedLayout.Group.Label", (String[])new String[0]));
        FormLayout gDelimitedLayoutLayout = new FormLayout();
        gDelimitedLayoutLayout.marginWidth = 3;
        gDelimitedLayoutLayout.marginHeight = 3;
        gDelimitedLayout.setLayout((Layout)gDelimitedLayoutLayout);
        PropsUi.setLook((Widget)gDelimitedLayout);
        Label wlLimit = new Label((Composite)gDelimitedLayout, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"FileMetadata.methods.DELIMITED_FIELDS.limit", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.right = new FormAttachment(middle, -margin);
        fdlLimit.top = new FormAttachment(0, margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new TextVar(this.variables, (Composite)gDelimitedLayout, 18436);
        this.wLimit.setToolTipText(BaseMessages.getString(PKG, (String)"FileMetadata.methods.DELIMITED_FIELDS.limit.tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wLimit);
        FormData fdLimit = new FormData();
        fdLimit.top = new FormAttachment(0, margin);
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        lastControl = this.wLimit;
        Label wlEncoding = new Label((Composite)gDelimitedLayout, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"FileMetadata.methods.DELIMITED_FIELDS.default_charset", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEncoding);
        FormData fdlDefaultCharset = new FormData();
        fdlDefaultCharset.top = new FormAttachment((Control)lastControl, margin);
        fdlDefaultCharset.left = new FormAttachment(0, 0);
        fdlDefaultCharset.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlDefaultCharset);
        this.wDefaultCharset = new ComboVar(this.variables, (Composite)gDelimitedLayout, 18436);
        PropsUi.setLook((Widget)this.wDefaultCharset);
        FormData fdDefaultCharset = new FormData();
        fdDefaultCharset.top = new FormAttachment((Control)lastControl, margin);
        fdDefaultCharset.left = new FormAttachment(middle, 0);
        fdDefaultCharset.right = new FormAttachment(100, 0);
        this.wDefaultCharset.setLayoutData((Object)fdDefaultCharset);
        this.wDefaultCharset.addListener(15, e -> {
            Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(busy);
            this.setEncodings();
            this.shell.setCursor(null);
            busy.dispose();
        });
        int candidateCount = this.meta.getDelimiterCandidates().size();
        ColumnInfo[] delimiterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FileMetadata.methods.DELIMITED_FIELDS.delimiter_candidates", (String[])new String[0]), 1, false)};
        delimiterColumns[0].setUsingVariables(true);
        this.wDelimiterCandidates = new TableView(this.variables, (Composite)gDelimitedLayout, 67586, delimiterColumns, candidateCount, null, this.props);
        FormData fdDelimiterCandidates = new FormData();
        fdDelimiterCandidates.left = new FormAttachment(0, 0);
        fdDelimiterCandidates.right = new FormAttachment(100, 0);
        fdDelimiterCandidates.top = new FormAttachment((Control)this.wDefaultCharset, margin);
        fdDelimiterCandidates.bottom = new FormAttachment(50, 0);
        this.wDelimiterCandidates.setLayoutData((Object)fdDelimiterCandidates);
        candidateCount = this.meta.getEnclosureCandidates().size();
        ColumnInfo[] enclosureColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FileMetadata.methods.DELIMITED_FIELDS.enclosure_candidates", (String[])new String[0]), 1, false)};
        enclosureColumns[0].setUsingVariables(true);
        this.wEnclosureCandidates = new TableView(this.variables, (Composite)gDelimitedLayout, 67586, enclosureColumns, candidateCount, null, this.props);
        FormData fdEnclosureCandidates = new FormData();
        fdEnclosureCandidates.left = new FormAttachment(0, 0);
        fdEnclosureCandidates.right = new FormAttachment(100, 0);
        fdEnclosureCandidates.top = new FormAttachment(50, margin);
        fdEnclosureCandidates.bottom = new FormAttachment(100, 0);
        this.wEnclosureCandidates.setLayoutData((Object)fdEnclosureCandidates);
        FormData fdQueryGroup = new FormData();
        fdQueryGroup.left = new FormAttachment(0, 0);
        fdQueryGroup.right = new FormAttachment(100, 0);
        fdQueryGroup.top = new FormAttachment((Control)this.wFilenameField, margin);
        fdQueryGroup.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        gDelimitedLayout.setLayoutData((Object)fdQueryGroup);
        this.populateDialog();
        this.meta.setChanged(this.changed);
        wbbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.txt;*.csv", "*.csv", "*.txt", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]) + ", " + BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void activateFileField() {
        this.wlFilenameField.setEnabled(this.wFileInField.getSelection());
        this.wFilenameField.setEnabled(this.wFileInField.getSelection());
        this.wlFilename.setEnabled(!this.wFileInField.getSelection());
        this.wFilename.setEnabled(!this.wFileInField.getSelection());
        if (this.wFileInField.getSelection()) {
            this.wFilename.setText("");
        } else {
            this.wFilenameField.setText("");
        }
    }

    private void getFields() {
        try {
            if (!this.getPreviousFields) {
                this.getPreviousFields = true;
                this.wFilenameField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wFilenameField.setItems(r.getFieldNames());
                }
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FileMetadata.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FileMetadata.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void populateDialog() {
        TableItem item;
        FileMetadataMeta.FMCandidate candidate;
        int i;
        this.wTransformName.selectAll();
        this.wFilename.setText(Const.NVL((String)this.meta.getFileName(), (String)""));
        this.wFileInField.setSelection(this.meta.isFilenameInField());
        if (this.meta.getFilenameField() != null) {
            this.wFilenameField.setText(this.meta.getFilenameField());
        }
        this.wLimit.setText(Const.NVL((String)this.meta.getLimitRows(), (String)""));
        this.wDefaultCharset.setText(Const.NVL((String)this.meta.getDefaultCharset(), (String)""));
        for (i = 0; i < this.meta.getDelimiterCandidates().size(); ++i) {
            candidate = this.meta.getDelimiterCandidates().get(i);
            item = this.wDelimiterCandidates.table.getItem(i);
            item.setText(1, Const.NVL((String)candidate.getCandidate(), (String)""));
        }
        for (i = 0; i < this.meta.getEnclosureCandidates().size(); ++i) {
            candidate = this.meta.getEnclosureCandidates().get(i);
            item = this.wEnclosureCandidates.table.getItem(i);
            item.setText(1, Const.NVL((String)candidate.getCandidate(), (String)""));
        }
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.meta.setFileName(this.wFilename.getText());
        this.meta.setFilenameInField(this.wFileInField.getSelection());
        this.meta.setFilenameField(this.wFilenameField.getText());
        this.meta.setLimitRows(this.wLimit.getText());
        this.meta.setDefaultCharset(this.wDefaultCharset.getText());
        this.meta.getDelimiterCandidates().clear();
        for (TableItem item : this.wDelimiterCandidates.getNonEmptyItems()) {
            this.meta.getDelimiterCandidates().add(new FileMetadataMeta.FMCandidate(item.getText(1)));
        }
        this.meta.getEnclosureCandidates().clear();
        for (TableItem item : this.wEnclosureCandidates.getNonEmptyItems()) {
            this.meta.getEnclosureCandidates().add(new FileMetadataMeta.FMCandidate(item.getText(1)));
        }
        this.dispose();
    }
}

