/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filemetadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMetaBuilder;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.filemetadata.FileMetadata;
import org.apache.hop.pipeline.transforms.filemetadata.FileMetadataData;

@Transform(id="FileMetadataPlugin", name="i18n::FileMetadata.Name", image="filemetadata.svg", description="i18n::FileMetadata.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::FileMetadata.Keyword"}, documentationUrl="/pipeline/transforms/filemetadata.html")
public class FileMetadataMeta
extends BaseTransformMeta<FileMetadata, FileMetadataData> {
    @HopMetadataProperty(key="fileName")
    private String fileName;
    @HopMetadataProperty(key="filenameInField")
    private boolean filenameInField;
    @HopMetadataProperty(key="fileNameField")
    private String filenameField;
    @HopMetadataProperty(key="limitRows")
    private String limitRows;
    @HopMetadataProperty(key="defaultCharset")
    private String defaultCharset;
    @HopMetadataProperty(key="delimiterCandidate")
    private List<FMCandidate> delimiterCandidates = new ArrayList<FMCandidate>();
    @HopMetadataProperty(key="enclosureCandidate")
    private List<FMCandidate> enclosureCandidates = new ArrayList<FMCandidate>();

    public FileMetadataMeta() {
    }

    public FileMetadataMeta(FileMetadataMeta m) {
        this();
        this.fileName = m.fileName;
        this.limitRows = m.limitRows;
        this.defaultCharset = m.defaultCharset;
        m.delimiterCandidates.forEach(c -> this.delimiterCandidates.add(new FMCandidate((FMCandidate)c)));
        m.enclosureCandidates.forEach(c -> this.enclosureCandidates.add(new FMCandidate((FMCandidate)c)));
    }

    public void setDefault() {
        this.fileName = "";
        this.limitRows = "10000";
        this.defaultCharset = "ISO-8859-1";
        this.filenameInField = false;
        this.delimiterCandidates.clear();
        this.delimiterCandidates.add(new FMCandidate("\t"));
        this.delimiterCandidates.add(new FMCandidate(";"));
        this.delimiterCandidates.add(new FMCandidate(","));
        this.enclosureCandidates.clear();
        this.enclosureCandidates.add(new FMCandidate("\""));
        this.enclosureCandidates.add(new FMCandidate("'"));
    }

    public FileMetadataMeta clone() {
        return new FileMetadataMeta(this);
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        rowMeta.addRowMeta(new RowMetaBuilder().addString("charset").addString("delimiter").addString("enclosure").addInteger("field_count").addInteger("skip_header_lines").addInteger("skip_footer_lines").addBoolean("header_line_present").addString("name").addString("type").addInteger("length").addInteger("precision").addString("mask").addString("decimal_symbol").addString("grouping_symbol").build());
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isFilenameInField() {
        return this.filenameInField;
    }

    public void setFilenameInField(boolean filenameInField) {
        this.filenameInField = filenameInField;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public String getLimitRows() {
        return this.limitRows;
    }

    public void setLimitRows(String limitRows) {
        this.limitRows = limitRows;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public List<FMCandidate> getDelimiterCandidates() {
        return this.delimiterCandidates;
    }

    public void setDelimiterCandidates(List<FMCandidate> delimiterCandidates) {
        this.delimiterCandidates = delimiterCandidates;
    }

    public List<FMCandidate> getEnclosureCandidates() {
        return this.enclosureCandidates;
    }

    public void setEnclosureCandidates(List<FMCandidate> enclosureCandidates) {
        this.enclosureCandidates = enclosureCandidates;
    }

    public static final class FMCandidate {
        @HopMetadataProperty(key="candidate")
        private String candidate;

        public FMCandidate() {
        }

        public FMCandidate(FMCandidate c) {
            this.candidate = c.candidate;
        }

        public FMCandidate(String candidate) {
            this.candidate = candidate;
        }

        public String getCandidate() {
            return this.candidate;
        }

        public void setCandidate(String candidate) {
            this.candidate = candidate;
        }
    }
}

