/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.metainject;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.injection.bean.BeanInjectionInfo;
import org.apache.hop.core.injection.bean.BeanInjector;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.ExecutorUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.metainject.MetaInjectData;
import org.apache.hop.pipeline.transforms.metainject.MetaInjectMeta;
import org.apache.hop.pipeline.transforms.metainject.SourceTransformField;
import org.apache.hop.pipeline.transforms.metainject.TargetTransformAttribute;

public class MetaInject
extends BaseTransform<MetaInjectMeta, MetaInjectData> {
    private static final Class<?> PKG = MetaInject.class;
    private static final Lock repoSaveLock = new ReentrantLock();

    public MetaInject(TransformMeta transformMeta, MetaInjectMeta meta, MetaInjectData data, int copyNr, PipelineMeta pipelineMeta, Pipeline trans) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, trans);
    }

    public boolean processRow() throws HopException {
        String targetFile;
        ((MetaInjectData)this.data).rowMap = new HashMap<String, List<RowMetaAndData>>();
        boolean receivedRows = true;
        for (String prevTransformName : this.getPipelineMeta().getPrevTransformNames(this.getTransformMeta())) {
            if (((MetaInjectData)this.data).streaming && prevTransformName.equalsIgnoreCase(((MetaInjectData)this.data).streamingSourceTransformName)) continue;
            ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
            IRowSet rowSet = this.findInputRowSet(prevTransformName);
            Object[] row = this.getRowFrom(rowSet);
            while (row != null) {
                RowMetaAndData rd = new RowMetaAndData();
                rd.setRowMeta(rowSet.getRowMeta());
                rd.setData(row);
                list.add(rd);
                row = this.getRowFrom(rowSet);
            }
            if (list.isEmpty()) {
                receivedRows = false;
                break;
            }
            ((MetaInjectData)this.data).rowMap.put(prevTransformName, list);
        }
        if (!receivedRows) {
            this.setOutputDone();
            return false;
        }
        List transforms = ((MetaInjectData)this.data).pipelineMeta.getTransforms();
        for (Map.Entry<String, ITransformMeta> en : ((MetaInjectData)this.data).transformInjectionMetasMap.entrySet()) {
            this.newInjection(en.getKey(), en.getValue());
        }
        for (Map.Entry<String, ITransformMeta> en : ((MetaInjectData)this.data).transformInjectionMetasMap.entrySet()) {
            this.newInjectionConstants((IVariables)this, en.getKey(), en.getValue());
        }
        for (Map.Entry<String, ITransformMeta> en : ((MetaInjectData)this.data).transformInjectionMetasMap.entrySet()) {
            en.getValue().resetTransformIoMeta();
            en.getValue().searchInfoAndTargetTransforms(transforms);
        }
        for (String targetTransformName : ((MetaInjectData)this.data).transformInjectionMetasMap.keySet()) {
            TransformMeta targetTransform;
            if (((MetaInjectData)this.data).transformInjectionMetasMap.containsKey(targetTransformName) || (targetTransform = TransformMeta.findTransform((List)transforms, (String)targetTransformName)) == null) continue;
            targetTransform.getTransform().searchInfoAndTargetTransforms(transforms);
        }
        if (!((MetaInjectMeta)this.meta).isNoExecution()) {
            Pipeline injectPipeline = this.createInjectPipeline();
            injectPipeline.setParentPipeline(this.getPipeline());
            injectPipeline.setMetadataProvider(this.getMetadataProvider());
            if (this.getPipeline().getParentWorkflow() != null) {
                injectPipeline.setParentWorkflow(this.getPipeline().getParentWorkflow());
            }
            injectPipeline.copyFrom((IVariables)this);
            injectPipeline.copyParametersFromDefinitions((INamedParameterDefinitions)((MetaInjectData)this.data).pipelineMeta);
            for (String variableName : injectPipeline.getVariableNames()) {
                String variableValue = this.getVariable(variableName);
                if (!StringUtils.isNotEmpty((String)variableValue)) continue;
                injectPipeline.setParameterValue(variableName, variableValue);
            }
            this.getPipeline().addExecutionStoppedListener(e -> injectPipeline.stopAll());
            injectPipeline.setLogLevel(this.getLogLevel());
            injectPipeline.prepareExecution();
            RowProducer rowProducer = ((MetaInjectData)this.data).streaming ? injectPipeline.addRowProducer(((MetaInjectData)this.data).streamingTargetTransformName, 0) : null;
            this.getPipeline().addActiveSubPipeline(this.getTransformName(), (IPipelineEngine)injectPipeline);
            if (!Utils.isEmpty((CharSequence)((MetaInjectMeta)this.meta).getSourceTransformName())) {
                ITransform transformInterface = injectPipeline.getTransform(((MetaInjectMeta)this.meta).getSourceTransformName(), 0);
                if (transformInterface == null) {
                    throw new HopException("Unable to find transform '" + ((MetaInjectMeta)this.meta).getSourceTransformName() + "' to read from.");
                }
                transformInterface.addRowListener((IRowListener)new RowAdapter(){

                    public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                        MetaInject.this.putRow(rowMeta, row);
                    }
                });
            }
            injectPipeline.startThreads();
            Future<HopTransformException> steamingFuture = null;
            if (((MetaInjectData)this.data).streaming) {
                IRowSet rowSet = this.findInputRowSet(((MetaInjectData)this.data).streamingSourceTransformName);
                if (rowSet == null) {
                    throw new HopException("Unable to find transform '" + ((MetaInjectData)this.data).streamingSourceTransformName + "' to stream data from");
                }
                steamingFuture = ExecutorUtil.getExecutor().submit(() -> this.putRows(rowSet, rowProducer));
            }
            while (!(injectPipeline.isFinished() || injectPipeline.isStopped() || this.isStopped())) {
                this.copyResult(injectPipeline);
                try {
                    Thread.sleep(50L);
                }
                catch (Exception rowSet) {}
            }
            this.copyResult(injectPipeline);
            this.waitUntilFinished(injectPipeline);
            try {
                if (steamingFuture != null && steamingFuture.get() != null) {
                    throw steamingFuture.get();
                }
            }
            catch (ExecutionException rowSet) {
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.isDetailed()) {
            this.logDetailed("XML of transformation after injection: " + ((MetaInjectData)this.data).pipelineMeta.getXml((IVariables)this));
        }
        if (!Utils.isEmpty((CharSequence)(targetFile = this.resolve(((MetaInjectMeta)this.meta).getTargetFile())))) {
            this.writeInjectedHpl(targetFile);
        }
        this.setOutputDone();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HopTransformException putRows(IRowSet rowSet, RowProducer rowProducer) {
        try {
            Object[] row;
            while (!this.isStopped() && (row = this.getRowFrom(rowSet)) != null) {
                rowProducer.putRow(rowSet.getRowMeta(), row);
            }
        }
        catch (HopTransformException e) {
            HopTransformException hopTransformException = e;
            return hopTransformException;
        }
        finally {
            rowProducer.finished();
        }
        return null;
    }

    void waitUntilFinished(Pipeline injectTrans) {
        injectTrans.waitUntilFinished();
    }

    Pipeline createInjectPipeline() throws HopException {
        LocalPipelineEngine lpe = new LocalPipelineEngine(((MetaInjectData)this.data).pipelineMeta, (IVariables)this, (ILoggingObject)this);
        if (!Utils.isEmpty((CharSequence)((MetaInjectMeta)this.meta).getRunConfigurationName())) {
            PipelineRunConfiguration prc = (PipelineRunConfiguration)this.metadataProvider.getSerializer(PipelineRunConfiguration.class).load(((MetaInjectMeta)this.meta).getRunConfigurationName());
            lpe.setPipelineRunConfiguration(prc);
        }
        return lpe;
    }

    private void writeInjectedHpl(String targetFilPath) throws HopException {
        this.writeInjectedHplToFs(targetFilPath);
    }

    private void writeInjectedHplToFs(String targetFilePath) throws HopException {
        OutputStream os = null;
        try {
            if (((MetaInjectMeta)this.meta).isCreateParentFolder()) {
                this.createParentFolder(targetFilePath);
            }
            os = HopVfs.getOutputStream((String)targetFilePath, (boolean)false, (IVariables)this.variables);
            os.write(XmlHandler.getXmlHeader().getBytes("UTF-8"));
            os.write(((MetaInjectData)this.data).pipelineMeta.getXml((IVariables)this).getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new HopException("Unable to write target file (hpl after injection) to file '" + targetFilePath + "'", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {
                    throw new HopException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParentFolder(String filename) throws Exception {
        block13: {
            FileObject parentfolder = null;
            try {
                parentfolder = HopVfs.getFileObject((String)filename, (IVariables)this.variables).getParent();
                if (parentfolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"MetaInject.Log.ParentFolderExist", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"MetaInject.Log.ParentFolderNotExist", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                }
                if (((MetaInjectMeta)this.meta).isCreateParentFolder()) {
                    parentfolder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"MetaInject.Log.ParentFolderCreated", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"MetaInject.Log.ParentFolderNotExistCreateIt", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder), HopVfs.getFriendlyURI((String)filename, (IVariables)this.variables)}));
            }
            finally {
                if (parentfolder != null) {
                    try {
                        parentfolder.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void newInjection(String targetTransform, ITransformMeta targetTransformMeta) throws HopException {
        if (this.isDetailed()) {
            this.logDetailed("Handing transform '" + targetTransform + "' injection!");
        }
        BeanInjectionInfo injectionInfo = new BeanInjectionInfo(targetTransformMeta.getClass());
        BeanInjector injector = new BeanInjector(injectionInfo, this.metadataProvider);
        Map<TargetTransformAttribute, SourceTransformField> targetMap = ((MetaInjectMeta)this.meta).getTargetSourceMapping();
        boolean wasInjection = false;
        for (TargetTransformAttribute target : targetMap.keySet()) {
            List<RowMetaAndData> rows;
            SourceTransformField source = targetMap.get(target);
            if (!target.getTransformName().equalsIgnoreCase(targetTransform) || source.getTransformName() == null || (rows = ((MetaInjectData)this.data).rowMap.get(source.getTransformName())) == null || rows.isEmpty()) continue;
            if (injector.hasProperty((Object)targetTransformMeta, target.getAttributeKey())) {
                boolean skip = false;
                for (RowMetaAndData r : rows) {
                    if (r.getRowMeta().indexOfValue(source.getField()) >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"MetaInject.SourceFieldIsNotDefined.Message", (String[])new String[]{source.getField(), this.getPipelineMeta().getName()}));
                    skip = true;
                }
                if (skip) continue;
                injector.setProperty((Object)targetTransformMeta, target.getAttributeKey(), rows, source.getField());
                wasInjection = true;
                continue;
            }
            this.logError(BaseMessages.getString(PKG, (String)"MetaInject.TargetKeyIsNotDefined.Message", (String[])new String[]{target.getAttributeKey(), this.getPipelineMeta().getName()}));
        }
        if (wasInjection) {
            injector.runPostInjectionProcessing((Object)targetTransformMeta);
        }
    }

    private void newInjectionConstants(IVariables variables, String targetTransform, ITransformMeta targetTransformMeta) throws HopException {
        if (this.isDetailed()) {
            this.logDetailed("Handing transform '" + targetTransform + "' constants injection!");
        }
        BeanInjectionInfo injectionInfo = new BeanInjectionInfo(targetTransformMeta.getClass());
        BeanInjector injector = new BeanInjector(injectionInfo, this.metadataProvider);
        Map<TargetTransformAttribute, SourceTransformField> targetMap = ((MetaInjectMeta)this.meta).getTargetSourceMapping();
        for (TargetTransformAttribute target : targetMap.keySet()) {
            SourceTransformField source = targetMap.get(target);
            if (!target.getTransformName().equalsIgnoreCase(targetTransform) || source.getTransformName() != null) continue;
            if (injector.hasProperty((Object)targetTransformMeta, target.getAttributeKey())) {
                String value = variables.resolve(source.getField());
                injector.setProperty((Object)targetTransformMeta, target.getAttributeKey(), null, value);
                continue;
            }
            this.logError(BaseMessages.getString(PKG, (String)"MetaInject.TargetKeyIsNotDefined.Message", (String[])new String[]{target.getAttributeKey(), this.getPipelineMeta().getName()}));
        }
    }

    private void copyResult(Pipeline trans) {
        Result result = trans.getResult();
        this.setLinesInput(result.getNrLinesInput());
        this.setLinesOutput(result.getNrLinesOutput());
        this.setLinesRead(result.getNrLinesRead());
        this.setLinesWritten(result.getNrLinesWritten());
        this.setLinesUpdated(result.getNrLinesUpdated());
        this.setLinesRejected(result.getNrLinesRejected());
        this.setErrors(result.getNrErrors());
    }

    public boolean init() {
        if (super.init()) {
            try {
                ((MetaInjectMeta)this.meta).actualizeMetaInjectMapping();
                ((MetaInjectData)this.data).pipelineMeta = this.loadPipelineMeta();
                this.checkSourceTransformsAvailability();
                this.checkTargetTransformsAvailability();
                ((MetaInjectData)this.data).transformInjectionMetasMap = new HashMap<String, ITransformMeta>();
                for (TransformMeta transformMeta : ((MetaInjectData)this.data).pipelineMeta.getUsedTransforms()) {
                    ITransformMeta meta = transformMeta.getTransform();
                    if (!BeanInjectionInfo.isInjectionSupported(meta.getClass())) continue;
                    ((MetaInjectData)this.data).transformInjectionMetasMap.put(transformMeta.getName(), meta);
                }
                if (((MetaInjectMeta)this.meta).getStreamSourceTransform() != null && !Utils.isEmpty((CharSequence)((MetaInjectMeta)this.meta).getStreamTargetTransformName())) {
                    ((MetaInjectData)this.data).streaming = true;
                    ((MetaInjectData)this.data).streamingSourceTransformName = ((MetaInjectMeta)this.meta).getStreamSourceTransform().getName();
                    ((MetaInjectData)this.data).streamingTargetTransformName = ((MetaInjectMeta)this.meta).getStreamTargetTransformName();
                }
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MetaInject.BadEncoding.Message", (String[])new String[0]), e);
                return false;
            }
        }
        return false;
    }

    private void checkTargetTransformsAvailability() {
        Set<String> existedTransformNames = MetaInject.convertToUpperCaseSet(((MetaInjectData)this.data).pipelineMeta.getTransformNames());
        Map<TargetTransformAttribute, SourceTransformField> targetMap = ((MetaInjectMeta)this.meta).getTargetSourceMapping();
        Set<TargetTransformAttribute> unavailableTargetTransforms = MetaInject.getUnavailableTargetTransforms(targetMap, ((MetaInjectData)this.data).pipelineMeta);
        HashSet<String> alreadyMarkedTransforms = new HashSet<String>();
        for (TargetTransformAttribute currentTarget : unavailableTargetTransforms) {
            if (alreadyMarkedTransforms.contains(currentTarget.getTransformName())) continue;
            alreadyMarkedTransforms.add(currentTarget.getTransformName());
            if (existedTransformNames.contains(currentTarget.getTransformName().toUpperCase())) {
                this.logError(BaseMessages.getString(PKG, (String)"MetaInject.TargetTransformIsNotUsed.Message", (String[])new String[]{currentTarget.getTransformName(), ((MetaInjectData)this.data).pipelineMeta.getName()}));
                continue;
            }
            this.logError(BaseMessages.getString(PKG, (String)"MetaInject.TargetTransformIsNotDefined.Message", (String[])new String[]{currentTarget.getTransformName(), ((MetaInjectData)this.data).pipelineMeta.getName()}));
        }
    }

    public static void removeUnavailableTransformsFromMapping(Map<TargetTransformAttribute, SourceTransformField> targetMap, Set<SourceTransformField> unavailableSourceTransforms, Set<TargetTransformAttribute> unavailableTargetTransforms) {
        Iterator<Map.Entry<TargetTransformAttribute, SourceTransformField>> targetMapIterator = targetMap.entrySet().iterator();
        while (targetMapIterator.hasNext()) {
            Map.Entry<TargetTransformAttribute, SourceTransformField> entry = targetMapIterator.next();
            SourceTransformField currentSourceTransformField = entry.getValue();
            TargetTransformAttribute currentTargetTransformAttribute = entry.getKey();
            if (!unavailableSourceTransforms.contains(currentSourceTransformField) && !unavailableTargetTransforms.contains(currentTargetTransformAttribute)) continue;
            targetMapIterator.remove();
        }
    }

    public static Set<TargetTransformAttribute> getUnavailableTargetTransforms(Map<TargetTransformAttribute, SourceTransformField> targetMap, PipelineMeta injectedPipelineMeta) {
        Set<String> usedTransformNames = MetaInject.getUsedTransformsForReferencedPipeline(injectedPipelineMeta);
        HashSet<TargetTransformAttribute> unavailableTargetTransforms = new HashSet<TargetTransformAttribute>();
        for (TargetTransformAttribute currentTarget : targetMap.keySet()) {
            if (usedTransformNames.contains(currentTarget.getTransformName().toUpperCase())) continue;
            unavailableTargetTransforms.add(currentTarget);
        }
        return Collections.unmodifiableSet(unavailableTargetTransforms);
    }

    public static Set<TargetTransformAttribute> getUnavailableTargetKeys(Map<TargetTransformAttribute, SourceTransformField> targetMap, PipelineMeta injectedPipelineMeta, Set<TargetTransformAttribute> unavailableTargetTransforms) {
        HashSet<TargetTransformAttribute> missingKeys = new HashSet<TargetTransformAttribute>();
        Map<String, BeanInjectionInfo> beanInfos = MetaInject.getUsedTransformBeanInfos(injectedPipelineMeta);
        for (TargetTransformAttribute key : targetMap.keySet()) {
            BeanInjectionInfo info;
            if (unavailableTargetTransforms.contains(key) || (info = beanInfos.get(key.getTransformName().toUpperCase())) == null || info.getProperties().containsKey(key.getAttributeKey())) continue;
            missingKeys.add(key);
        }
        return missingKeys;
    }

    private static Map<String, BeanInjectionInfo> getUsedTransformBeanInfos(PipelineMeta pipelineMeta) {
        HashMap<String, BeanInjectionInfo> res = new HashMap<String, BeanInjectionInfo>();
        for (TransformMeta transformMeta : pipelineMeta.getUsedTransforms()) {
            Class<?> transformMetaClass = transformMeta.getTransform().getClass();
            if (!BeanInjectionInfo.isInjectionSupported(transformMetaClass)) continue;
            res.put(transformMeta.getName().toUpperCase(), new BeanInjectionInfo(transformMetaClass));
        }
        return res;
    }

    private static Set<String> getUsedTransformsForReferencedPipeline(PipelineMeta pipelineMeta) {
        HashSet<String> usedTransformNames = new HashSet<String>();
        for (TransformMeta currentTransform : pipelineMeta.getUsedTransforms()) {
            usedTransformNames.add(currentTransform.getName().toUpperCase());
        }
        return usedTransformNames;
    }

    public static Set<SourceTransformField> getUnavailableSourceTransforms(Map<TargetTransformAttribute, SourceTransformField> targetMap, PipelineMeta sourcePipelineMeta, TransformMeta transformMeta) {
        String[] transformNamesArray = sourcePipelineMeta.getPrevTransformNames(transformMeta);
        Set<String> existedTransformNames = MetaInject.convertToUpperCaseSet(transformNamesArray);
        HashSet<SourceTransformField> unavailableSourceTransforms = new HashSet<SourceTransformField>();
        for (SourceTransformField currentSource : targetMap.values()) {
            if (currentSource.getTransformName() == null || existedTransformNames.contains(currentSource.getTransformName().toUpperCase())) continue;
            unavailableSourceTransforms.add(currentSource);
        }
        return Collections.unmodifiableSet(unavailableSourceTransforms);
    }

    private void checkSourceTransformsAvailability() {
        Map<TargetTransformAttribute, SourceTransformField> targetMap = ((MetaInjectMeta)this.meta).getTargetSourceMapping();
        Set<SourceTransformField> unavailableSourceTransforms = MetaInject.getUnavailableSourceTransforms(targetMap, this.getPipelineMeta(), this.getTransformMeta());
        HashSet<String> alreadyMarkedTransforms = new HashSet<String>();
        for (SourceTransformField currentSource : unavailableSourceTransforms) {
            if (alreadyMarkedTransforms.contains(currentSource.getTransformName())) continue;
            alreadyMarkedTransforms.add(currentSource.getTransformName());
            this.logError(BaseMessages.getString(PKG, (String)"MetaInject.SourceTransformIsNotAvailable.Message", (String[])new String[]{currentSource.getTransformName(), this.getPipelineMeta().getName()}));
        }
    }

    static Set<String> convertToUpperCaseSet(String[] array) {
        if (array == null) {
            return Collections.emptySet();
        }
        HashSet<String> strings = new HashSet<String>();
        for (String currentString : array) {
            strings.add(currentString.toUpperCase());
        }
        return strings;
    }

    PipelineMeta loadPipelineMeta() throws HopException {
        return MetaInjectMeta.loadPipelineMeta((MetaInjectMeta)this.meta, this.getPipeline().getMetadataProvider(), (IVariables)this);
    }
}

