/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.NotFoundException;
import com.google.bigtable.admin.v2.DeleteAuthorizedViewRequest;
import com.google.bigtable.admin.v2.DeleteBackupRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GetAuthorizedViewRequest;
import com.google.bigtable.admin.v2.GetBackupRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.ListAuthorizedViewsRequest;
import com.google.bigtable.admin.v2.ListBackupsRequest;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.RestoreTableMetadata;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.Policy;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.cloud.bigtable.admin.v2.models.ConsistencyRequest;
import com.google.cloud.bigtable.admin.v2.models.CopyBackupRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateAuthorizedViewRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.EncryptionInfo;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.models.OptimizeRestoredTableOperationToken;
import com.google.cloud.bigtable.admin.v2.models.RestoreTableRequest;
import com.google.cloud.bigtable.admin.v2.models.RestoredTableResult;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.admin.v2.models.UpdateAuthorizedViewRequest;
import com.google.cloud.bigtable.admin.v2.models.UpdateBackupRequest;
import com.google.cloud.bigtable.admin.v2.models.UpdateTableRequest;
import com.google.cloud.bigtable.admin.v2.stub.EnhancedBigtableTableAdminStub;
import com.google.cloud.bigtable.data.v2.internal.TableAdminRequestContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public final class BigtableTableAdminClient
implements AutoCloseable {
    private final EnhancedBigtableTableAdminStub stub;
    private final String projectId;
    private final String instanceId;

    public static BigtableTableAdminClient create(@Nonnull String projectId, @Nonnull String instanceId) throws IOException {
        return BigtableTableAdminClient.create(BigtableTableAdminSettings.newBuilder().setProjectId(projectId).setInstanceId(instanceId).build());
    }

    public static BigtableTableAdminClient create(@Nonnull BigtableTableAdminSettings settings) throws IOException {
        TableAdminRequestContext requestContext = TableAdminRequestContext.create(settings.getProjectId(), settings.getInstanceId());
        EnhancedBigtableTableAdminStub stub = EnhancedBigtableTableAdminStub.createEnhanced(settings.getStubSettings(), requestContext);
        return BigtableTableAdminClient.create(settings.getProjectId(), settings.getInstanceId(), stub);
    }

    public static BigtableTableAdminClient create(@Nonnull String projectId, @Nonnull String instanceId, @Nonnull EnhancedBigtableTableAdminStub stub) {
        return new BigtableTableAdminClient(projectId, instanceId, stub);
    }

    private BigtableTableAdminClient(@Nonnull String projectId, @Nonnull String instanceId, @Nonnull EnhancedBigtableTableAdminStub stub) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)instanceId);
        Preconditions.checkNotNull((Object)stub);
        this.projectId = projectId;
        this.instanceId = instanceId;
        this.stub = stub;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public void close() {
        this.stub.close();
    }

    public Table createTable(CreateTableRequest request) {
        return (Table)ApiExceptions.callAndTranslateApiException(this.createTableAsync(request));
    }

    public ApiFuture<Table> createTableAsync(CreateTableRequest request) {
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.createTableCallable().futureCall((Object)request.toProto(this.projectId, this.instanceId)));
    }

    public Table updateTable(UpdateTableRequest request) {
        return (Table)ApiExceptions.callAndTranslateApiException(this.updateTableAsync(request));
    }

    public ApiFuture<Table> updateTableAsync(UpdateTableRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.updateTableOperationCallable().futureCall((Object)request.toProto(this.projectId, this.instanceId)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Table, Table>(){

            public Table apply(com.google.bigtable.admin.v2.Table tableProto) {
                return Table.fromProto(tableProto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Table modifyFamilies(ModifyColumnFamiliesRequest request) {
        return (Table)ApiExceptions.callAndTranslateApiException(this.modifyFamiliesAsync(request));
    }

    public ApiFuture<Table> modifyFamiliesAsync(ModifyColumnFamiliesRequest request) {
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.modifyColumnFamiliesCallable().futureCall((Object)request.toProto(this.projectId, this.instanceId)));
    }

    public void deleteTable(String tableId) {
        ApiExceptions.callAndTranslateApiException(this.deleteTableAsync(tableId));
    }

    public ApiFuture<Void> deleteTableAsync(String tableId) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(this.getTableName(tableId)).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.deleteTableCallable().futureCall((Object)request));
    }

    public boolean exists(String tableId) {
        return (Boolean)ApiExceptions.callAndTranslateApiException(this.existsAsync(tableId));
    }

    public ApiFuture<Boolean> existsAsync(String tableId) {
        ApiFuture<Table> protoFuture = this.getTableAsync(tableId, Table.View.NAME_ONLY);
        ApiFuture existsFuture = ApiFutures.transform(protoFuture, (ApiFunction)new ApiFunction<Table, Boolean>(){

            public Boolean apply(Table ignored) {
                return true;
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.catching((ApiFuture)existsFuture, NotFoundException.class, (ApiFunction)new ApiFunction<NotFoundException, Boolean>(){

            public Boolean apply(NotFoundException ignored) {
                return false;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Table getTable(String tableId) {
        return (Table)ApiExceptions.callAndTranslateApiException(this.getTableAsync(tableId));
    }

    public ApiFuture<Table> getTableAsync(String tableId) {
        return this.getTableAsync(tableId, Table.View.SCHEMA_VIEW);
    }

    private ApiFuture<Table> getTableAsync(String tableId, Table.View view) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(this.getTableName(tableId)).setView(view).build();
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.getTableCallable().futureCall((Object)request));
    }

    public Map<String, List<EncryptionInfo>> getEncryptionInfo(String tableId) {
        return (Map)ApiExceptions.callAndTranslateApiException(this.getEncryptionInfoAsync(tableId));
    }

    public ApiFuture<Map<String, List<EncryptionInfo>>> getEncryptionInfoAsync(String tableId) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(this.getTableName(tableId)).setView(Table.View.ENCRYPTION_VIEW).build();
        return ApiFutures.transform((ApiFuture)this.stub.getTableCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Table, Map<String, List<EncryptionInfo>>>(){

            public Map<String, List<EncryptionInfo>> apply(com.google.bigtable.admin.v2.Table table) {
                ImmutableMap.Builder result = ImmutableMap.builder();
                for (Map.Entry entry : table.getClusterStatesMap().entrySet()) {
                    ImmutableList.Builder infos = ImmutableList.builder();
                    for (com.google.bigtable.admin.v2.EncryptionInfo infoProto : ((Table.ClusterState)entry.getValue()).getEncryptionInfoList()) {
                        infos.add((Object)EncryptionInfo.fromProto(infoProto));
                    }
                    result.put((Object)((String)entry.getKey()), (Object)infos.build());
                }
                return result.build();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public List<String> listTables() {
        return (List)ApiExceptions.callAndTranslateApiException(this.listTablesAsync());
    }

    public ApiFuture<List<String>> listTablesAsync() {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(NameUtil.formatInstanceName(this.projectId, this.instanceId)).build();
        ApiFuture firstPageFuture = ApiFutures.transform((ApiFuture)this.stub.listTablesPagedCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<BaseBigtableTableAdminClient.ListTablesPagedResponse, BaseBigtableTableAdminClient.ListTablesPage>(){

            public BaseBigtableTableAdminClient.ListTablesPage apply(BaseBigtableTableAdminClient.ListTablesPagedResponse response) {
                return (BaseBigtableTableAdminClient.ListTablesPage)response.getPage();
            }
        }, (Executor)MoreExecutors.directExecutor());
        ApiFuture allProtos = ApiFutures.transformAsync((ApiFuture)firstPageFuture, (ApiAsyncFunction)new ApiAsyncFunction<BaseBigtableTableAdminClient.ListTablesPage, List<com.google.bigtable.admin.v2.Table>>(){
            List<com.google.bigtable.admin.v2.Table> responseAccumulator = Lists.newArrayList();

            public ApiFuture<List<com.google.bigtable.admin.v2.Table>> apply(BaseBigtableTableAdminClient.ListTablesPage page) {
                this.responseAccumulator.addAll(Lists.newArrayList((Iterable)page.getValues()));
                if (!page.hasNextPage()) {
                    return ApiFutures.immediateFuture(this.responseAccumulator);
                }
                return ApiFutures.transformAsync((ApiFuture)page.getNextPageAsync(), (ApiAsyncFunction)this, (Executor)MoreExecutors.directExecutor());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.transform((ApiFuture)allProtos, (ApiFunction)new ApiFunction<List<com.google.bigtable.admin.v2.Table>, List<String>>(){

            public List<String> apply(List<com.google.bigtable.admin.v2.Table> protos) {
                ArrayList results = Lists.newArrayListWithCapacity((int)protos.size());
                for (com.google.bigtable.admin.v2.Table proto : protos) {
                    results.add(NameUtil.extractTableIdFromTableName(proto.getName()));
                }
                return results;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void dropRowRange(String tableId, String rowKeyPrefix) {
        ApiExceptions.callAndTranslateApiException(this.dropRowRangeAsync(tableId, rowKeyPrefix));
    }

    public ApiFuture<Void> dropRowRangeAsync(String tableId, String rowKeyPrefix) {
        return this.dropRowRangeAsync(tableId, ByteString.copyFromUtf8((String)rowKeyPrefix));
    }

    public void dropRowRange(String tableId, ByteString rowKeyPrefix) {
        ApiExceptions.callAndTranslateApiException(this.dropRowRangeAsync(tableId, rowKeyPrefix));
    }

    public ApiFuture<Void> dropRowRangeAsync(String tableId, ByteString rowKeyPrefix) {
        DropRowRangeRequest request = DropRowRangeRequest.newBuilder().setName(this.getTableName(tableId)).setRowKeyPrefix(rowKeyPrefix).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.dropRowRangeCallable().futureCall((Object)request));
    }

    public void dropAllRows(String tableId) {
        ApiExceptions.callAndTranslateApiException(this.dropAllRowsAsync(tableId));
    }

    public ApiFuture<Void> dropAllRowsAsync(String tableId) {
        DropRowRangeRequest request = DropRowRangeRequest.newBuilder().setName(this.getTableName(tableId)).setDeleteAllDataFromTable(true).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.dropRowRangeCallable().futureCall((Object)request));
    }

    public void awaitReplication(String tableId) {
        TableName tableName = TableName.of((String)this.projectId, (String)this.instanceId, (String)tableId);
        ApiExceptions.callAndTranslateApiException((ApiFuture)this.stub.awaitReplicationCallable().futureCall((Object)tableName));
    }

    public void awaitConsistency(ConsistencyRequest consistencyRequest) {
        ApiExceptions.callAndTranslateApiException((ApiFuture)this.stub.awaitConsistencyCallable().futureCall((Object)consistencyRequest));
    }

    public Backup createBackup(CreateBackupRequest request) {
        return (Backup)ApiExceptions.callAndTranslateApiException(this.createBackupAsync(request));
    }

    public ApiFuture<Backup> createBackupAsync(CreateBackupRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.createBackupOperationCallable().futureCall((Object)request.toProto(this.projectId, this.instanceId)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Backup, Backup>(){

            public Backup apply(com.google.bigtable.admin.v2.Backup backupProto) {
                return Backup.fromProto(backupProto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Backup getBackup(String clusterId, String backupId) {
        return (Backup)ApiExceptions.callAndTranslateApiException(this.getBackupAsync(clusterId, backupId));
    }

    public ApiFuture<Backup> getBackupAsync(String clusterId, String backupId) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(NameUtil.formatBackupName(this.projectId, this.instanceId, clusterId, backupId)).build();
        return ApiFutures.transform((ApiFuture)this.stub.getBackupCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Backup, Backup>(){

            public Backup apply(com.google.bigtable.admin.v2.Backup backup) {
                return Backup.fromProto(backup);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public List<String> listBackups(String clusterId) {
        return (List)ApiExceptions.callAndTranslateApiException(this.listBackupsAsync(clusterId));
    }

    public ApiFuture<List<String>> listBackupsAsync(String clusterId) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(NameUtil.formatClusterName(this.projectId, this.instanceId, clusterId)).build();
        ApiFuture firstPageFuture = ApiFutures.transform((ApiFuture)this.stub.listBackupsPagedCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<BaseBigtableTableAdminClient.ListBackupsPagedResponse, BaseBigtableTableAdminClient.ListBackupsPage>(){

            public BaseBigtableTableAdminClient.ListBackupsPage apply(BaseBigtableTableAdminClient.ListBackupsPagedResponse response) {
                return (BaseBigtableTableAdminClient.ListBackupsPage)response.getPage();
            }
        }, (Executor)MoreExecutors.directExecutor());
        ApiFuture allProtos = ApiFutures.transformAsync((ApiFuture)firstPageFuture, (ApiAsyncFunction)new ApiAsyncFunction<BaseBigtableTableAdminClient.ListBackupsPage, List<com.google.bigtable.admin.v2.Backup>>(){
            List<com.google.bigtable.admin.v2.Backup> responseAccumulator = Lists.newArrayList();

            public ApiFuture<List<com.google.bigtable.admin.v2.Backup>> apply(BaseBigtableTableAdminClient.ListBackupsPage page) {
                this.responseAccumulator.addAll(Lists.newArrayList((Iterable)page.getValues()));
                if (!page.hasNextPage()) {
                    return ApiFutures.immediateFuture(this.responseAccumulator);
                }
                return ApiFutures.transformAsync((ApiFuture)page.getNextPageAsync(), (ApiAsyncFunction)this, (Executor)MoreExecutors.directExecutor());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.transform((ApiFuture)allProtos, (ApiFunction)new ApiFunction<List<com.google.bigtable.admin.v2.Backup>, List<String>>(){

            public List<String> apply(List<com.google.bigtable.admin.v2.Backup> protos) {
                ArrayList results = Lists.newArrayListWithCapacity((int)protos.size());
                for (com.google.bigtable.admin.v2.Backup proto : protos) {
                    results.add(NameUtil.extractBackupIdFromBackupName(proto.getName()));
                }
                return results;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void deleteBackup(String clusterId, String backupId) {
        ApiExceptions.callAndTranslateApiException(this.deleteBackupAsync(clusterId, backupId));
    }

    public ApiFuture<Void> deleteBackupAsync(String clusterId, String backupId) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(NameUtil.formatBackupName(this.projectId, this.instanceId, clusterId, backupId)).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.deleteBackupCallable().futureCall((Object)request));
    }

    public Backup updateBackup(UpdateBackupRequest request) {
        return (Backup)ApiExceptions.callAndTranslateApiException(this.updateBackupAsync(request));
    }

    public ApiFuture<Backup> updateBackupAsync(UpdateBackupRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.updateBackupCallable().futureCall((Object)request.toProto(this.projectId, this.instanceId)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Backup, Backup>(){

            public Backup apply(com.google.bigtable.admin.v2.Backup proto) {
                return Backup.fromProto(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public RestoredTableResult restoreTable(RestoreTableRequest request) throws ExecutionException, InterruptedException {
        return (RestoredTableResult)ApiExceptions.callAndTranslateApiException(this.restoreTableAsync(request));
    }

    public ApiFuture<RestoredTableResult> restoreTableAsync(RestoreTableRequest request) {
        final OperationFuture future = this.stub.restoreTableOperationCallable().futureCall((Object)request.toProto(this.projectId, this.instanceId));
        return ApiFutures.transformAsync((ApiFuture)future, (ApiAsyncFunction)new ApiAsyncFunction<com.google.bigtable.admin.v2.Table, RestoredTableResult>(){

            public ApiFuture<RestoredTableResult> apply(com.google.bigtable.admin.v2.Table table) throws Exception {
                return ApiFutures.immediateFuture((Object)new RestoredTableResult(Table.fromProto(table), ((RestoreTableMetadata)future.getMetadata().get()).getOptimizeTableOperationName()));
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void awaitOptimizeRestoredTable(OptimizeRestoredTableOperationToken token) throws ExecutionException, InterruptedException {
        this.awaitOptimizeRestoredTableAsync(token).get();
    }

    public ApiFuture<Void> awaitOptimizeRestoredTableAsync(OptimizeRestoredTableOperationToken token) {
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.awaitOptimizeRestoredTableCallable().resumeFutureCall(token.getOperationName()));
    }

    public Backup copyBackup(CopyBackupRequest request) {
        return (Backup)ApiExceptions.callAndTranslateApiException(this.copyBackupAsync(request));
    }

    public ApiFuture<Backup> copyBackupAsync(CopyBackupRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.copyBackupOperationCallable().futureCall((Object)request.toProto(this.projectId, this.instanceId)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Backup, Backup>(){

            public Backup apply(com.google.bigtable.admin.v2.Backup backupProto) {
                return Backup.fromProto(backupProto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ApiFuture<Void> awaitReplicationAsync(String tableId) {
        TableName tableName = TableName.of((String)this.projectId, (String)this.instanceId, (String)tableId);
        return this.stub.awaitReplicationCallable().futureCall((Object)tableName);
    }

    public AuthorizedView createAuthorizedView(CreateAuthorizedViewRequest request) {
        return (AuthorizedView)ApiExceptions.callAndTranslateApiException(this.createAuthorizedViewAsync(request));
    }

    public ApiFuture<AuthorizedView> createAuthorizedViewAsync(CreateAuthorizedViewRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.createAuthorizedViewOperationCallable().futureCall((Object)request.toProto(this.projectId, this.instanceId)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.AuthorizedView, AuthorizedView>(){

            public AuthorizedView apply(com.google.bigtable.admin.v2.AuthorizedView authorizedViewProto) {
                return AuthorizedView.fromProto(authorizedViewProto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public AuthorizedView updateAuthorizedView(UpdateAuthorizedViewRequest request) {
        return (AuthorizedView)ApiExceptions.callAndTranslateApiException(this.updateAuthorizedViewAsync(request));
    }

    public ApiFuture<AuthorizedView> updateAuthorizedViewAsync(UpdateAuthorizedViewRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.updateAuthorizedViewOperationCallable().futureCall((Object)request.toProto(this.projectId, this.instanceId)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.AuthorizedView, AuthorizedView>(){

            public AuthorizedView apply(com.google.bigtable.admin.v2.AuthorizedView authorizedViewProto) {
                return AuthorizedView.fromProto(authorizedViewProto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public AuthorizedView getAuthorizedView(String tableId, String authorizedViewId) {
        return (AuthorizedView)ApiExceptions.callAndTranslateApiException(this.getAuthorizedViewAsync(tableId, authorizedViewId));
    }

    public ApiFuture<AuthorizedView> getAuthorizedViewAsync(String tableId, String authorizedViewId) {
        GetAuthorizedViewRequest request = GetAuthorizedViewRequest.newBuilder().setName(NameUtil.formatAuthorizedViewName(this.projectId, this.instanceId, tableId, authorizedViewId)).build();
        return ApiFutures.transform((ApiFuture)this.stub.getAuthorizedViewCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.AuthorizedView, AuthorizedView>(){

            public AuthorizedView apply(com.google.bigtable.admin.v2.AuthorizedView authorizedViewProto) {
                return AuthorizedView.fromProto(authorizedViewProto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public List<String> listAuthorizedViews(String tableId) {
        return (List)ApiExceptions.callAndTranslateApiException(this.listAuthorizedViewsAsync(tableId));
    }

    public ApiFuture<List<String>> listAuthorizedViewsAsync(String tableId) {
        ListAuthorizedViewsRequest request = ListAuthorizedViewsRequest.newBuilder().setParent(NameUtil.formatTableName(this.projectId, this.instanceId, tableId)).build();
        ApiFuture firstPageFuture = ApiFutures.transform((ApiFuture)this.stub.listAuthorizedViewsPagedCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<BaseBigtableTableAdminClient.ListAuthorizedViewsPagedResponse, BaseBigtableTableAdminClient.ListAuthorizedViewsPage>(){

            public BaseBigtableTableAdminClient.ListAuthorizedViewsPage apply(BaseBigtableTableAdminClient.ListAuthorizedViewsPagedResponse response) {
                return (BaseBigtableTableAdminClient.ListAuthorizedViewsPage)response.getPage();
            }
        }, (Executor)MoreExecutors.directExecutor());
        ApiFuture allProtos = ApiFutures.transformAsync((ApiFuture)firstPageFuture, (ApiAsyncFunction)new ApiAsyncFunction<BaseBigtableTableAdminClient.ListAuthorizedViewsPage, List<com.google.bigtable.admin.v2.AuthorizedView>>(){
            List<com.google.bigtable.admin.v2.AuthorizedView> responseAccumulator = Lists.newArrayList();

            public ApiFuture<List<com.google.bigtable.admin.v2.AuthorizedView>> apply(BaseBigtableTableAdminClient.ListAuthorizedViewsPage page) {
                this.responseAccumulator.addAll(Lists.newArrayList((Iterable)page.getValues()));
                if (!page.hasNextPage()) {
                    return ApiFutures.immediateFuture(this.responseAccumulator);
                }
                return ApiFutures.transformAsync((ApiFuture)page.getNextPageAsync(), (ApiAsyncFunction)this, (Executor)MoreExecutors.directExecutor());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.transform((ApiFuture)allProtos, (ApiFunction)new ApiFunction<List<com.google.bigtable.admin.v2.AuthorizedView>, List<String>>(){

            public List<String> apply(List<com.google.bigtable.admin.v2.AuthorizedView> protos) {
                ArrayList results = Lists.newArrayListWithCapacity((int)protos.size());
                for (com.google.bigtable.admin.v2.AuthorizedView proto : protos) {
                    results.add(NameUtil.extractAuthorizedViewIdFromAuthorizedViewName(proto.getName()));
                }
                return results;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void deleteAuthorizedView(String tableId, String authorizedViewId) {
        ApiExceptions.callAndTranslateApiException(this.deleteAuthorizedViewAsync(tableId, authorizedViewId));
    }

    public ApiFuture<Void> deleteAuthorizedViewAsync(String tableId, String authorizedViewId) {
        DeleteAuthorizedViewRequest request = DeleteAuthorizedViewRequest.newBuilder().setName(NameUtil.formatAuthorizedViewName(this.projectId, this.instanceId, tableId, authorizedViewId)).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.deleteAuthorizedViewCallable().futureCall((Object)request));
    }

    private String getTableName(String tableId) {
        return NameUtil.formatTableName(this.projectId, this.instanceId, tableId);
    }

    private static ApiFuture<Table> transformToTableResponse(ApiFuture<com.google.bigtable.admin.v2.Table> future) {
        return ApiFutures.transform(future, (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Table, Table>(){

            public Table apply(com.google.bigtable.admin.v2.Table table) {
                return Table.fromProto(table);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static ApiFuture<Void> transformToVoid(ApiFuture<Empty> future) {
        return ApiFutures.transform(future, (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty empty) {
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Policy getIamPolicy(String tableId) {
        return (Policy)ApiExceptions.callAndTranslateApiException(this.getIamPolicyAsync(tableId));
    }

    public ApiFuture<Policy> getIamPolicyAsync(String tableId) {
        String tableName = NameUtil.formatTableName(this.projectId, this.instanceId, tableId);
        return this.getResourceIamPolicy(tableName);
    }

    public Policy setIamPolicy(String tableId, Policy policy) {
        return (Policy)ApiExceptions.callAndTranslateApiException(this.setIamPolicyAsync(tableId, policy));
    }

    public ApiFuture<Policy> setIamPolicyAsync(String tableId, Policy policy) {
        String tableName = NameUtil.formatTableName(this.projectId, this.instanceId, tableId);
        return this.setResourceIamPolicy(policy, tableName);
    }

    public List<String> testIamPermission(String tableId, String ... permissions) {
        return (List)ApiExceptions.callAndTranslateApiException(this.testIamPermissionAsync(tableId, permissions));
    }

    public ApiFuture<List<String>> testIamPermissionAsync(String tableId, String ... permissions) {
        String tableName = NameUtil.formatTableName(this.projectId, this.instanceId, tableId);
        return this.testResourceIamPermissions(tableName, permissions);
    }

    public Policy getBackupIamPolicy(String clusterId, String backupId) {
        return (Policy)ApiExceptions.callAndTranslateApiException(this.getBackupIamPolicyAsync(clusterId, backupId));
    }

    public ApiFuture<Policy> getBackupIamPolicyAsync(String clusterId, String backupId) {
        String backupName = NameUtil.formatBackupName(this.projectId, this.instanceId, clusterId, backupId);
        return this.getResourceIamPolicy(backupName);
    }

    public Policy setBackupIamPolicy(String clusterId, String backupId, Policy policy) {
        return (Policy)ApiExceptions.callAndTranslateApiException(this.setBackupIamPolicyAsync(clusterId, backupId, policy));
    }

    public ApiFuture<Policy> setBackupIamPolicyAsync(String clusterId, String backupId, Policy policy) {
        String backupName = NameUtil.formatBackupName(this.projectId, this.instanceId, clusterId, backupId);
        return this.setResourceIamPolicy(policy, backupName);
    }

    public List<String> testBackupIamPermission(String clusterId, String backupId, String ... permissions) {
        return (List)ApiExceptions.callAndTranslateApiException(this.testBackupIamPermissionAsync(clusterId, backupId, permissions));
    }

    public ApiFuture<List<String>> testBackupIamPermissionAsync(String clusterId, String backupId, String ... permissions) {
        String backupName = NameUtil.formatBackupName(this.projectId, this.instanceId, clusterId, backupId);
        return this.testResourceIamPermissions(backupName, permissions);
    }

    public Policy getAuthorizedViewIamPolicy(String tableId, String authorizedViewId) {
        return (Policy)ApiExceptions.callAndTranslateApiException(this.getAuthorizedViewIamPolicyAsync(tableId, authorizedViewId));
    }

    public ApiFuture<Policy> getAuthorizedViewIamPolicyAsync(String tableId, String authorizedViewId) {
        String authorizedViewName = NameUtil.formatAuthorizedViewName(this.projectId, this.instanceId, tableId, authorizedViewId);
        return this.getResourceIamPolicy(authorizedViewName);
    }

    public Policy setAuthorizedViewIamPolicy(String tableId, String authorizedViewId, Policy policy) {
        return (Policy)ApiExceptions.callAndTranslateApiException(this.setAuthorizedViewIamPolicyAsync(tableId, authorizedViewId, policy));
    }

    public ApiFuture<Policy> setAuthorizedViewIamPolicyAsync(String tableId, String authorizedViewId, Policy policy) {
        String authorizedViewName = NameUtil.formatAuthorizedViewName(this.projectId, this.instanceId, tableId, authorizedViewId);
        return this.setResourceIamPolicy(policy, authorizedViewName);
    }

    public List<String> testAuthorizedViewIamPermission(String tableId, String authorizedViewId, String ... permissions) {
        return (List)ApiExceptions.callAndTranslateApiException(this.testAuthorizedViewIamPermissionAsync(tableId, authorizedViewId, permissions));
    }

    public ApiFuture<List<String>> testAuthorizedViewIamPermissionAsync(String tableId, String authorizedViewId, String ... permissions) {
        String authorizedViewName = NameUtil.formatAuthorizedViewName(this.projectId, this.instanceId, tableId, authorizedViewId);
        return this.testResourceIamPermissions(authorizedViewName, permissions);
    }

    private ApiFuture<Policy> getResourceIamPolicy(String name) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(name).build();
        final IamPolicyMarshaller marshaller = new IamPolicyMarshaller();
        return ApiFutures.transform((ApiFuture)this.stub.getIamPolicyCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.iam.v1.Policy, Policy>(){

            public Policy apply(com.google.iam.v1.Policy proto) {
                return marshaller.fromPb(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<Policy> setResourceIamPolicy(Policy policy, String name) {
        final IamPolicyMarshaller marshaller = new IamPolicyMarshaller();
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(name).setPolicy(marshaller.toPb(policy)).build();
        return ApiFutures.transform((ApiFuture)this.stub.setIamPolicyCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.iam.v1.Policy, Policy>(){

            public Policy apply(com.google.iam.v1.Policy proto) {
                return marshaller.fromPb(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<List<String>> testResourceIamPermissions(String resourceName, String[] permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resourceName).addAllPermissions(Arrays.asList(permissions)).build();
        return ApiFutures.transform((ApiFuture)this.stub.testIamPermissionsCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<TestIamPermissionsResponse, List<String>>(){

            public List<String> apply(TestIamPermissionsResponse input) {
                return input.getPermissionsList();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static class IamPolicyMarshaller
    extends Policy.DefaultMarshaller {
        private IamPolicyMarshaller() {
        }

        public Policy fromPb(com.google.iam.v1.Policy policyPb) {
            return super.fromPb(policyPb);
        }

        public com.google.iam.v1.Policy toPb(Policy policy) {
            return super.toPb(policy);
        }
    }
}

