/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p69p0.com.google.auth.oauth2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.api.client.json.GenericJson;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.api.client.json.JsonObjectParser;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.auth.oauth2.ExternalAccountSupplierContext;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.auth.oauth2.IdentityPoolCredentialSource;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.auth.oauth2.IdentityPoolSubjectTokenSupplier;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.auth.oauth2.OAuth2Utils;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.common.io.CharStreams;

class FileIdentityPoolSubjectTokenSupplier
implements IdentityPoolSubjectTokenSupplier {
    private final long serialVersionUID = 2475549052347431992L;
    private final IdentityPoolCredentialSource credentialSource;

    FileIdentityPoolSubjectTokenSupplier(IdentityPoolCredentialSource credentialSource) {
        this.credentialSource = credentialSource;
    }

    @Override
    public String getSubjectToken(ExternalAccountSupplierContext context) throws IOException {
        String credentialFilePath = this.credentialSource.credentialLocation;
        if (!Files.exists(Paths.get(credentialFilePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new IOException(String.format("Invalid credential location. The file at %s does not exist.", credentialFilePath));
        }
        try {
            return FileIdentityPoolSubjectTokenSupplier.parseToken(new FileInputStream(new File(credentialFilePath)), this.credentialSource);
        }
        catch (IOException e) {
            throw new IOException("Error when attempting to read the subject token from the credential file.", e);
        }
    }

    static String parseToken(InputStream inputStream, IdentityPoolCredentialSource credentialSource) throws IOException {
        if (credentialSource.credentialFormatType == IdentityPoolCredentialSource.CredentialFormatType.TEXT) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return CharStreams.toString(reader);
        }
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        GenericJson fileContents = parser.parseAndClose(inputStream, StandardCharsets.UTF_8, GenericJson.class);
        if (!fileContents.containsKey(credentialSource.subjectTokenFieldName)) {
            throw new IOException("Invalid subject token field name. No subject token was found.");
        }
        return (String)fileContents.get(credentialSource.subjectTokenFieldName);
    }
}

