/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p69p0.io.grpc.grpclb;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Attributes;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.EquivalentAddressGroup;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.NameResolver;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.grpclb.GrpclbConstants;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.internal.DnsNameResolver;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.internal.SharedResourceHolder;

final class GrpclbNameResolver
extends DnsNameResolver {
    private static final Logger logger = Logger.getLogger(GrpclbNameResolver.class.getName());
    private static final String GRPCLB_NAME_PREFIX = "_grpclb._tcp.";

    GrpclbNameResolver(@Nullable String nsAuthority, String name, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource, Stopwatch stopwatch, boolean isAndroid) {
        super(nsAuthority, name, args, executorResource, stopwatch, isAndroid);
    }

    @Override
    protected DnsNameResolver.InternalResolutionResult doResolve(boolean forceTxt) {
        List<EquivalentAddressGroup> balancerAddrs = this.resolveBalancerAddresses();
        DnsNameResolver.InternalResolutionResult result = super.doResolve(!balancerAddrs.isEmpty());
        if (!balancerAddrs.isEmpty()) {
            result.attributes = Attributes.newBuilder().set(GrpclbConstants.ATTR_LB_ADDRS, balancerAddrs).build();
        }
        return result;
    }

    private List<EquivalentAddressGroup> resolveBalancerAddresses() {
        List<Object> srvRecords = Collections.emptyList();
        Exception srvRecordsException = null;
        DnsNameResolver.ResourceResolver resourceResolver = this.getResourceResolver();
        if (resourceResolver != null) {
            try {
                if (!this.getHost().equals("metadata.google.internal.")) {
                    srvRecords = resourceResolver.resolveSrv(GRPCLB_NAME_PREFIX + this.getHost());
                }
            }
            catch (Exception e) {
                srvRecordsException = e;
            }
        }
        ArrayList<EquivalentAddressGroup> balancerAddresses = new ArrayList<EquivalentAddressGroup>(srvRecords.size());
        Exception balancerAddressesException = null;
        Level level = Level.WARNING;
        for (DnsNameResolver.SrvRecord record : srvRecords) {
            try {
                String authority = record.host.substring(0, record.host.length() - 1);
                List<InetAddress> addrs = this.addressResolver.resolveAddress(record.host);
                ArrayList<InetSocketAddress> sockAddrs = new ArrayList<InetSocketAddress>(addrs.size());
                for (InetAddress addr : addrs) {
                    sockAddrs.add(new InetSocketAddress(addr, record.port));
                }
                Attributes attrs = Attributes.newBuilder().set(GrpclbConstants.ATTR_LB_ADDR_AUTHORITY, authority).build();
                balancerAddresses.add(new EquivalentAddressGroup(Collections.unmodifiableList(sockAddrs), attrs));
            }
            catch (Exception e) {
                logger.log(level, "Can't find address for SRV record " + record, e);
                if (balancerAddressesException != null) continue;
                balancerAddressesException = e;
                level = Level.FINE;
            }
        }
        if (srvRecordsException != null) {
            logger.log(Level.FINE, "SRV lookup failure", srvRecordsException);
        } else if (balancerAddressesException != null && balancerAddresses.isEmpty()) {
            logger.log(Level.FINE, "SRV-provided hostname lookup failure", balancerAddressesException);
        }
        return Collections.unmodifiableList(balancerAddresses);
    }

    @Override
    @VisibleForTesting
    protected void setAddressResolver(DnsNameResolver.AddressResolver addressResolver) {
        super.setAddressResolver(addressResolver);
    }

    @Override
    @VisibleForTesting
    protected void setResourceResolver(DnsNameResolver.ResourceResolver resourceResolver) {
        super.setResourceResolver(resourceResolver);
    }

    @Override
    @VisibleForTesting
    protected String getHost() {
        return super.getHost();
    }

    @VisibleForTesting
    static void setEnableTxt(boolean enableTxt) {
        DnsNameResolver.enableTxt = enableTxt;
    }
}

