/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.TableConstraints;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.Serializable;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.providers.BigQueryWriteConfiguration;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.RowFilter;
import org.apache.beam.sdk.util.RowStringInterpolator;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class PortableBigQueryDestinations
extends DynamicDestinations<Row, String> {
    public static final @UnknownKeyFor @NonNull @Initialized String DESTINATION = "destination";
    public static final @UnknownKeyFor @NonNull @Initialized String RECORD = "record";
    private @MonotonicNonNull @UnknownKeyFor @Initialized RowStringInterpolator interpolator = null;
    private final @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> primaryKey;
    private final @UnknownKeyFor @NonNull @Initialized RowFilter rowFilter;
    private final @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> clusteringFields;

    public PortableBigQueryDestinations(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.schemas.Schema rowSchema, @UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration configuration) {
        this.clusteringFields = configuration.getClusteringFields();
        if (!configuration.getTable().equals("DYNAMIC_DESTINATIONS")) {
            this.interpolator = new RowStringInterpolator(configuration.getTable(), rowSchema);
        }
        this.primaryKey = configuration.getPrimaryKey();
        RowFilter rf = new RowFilter(rowSchema);
        if (configuration.getDrop() != null) {
            rf = rf.drop((List)Preconditions.checkStateNotNull(configuration.getDrop()));
        }
        if (configuration.getKeep() != null) {
            rf = rf.keep((List)Preconditions.checkStateNotNull(configuration.getKeep()));
        }
        if (configuration.getOnly() != null) {
            rf = rf.only((String)Preconditions.checkStateNotNull((Object)configuration.getOnly()));
        }
        this.rowFilter = rf;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getDestination(@Nullable @UnknownKeyFor @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized Row> element) {
        if (this.interpolator != null) {
            return this.interpolator.interpolate((ValueInSingleWindow)Preconditions.checkArgumentNotNull(element));
        }
        return (String)Preconditions.checkStateNotNull((Object)((Row)((ValueInSingleWindow)Preconditions.checkStateNotNull(element)).getValue()).getString(DESTINATION));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TableDestination getTable(@UnknownKeyFor @NonNull @Initialized String destination) {
        if (this.clusteringFields != null && !this.clusteringFields.isEmpty()) {
            Clustering clustering = new Clustering().setFields(this.clusteringFields);
            return new TableDestination(destination, null, null, clustering);
        }
        return new TableDestination(destination, null);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized TableSchema getSchema(@UnknownKeyFor @NonNull @Initialized String destination) {
        return BigQueryUtils.toTableSchema(this.rowFilter.outputSchema());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized TableConstraints getTableConstraints(@UnknownKeyFor @NonNull @Initialized String destination) {
        if (this.primaryKey != null) {
            return new TableConstraints().setPrimaryKey(new TableConstraints.PrimaryKey().setColumns(this.primaryKey));
        }
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized TableRow> getFilterFormatFunction(@UnknownKeyFor @NonNull @Initialized boolean fetchNestedRecord) {
        return (SerializableFunction & Serializable)row -> {
            if (fetchNestedRecord) {
                row = (Row)Preconditions.checkStateNotNull((Object)row.getRow(RECORD));
            }
            Row filtered = this.rowFilter.filter(row);
            return BigQueryUtils.toTableRow(filtered);
        };
    }

    public @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized GenericRecord> getAvroFilterFormatFunction(@UnknownKeyFor @NonNull @Initialized boolean fetchNestedRecord) {
        return (SerializableFunction & Serializable)request -> {
            Row row = (Row)request.getElement();
            if (fetchNestedRecord) {
                row = (Row)Preconditions.checkStateNotNull((Object)row.getRow(RECORD));
            }
            Row filtered = this.rowFilter.filter(row);
            return AvroUtils.toGenericRecord((Row)filtered, (Schema)request.getSchema());
        };
    }
}

