/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;

public class AS400Structure
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private AS400DataType[] elements_ = null;
    private transient Object elementsLock_;
    private transient Object[] defaultValue_;
    private boolean allowChanges_ = true;

    public AS400Structure() {
        this.initializeTransient();
    }

    public AS400Structure(AS400DataType[] members) {
        if (members == null) {
            throw new NullPointerException("members");
        }
        this.initializeTransient();
        AS400DataType[] newMembers = new AS400DataType[members.length];
        for (int i = 0; i < members.length; ++i) {
            newMembers[i] = (AS400DataType)members[i].clone();
        }
        this.allowChanges_ = false;
        this.elements_ = newMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        try {
            AS400Structure nObj = (AS400Structure)super.clone();
            if (this.elements_ == null) {
                return nObj;
            }
            Object object = this.elementsLock_;
            synchronized (object) {
                AS400DataType[] newMembers = new AS400DataType[this.elements_.length];
                for (int i = 0; i < this.elements_.length; ++i) {
                    newMembers[i] = (AS400DataType)this.elements_[i].clone();
                }
                nObj.elements_ = newMembers;
                return nObj;
            }
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getByteLength() {
        if (this.elements_ == null) {
            throw new ExtendedIllegalStateException("Members", 4);
        }
        Object object = this.elementsLock_;
        synchronized (object) {
            this.allowChanges_ = false;
            int totalSize = 0;
            for (int i = 0; i < this.elements_.length; ++i) {
                totalSize += this.elements_[i].getByteLength();
            }
            return totalSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getDefaultValue() {
        Object object = this.elementsLock_;
        synchronized (object) {
            if (this.defaultValue_ == null) {
                int numElements = this.elements_.length;
                this.defaultValue_ = new Object[numElements];
                for (int i = 0; i < numElements; ++i) {
                    this.defaultValue_[i] = this.elements_[i].getDefaultValue();
                }
            }
            return this.defaultValue_;
        }
    }

    @Override
    public int getInstanceType() {
        return 8;
    }

    @Override
    public Class getJavaType() {
        return Object[].class;
    }

    public int getNumberOfMembers() {
        return this.elements_ == null ? -1 : this.elements_.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AS400DataType[] getMembers() {
        if (this.elements_ == null) {
            return null;
        }
        Object object = this.elementsLock_;
        synchronized (object) {
            AS400DataType[] newMembers = new AS400DataType[this.elements_.length];
            for (int i = 0; i < this.elements_.length; ++i) {
                newMembers[i] = (AS400DataType)this.elements_[i].clone();
            }
            return newMembers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AS400DataType getMembers(int index) {
        if (this.elements_ == null) {
            throw new ExtendedIllegalStateException("Members", 4);
        }
        if (index < 0 || index >= this.elements_.length) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        Object object = this.elementsLock_;
        synchronized (object) {
            return (AS400DataType)this.elements_[index].clone();
        }
    }

    void initializeTransient() {
        this.elementsLock_ = new Object();
        this.defaultValue_ = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMembers(AS400DataType[] members) {
        if (members == null) {
            throw new NullPointerException("members");
        }
        if (!this.allowChanges_) {
            throw new ExtendedIllegalStateException("Members", 5);
        }
        AS400DataType[] newMembers = new AS400DataType[members.length];
        for (int i = 0; i < members.length; ++i) {
            newMembers[i] = (AS400DataType)members[i].clone();
        }
        Object object = this.elementsLock_;
        synchronized (object) {
            this.elements_ = newMembers;
            this.defaultValue_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMembers(int index, AS400DataType member) {
        if (member == null) {
            throw new NullPointerException("member");
        }
        if (this.elements_ == null) {
            throw new ExtendedIllegalStateException("Members", 4);
        }
        if (index < 0 || index >= this.elements_.length) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        if (!this.allowChanges_) {
            throw new ExtendedIllegalStateException("Members", 5);
        }
        Object object = this.elementsLock_;
        synchronized (object) {
            this.elements_[index] = (AS400DataType)member.clone();
            if (this.defaultValue_ != null) {
                this.defaultValue_[index] = this.elements_[index].getDefaultValue();
            }
        }
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[this.getByteLength()];
        this.toBytes(javaValue, as400Value, 0);
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        return this.toBytes(javaValue, as400Value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        if (this.elements_ == null) {
            throw new ExtendedIllegalStateException("Members", 4);
        }
        Object object = this.elementsLock_;
        synchronized (object) {
            this.allowChanges_ = false;
            int numElements = this.elements_.length;
            Object[] arrayValue = (Object[])javaValue;
            if (arrayValue.length != numElements) {
                throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 1);
            }
            for (int i = 0; i < numElements; ++i) {
                offset += this.elements_[i].toBytes(arrayValue[i], as400Value, offset);
            }
            return this.getByteLength();
        }
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return this.toObject(as400Value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toObject(byte[] as400Value, int offset) {
        if (this.elements_ == null) {
            throw new ExtendedIllegalStateException("Members", 4);
        }
        Object object = this.elementsLock_;
        synchronized (object) {
            this.allowChanges_ = false;
            int numElements = this.elements_.length;
            Object[] returnArray = new Object[numElements];
            for (int i = 0; i < numElements; ++i) {
                returnArray[i] = this.elements_[i].toObject(as400Value, offset);
                offset += this.elements_[i].getByteLength();
            }
            return returnArray;
        }
    }
}

