/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.metadata;

import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.databases.cassandra.datastax.DriverConnection;
import org.apache.hop.databases.cassandra.metadata.CassandraConnection;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiCompositeWidgetsAdapter;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.workflow.actions.execcql.ExecCql;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CassandraConnectionEditor
extends MetadataEditor<CassandraConnection> {
    public static final String PARENT_WIDGET_ID = "CassandraConnectionEditor.Widgets.ParentId";
    public static final String CONST_ERROR = "Error";
    private Composite parent;
    private Text wName;
    private GuiCompositeWidgets widgets;

    public CassandraConnectionEditor(HopGui hopGui, MetadataManager<CassandraConnection> manager, CassandraConnection metadata) {
        super(hopGui, manager, (IHopMetadata)metadata);
    }

    public void createControl(Composite parent) {
        this.parent = parent;
        PropsUi props = PropsUi.getInstance();
        int margin = PropsUi.getMargin();
        int middle = props.getMiddlePct();
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText("Cassandra connection name");
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin * 2);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.widgets = new GuiCompositeWidgets(this.manager.getVariables());
        this.widgets.createCompositeWidgets((Object)this.getMetadata(), null, parent, PARENT_WIDGET_ID, (Control)this.wName);
        this.setWidgetsContent();
        this.wName.addListener(24, e -> this.setChanged());
        this.widgets.setWidgetsListener((IGuiPluginCompositeWidgetsListener)new GuiCompositeWidgetsAdapter(){

            public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                CassandraConnectionEditor.this.setChanged();
            }
        });
    }

    public void setWidgetsContent() {
        CassandraConnection meta = (CassandraConnection)this.getMetadata();
        this.wName.setText(Const.NVL((String)meta.getName(), (String)""));
        this.widgets.setWidgetsContents((Object)meta, this.parent, PARENT_WIDGET_ID);
    }

    public void getWidgetsContent(CassandraConnection meta) {
        meta.setName(this.wName.getText());
        this.widgets.getWidgetsContents((Object)meta, PARENT_WIDGET_ID);
    }

    public Button[] createButtonsForButtonBar(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        Button wbSelectKeyspace = new Button(parent, 0x1000008);
        PropsUi.setLook((Widget)wbSelectKeyspace);
        wbSelectKeyspace.setText("Select keyspace");
        wbSelectKeyspace.addListener(13, e -> this.selectKeyspace());
        Button wbTest = new Button(parent, 0x1000008);
        PropsUi.setLook((Widget)wbTest);
        wbTest.setText("Test");
        wbTest.addListener(13, e -> this.test());
        Button wbCql = new Button(parent, 0x1000008);
        PropsUi.setLook((Widget)wbCql);
        wbCql.setText("Execute CQL");
        wbCql.addListener(13, e -> this.execCql());
        return new Button[]{wbCql, wbSelectKeyspace, wbTest};
    }

    public void test() {
        try {
            CassandraConnection meta = new CassandraConnection();
            this.getWidgetsContent(meta);
            try (DriverConnection connection = meta.createConnection(this.manager.getVariables(), false);){
                connection.open();
                connection.getKeyspaceNames();
            }
            MessageBox box = new MessageBox(this.parent.getShell(), 34);
            box.setText("Success!");
            box.setMessage("It's possible to connect to Cassandra with this metadata!");
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.parent.getShell(), CONST_ERROR, "We couldn't connect using this information", e);
        }
    }

    public void selectKeyspace() {
        try {
            CassandraConnection meta = new CassandraConnection();
            this.getWidgetsContent(meta);
            try (DriverConnection connection = meta.createConnection(this.manager.getVariables(), false);){
                connection.open();
                String[] keyspaceNames = connection.getKeyspaceNames();
                EnterSelectionDialog dialog = new EnterSelectionDialog(this.getShell(), keyspaceNames, "Select keyspace", "Select the keyspace to use:");
                String keyspaceName = dialog.open();
                if (keyspaceName != null) {
                    meta.setKeyspace(keyspaceName);
                    this.setMetadata(meta);
                    this.setWidgetsContent();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error selecting keyspace", e);
        }
    }

    public void execCql() {
        try {
            EnterTextDialog dialog = new EnterTextDialog(this.getShell(), "Enter CQL", "Enter the CQL statements to execute on this Cassandra connection." + Const.CR + "The statements are split by a ; on a separate line." + Const.CR + "Please note that results of queries are not shown at this time.", "", true);
            String cql = dialog.open();
            if (cql != null) {
                CassandraConnection meta = new CassandraConnection();
                this.getWidgetsContent(meta);
                int executed = ExecCql.executeCqlStatements(this.manager.getVariables(), LogChannel.UI, new Result(), meta, cql);
                MessageBox box = new MessageBox(this.parent.getShell(), 34);
                box.setText("Success!");
                box.setMessage(executed + " CQL statements were executed.");
                box.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.parent.getShell(), CONST_ERROR, "There was an error executing CQL on this Cassandra cluster", e);
        }
    }
}

