/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.values.TypeDescriptor;

public class ByteCoder
extends AtomicCoder<Byte> {
    private static final ByteCoder INSTANCE = new ByteCoder();
    private static final TypeDescriptor<Byte> TYPE_DESCRIPTOR = new TypeDescriptor<Byte>(){};

    public static ByteCoder of() {
        return INSTANCE;
    }

    private ByteCoder() {
    }

    @Override
    public void encode(Byte value, OutputStream outStream) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Byte");
        }
        outStream.write(value.byteValue());
    }

    @Override
    public Byte decode(InputStream inStream) throws IOException, CoderException {
        try {
            int value = inStream.read();
            if (value == -1) {
                throw new EOFException("EOF encountered decoding 1 byte from input stream");
            }
            return (byte)value;
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Byte value) {
        return true;
    }

    @Override
    public TypeDescriptor<Byte> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected long getEncodedElementByteSize(Byte value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot estimate size for unsupported null value");
        }
        return 1L;
    }
}

