/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;

public class IterableCoder<T>
extends IterableLikeCoder<T, Iterable<T>> {
    public static <T> IterableCoder<T> of(Coder<T> elemCoder) {
        return new IterableCoder<T>(elemCoder);
    }

    @Override
    public Object structuralValue(Iterable<T> value) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (T elem : value) {
            result.add(this.getElemCoder().structuralValue(elem));
        }
        return result;
    }

    @Override
    protected final Iterable<T> decodeToIterable(List<T> decodedElements) {
        return decodedElements;
    }

    protected IterableCoder(Coder<T> elemCoder) {
        super(elemCoder, "Iterable");
    }

    @Override
    public TypeDescriptor<Iterable<T>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<Iterable<T>>(){}.where(new TypeParameter<T>(){}, this.getElemCoder().getEncodedTypeDescriptor());
    }
}

