/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;

public class KvCoder<K, V>
extends StructuredCoder<KV<K, V>> {
    private final Coder<K> keyCoder;
    private final Coder<V> valueCoder;

    public static <K, V> KvCoder<K, V> of(Coder<K> keyCoder, Coder<V> valueCoder) {
        return new KvCoder<K, V>(keyCoder, valueCoder);
    }

    public Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    private KvCoder(Coder<K> keyCoder, Coder<V> valueCoder) {
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
    }

    @Override
    public void encode(KV<K, V> kv, OutputStream outStream) throws IOException, CoderException {
        this.encode(kv, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(KV<K, V> kv, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (kv == null) {
            throw new CoderException("cannot encode a null KV");
        }
        this.keyCoder.encode(kv.getKey(), outStream);
        this.valueCoder.encode(kv.getValue(), outStream, context);
    }

    @Override
    public KV<K, V> decode(InputStream inStream) throws IOException, CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public KV<K, V> decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        K key = this.keyCoder.decode(inStream);
        V value = this.valueCoder.decode(inStream, context);
        return KV.of(key, value);
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return Arrays.asList(this.keyCoder, this.valueCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        KvCoder.verifyDeterministic(this, "Key coder must be deterministic", this.getKeyCoder());
        KvCoder.verifyDeterministic(this, "Value coder must be deterministic", this.getValueCoder());
    }

    @Override
    public boolean consistentWithEquals() {
        return this.keyCoder.consistentWithEquals() && this.valueCoder.consistentWithEquals();
    }

    @Override
    public Object structuralValue(KV<K, V> kv) {
        if (this.consistentWithEquals()) {
            return kv;
        }
        return KV.of(this.getKeyCoder().structuralValue(kv.getKey()), this.getValueCoder().structuralValue(kv.getValue()));
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(KV<K, V> kv) {
        return this.keyCoder.isRegisterByteSizeObserverCheap(kv.getKey()) && this.valueCoder.isRegisterByteSizeObserverCheap(kv.getValue());
    }

    @Override
    public void registerByteSizeObserver(KV<K, V> kv, ElementByteSizeObserver observer) throws Exception {
        if (kv == null) {
            throw new CoderException("cannot encode a null KV");
        }
        this.keyCoder.registerByteSizeObserver(kv.getKey(), observer);
        this.valueCoder.registerByteSizeObserver(kv.getValue(), observer);
    }

    @Override
    public TypeDescriptor<KV<K, V>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<KV<K, V>>(){}.where(new TypeParameter<K>(){}, this.keyCoder.getEncodedTypeDescriptor()).where(new TypeParameter<V>(){}, this.valueCoder.getEncodedTypeDescriptor());
    }
}

