/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTDragSourceDelegate;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    static byte[] types;
    static int size;
    static int align;
    static Callback dragSource2Args;
    static Callback dragSource3Args;
    static Callback dragSource4Args;
    static Callback dragSource5Args;
    static Callback dragSource6Args;
    static final byte[] SWT_OBJECT;
    static long proc2;
    static long proc3;
    static long proc4;
    static long proc5;
    static long proc6;
    String[] paths;
    boolean[] exist;
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    Image dragImageFromListener;
    private int dragOperations;
    SWTDragSourceDelegate dragSourceDelegate;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    private long delegateJniRef;
    private Point dragOffset;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        types = byArray;
        size = C.PTR_SIZEOF;
        align = C.PTR_SIZEOF == 4 ? 2 : 3;
        byte[] byArray2 = new byte[11];
        byArray2[0] = 83;
        byArray2[1] = 87;
        byArray2[2] = 84;
        byArray2[3] = 95;
        byArray2[4] = 79;
        byArray2[5] = 66;
        byArray2[6] = 74;
        byArray2[7] = 69;
        byArray2[8] = 67;
        byArray2[9] = 84;
        SWT_OBJECT = byArray2;
        proc2 = 0L;
        proc3 = 0L;
        proc4 = 0L;
        proc5 = 0L;
        proc6 = 0L;
        String className = "SWTDragSourceDelegate";
        Class<DragSource> clazz = DragSource.class;
        dragSource2Args = new Callback(clazz, "dragSourceProc", 2);
        proc2 = dragSource2Args.getAddress();
        dragSource3Args = new Callback(clazz, "dragSourceProc", 3);
        proc3 = dragSource3Args.getAddress();
        dragSource4Args = new Callback(clazz, "dragSourceProc", 4);
        proc4 = dragSource4Args.getAddress();
        dragSource5Args = new Callback(clazz, "dragSourceProc", 5);
        proc5 = dragSource5Args.getAddress();
        dragSource6Args = new Callback(clazz, "dragSourceProc", 6);
        proc6 = dragSource6Args.getAddress();
        long cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        long draggedImage_endedAt_operationProc = OS.CALLBACK_draggedImage_endedAt_operation_(proc5);
        OS.class_addMethod(cls, OS.sel_draggingSourceOperationMaskForLocal_, proc3, "@:I");
        OS.class_addMethod(cls, OS.sel_draggedImage_beganAt_, proc4, "@:@{NSPoint=ff}");
        OS.class_addMethod(cls, OS.sel_draggedImage_endedAt_operation_, draggedImage_endedAt_operationProc, "@:@{NSPoint=ff}I");
        OS.class_addMethod(cls, OS.sel_ignoreModifierKeysWhileDragging, proc3, "@:");
        OS.class_addMethod(cls, OS.sel_pasteboard_provideDataForType_, proc4, "@:@@");
        OS.objc_registerClassPair(cls);
    }

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        this.controlListener = event -> {
            if (event.type == 12 && !this.isDisposed()) {
                this.dispose();
            }
            if (event.type == 29 && !this.isDisposed()) {
                if (event.widget instanceof Table || event.widget instanceof Tree) {
                    this.dragOutlineViewStart(event);
                } else {
                    this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, e -> this.onDispose());
        Object effect = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (effect instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)effect;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
        this.delegateJniRef = OS.NewGlobalRef(this);
        if (this.delegateJniRef == 0L) {
            SWT.error(2);
        }
        this.dragSourceDelegate = (SWTDragSourceDelegate)new SWTDragSourceDelegate().alloc().init();
        OS.object_setInstanceVariable(this.dragSourceDelegate.id, SWT_OBJECT, this.delegateJniRef);
        if (control instanceof Tree || control instanceof Table) {
            long procPtr;
            long cls = OS.object_getClass(control.view.id);
            if (cls == 0L) {
                DND.error(2000);
            }
            if ((procPtr = OS.class_getMethodImplementation(cls, OS.sel_draggingSourceOperationMaskForLocal_)) == proc3) {
                return;
            }
            long draggedImage_endedAt_operationProc = OS.CALLBACK_draggedImage_endedAt_operation_(proc5);
            OS.class_addMethod(cls, OS.sel_draggingSourceOperationMaskForLocal_, proc3, "@:I");
            OS.class_addMethod(cls, OS.sel_draggedImage_beganAt_, proc4, "@:@{NSPoint=ff}");
            OS.class_addMethod(cls, OS.sel_draggedImage_endedAt_operation_, draggedImage_endedAt_operationProc, "@:@{NSPoint=ff}I");
            OS.class_addMethod(cls, OS.sel_ignoreModifierKeysWhileDragging, proc3, "@:");
            OS.class_addMethod(cls, OS.sel_dragImageForRowsWithIndexes_tableColumns_event_offset_, proc6, "@:@@@^NSPoint");
        }
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2008, typedListener);
        this.addListener(2001, typedListener);
        this.addListener(2000, typedListener);
    }

    void dndCallSuper(long id2, long sel, long arg0, NSPoint arg1, long arg2) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0, arg1, arg2);
    }

    void dndCallSuper(long id2, long sel, long arg0, long arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0, arg1);
    }

    long dndCallSuperObject(long id2, long sel, long arg0, long arg1, long arg2, long arg3) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0, arg1, arg2, arg3);
    }

    @Override
    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = DragSource.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    void drag(Event dragDetectEvent) {
        DNDEvent event = this.startDrag(dragDetectEvent);
        if (event == null) {
            return;
        }
        NSEvent currEvent = NSApplication.sharedApplication().currentEvent();
        NSPoint pt = currEvent.locationInWindow();
        NSPoint viewPt = this.control.view.convertPoint_fromView_(pt, null);
        NSImage dragImage = null;
        Resource defaultDragImage = null;
        try {
            Resource image = event.image;
            if (image == null) {
                int width = 20;
                int height = 20;
                Image newDragImage = new Image((Device)Display.getCurrent(), width, height);
                GC imageGC = new GC(newDragImage);
                Color grayColor = new Color(Display.getCurrent(), 50, 50, 50);
                imageGC.setForeground(grayColor);
                imageGC.drawRectangle(0, 0, 19, 19);
                imageGC.dispose();
                ImageData newImageData = newDragImage.getImageData();
                newImageData.alpha = 102;
                defaultDragImage = new Image((Device)Display.getCurrent(), newImageData);
                newDragImage.dispose();
                grayColor.dispose();
                image = defaultDragImage;
                event.offsetX = width / 2;
                event.offsetY = height / 2;
            }
            dragImage = image.handle;
            NSSize imageSize = dragImage.size();
            viewPt.x -= (double)event.offsetX;
            viewPt.y = this.control.view.isFlipped() ? (viewPt.y += imageSize.height - (double)event.offsetY) : (viewPt.y -= (double)event.offsetY);
            NSSize ignored = new NSSize();
            this.control.view.dragImage(dragImage, viewPt, ignored, NSApplication.sharedApplication().currentEvent(), NSPasteboard.pasteboardWithName(OS.NSDragPboard), this.dragSourceDelegate, true);
        }
        finally {
            if (defaultDragImage != null) {
                defaultDragImage.dispose();
            }
        }
    }

    void dragOutlineViewStart(Event dragDetectEvent) {
        DNDEvent event = this.startDrag(dragDetectEvent);
        if (event == null) {
            dragDetectEvent.doit = false;
            return;
        }
        this.dragImageFromListener = event.image;
        this.dragOffset = new Point(event.offsetX, event.offsetY);
    }

    void draggedImage_beganAt(long id2, long sel, long arg0, long arg1) {
        if (new NSObject(id2).isKindOfClass(OS.class_NSTableView)) {
            this.dndCallSuper(id2, sel, arg0, arg1);
        }
    }

    void draggedImage_endedAt_operation(long id2, long sel, long arg0, NSPoint arg1, long arg2) {
        int swtOperation = this.osOpToOp(arg2);
        if (this.paths != null) {
            NSFileManager fileManager = NSFileManager.defaultManager();
            int i = 0;
            while (i < this.paths.length) {
                if (this.paths[i] != null && this.exist[i] && !fileManager.fileExistsAtPath(NSString.stringWith(this.paths[i]))) {
                    swtOperation &= 0xFFFFFFFD;
                    swtOperation |= 8;
                }
                ++i;
            }
            this.paths = null;
            this.exist = null;
        }
        OS.objc_msgSend(id2, OS.sel_retain);
        try {
            DNDEvent event = new DNDEvent();
            event.widget = this;
            event.time = (int)System.currentTimeMillis();
            event.doit = swtOperation != 0;
            event.detail = swtOperation;
            this.notifyListeners(2000, event);
            this.dragImageFromListener = null;
            if (new NSObject(id2).isKindOfClass(OS.class_NSTableView)) {
                this.dndCallSuper(id2, sel, arg0, arg1, arg2);
            }
        }
        finally {
            OS.objc_msgSend(id2, OS.sel_release);
        }
    }

    long dragImageForRowsWithIndexes_tableColumns_event_offset(long id2, long sel, long arg0, long arg1, long arg2, long arg3) {
        if (this.dragImageFromListener != null) {
            NSPoint point = new NSPoint();
            point.x = this.dragOffset.x;
            point.y = this.dragOffset.y;
            OS.memmove(arg3, point, (long)NSPoint.sizeof);
            return this.dragImageFromListener.handle.id;
        }
        return this.dndCallSuperObject(id2, sel, arg0, arg1, arg2, arg3);
    }

    long draggingSourceOperationMaskForLocal(long id2, long sel, long arg0) {
        return this.dragOperations;
    }

    static long dragSourceProc(long id2, long sel) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(id2);
        if (widget == null) {
            return 0L;
        }
        DragSource ds = null;
        ds = widget instanceof DragSource ? (DragSource)widget : (DragSource)widget.getData("DragSource");
        if (ds == null) {
            return 0L;
        }
        if (sel == OS.sel_ignoreModifierKeysWhileDragging) {
            return ds.ignoreModifierKeysWhileDragging(id2, sel) ? 1 : 0;
        }
        return 0L;
    }

    static long dragSourceProc(long id2, long sel, long arg0) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(id2);
        if (widget == null) {
            return 0L;
        }
        DragSource ds = null;
        ds = widget instanceof DragSource ? (DragSource)widget : (DragSource)widget.getData("DragSource");
        if (ds == null) {
            return 0L;
        }
        if (sel == OS.sel_draggingSourceOperationMaskForLocal_) {
            return ds.draggingSourceOperationMaskForLocal(id2, sel, arg0);
        }
        return 0L;
    }

    static long dragSourceProc(long id2, long sel, long arg0, long arg1) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(id2);
        if (widget == null) {
            return 0L;
        }
        DragSource ds = null;
        ds = widget instanceof DragSource ? (DragSource)widget : (DragSource)widget.getData("DragSource");
        if (ds == null) {
            return 0L;
        }
        if (sel == OS.sel_draggedImage_beganAt_) {
            ds.draggedImage_beganAt(id2, sel, arg0, arg1);
        } else if (sel == OS.sel_pasteboard_provideDataForType_) {
            ds.pasteboard_provideDataForType(id2, sel, arg0, arg1);
        }
        return 0L;
    }

    static long dragSourceProc(long id2, long sel, long arg0, long arg1, long arg2) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(id2);
        if (widget == null) {
            return 0L;
        }
        DragSource ds = null;
        ds = widget instanceof DragSource ? (DragSource)widget : (DragSource)widget.getData("DragSource");
        if (ds == null) {
            return 0L;
        }
        if (sel == OS.sel_draggedImage_endedAt_operation_) {
            NSPoint point = new NSPoint();
            OS.memmove(point, arg1, (long)NSPoint.sizeof);
            ds.draggedImage_endedAt_operation(id2, sel, arg0, point, arg2);
        }
        return 0L;
    }

    static long dragSourceProc(long id2, long sel, long arg0, long arg1, long arg2, long arg3) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(id2);
        if (widget == null) {
            return 0L;
        }
        DragSource ds = null;
        ds = widget instanceof DragSource ? (DragSource)widget : (DragSource)widget.getData("DragSource");
        if (ds == null) {
            return 0L;
        }
        if (sel == OS.sel_dragImageForRowsWithIndexes_tableColumns_event_offset_) {
            return ds.dragImageForRowsWithIndexes_tableColumns_event_offset(id2, sel, arg0, arg1, arg2, arg3);
        }
        return 0L;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listeners = this.getListeners(2008);
        int length = listeners.length;
        DragSourceListener[] dragListeners = new DragSourceListener[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            Listener listener = listeners[i];
            if (listener instanceof DNDListener) {
                dragListeners[count] = (DragSourceListener)((DNDListener)listener).getEventListener();
                ++count;
            }
            ++i;
        }
        if (count == length) {
            return dragListeners;
        }
        DragSourceListener[] result = new DragSourceListener[count];
        System.arraycopy(dragListeners, 0, result, 0, count);
        return result;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    boolean ignoreModifierKeysWhileDragging(long id2, long sel) {
        return false;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
        if (this.delegateJniRef != 0L) {
            OS.DeleteGlobalRef(this.delegateJniRef);
        }
        this.delegateJniRef = 0L;
        if (this.dragSourceDelegate != null) {
            OS.object_setInstanceVariable(this.dragSourceDelegate.id, SWT_OBJECT, 0L);
            this.dragSourceDelegate.release();
        }
    }

    int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 2;
        }
        if ((operation & 2) != 0) {
            osOperation |= 0x10;
        }
        if ((operation & 8) != 0) {
            osOperation |= 0x20;
        }
        return osOperation;
    }

    int osOpToOp(long osOperation) {
        int operation = 0;
        if ((osOperation & 1L) != 0L) {
            operation |= 1;
        }
        if ((osOperation & 2L) != 0L) {
            operation |= 4;
        }
        if ((osOperation & 0x20L) != 0L) {
            operation |= 8;
        }
        if ((osOperation & 0x10L) != 0L) {
            operation |= 2;
        }
        if (osOperation == -1L) {
            operation = 7;
        }
        return operation;
    }

    void pasteboard_provideDataForType(long id2, long sel, long arg0, long arg1) {
        NSPasteboard pasteboard = new NSPasteboard(arg0);
        NSString dataType = new NSString(arg1);
        if (pasteboard == null || dataType == null) {
            return;
        }
        TransferData transferData = new TransferData();
        transferData.type = Transfer.registerType(dataType.getString());
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = (int)System.currentTimeMillis();
        event.dataType = transferData;
        this.notifyListeners(2001, event);
        if (!event.doit) {
            return;
        }
        Transfer transfer = null;
        int i = 0;
        while (i < this.transferAgents.length) {
            Transfer transferAgent = this.transferAgents[i];
            if (transferAgent != null && transferAgent.isSupportedType(transferData)) {
                transfer = transferAgent;
                break;
            }
            ++i;
        }
        if (transfer == null) {
            return;
        }
        transfer.javaToNative(event.data, transferData);
        if (transferData.data == null) {
            return;
        }
        NSObject tdata = transferData.data;
        if (dataType.isEqual(OS.NSPasteboardTypeString) || dataType.isEqual(OS.NSPasteboardTypeHTML) || dataType.isEqual(OS.NSPasteboardTypeRTF)) {
            pasteboard.setString((NSString)tdata, dataType);
        } else if (dataType.isEqual(OS.NSURLPboardType) || dataType.isEqual(OS.kUTTypeURL)) {
            NSURL url = (NSURL)tdata;
            pasteboard.writeObjects(NSArray.arrayWithObject(url));
        } else if (dataType.isEqual(OS.NSFilenamesPboardType) || dataType.isEqual(OS.kUTTypeFileURL)) {
            NSArray array = (NSArray)transferData.data;
            int count = (int)array.count();
            this.paths = new String[count];
            this.exist = new boolean[count];
            NSFileManager fileManager = NSFileManager.defaultManager();
            int i2 = 0;
            while (i2 < count) {
                NSString filePath = new NSString(array.objectAtIndex(i2));
                this.paths[i2] = filePath.getString();
                this.exist[i2] = fileManager.fileExistsAtPath(filePath);
                ++i2;
            }
            pasteboard.setPropertyList((NSArray)tdata, OS.NSFilenamesPboardType);
        } else {
            pasteboard.setData((NSData)tdata, dataType);
        }
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2001, listener);
        this.removeListener(2000, listener);
    }

    public void setDragSourceEffect(DragSourceEffect effect) {
        this.dragEffect = effect;
    }

    public void setTransfer(Transfer ... transferAgents) {
        this.transferAgents = transferAgents;
    }

    boolean canBeginDrag() {
        return this.transferAgents != null && this.transferAgents.length != 0;
    }

    DNDEvent startDrag(Event dragEvent) {
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.x = dragEvent.x;
        event.y = dragEvent.y;
        event.time = dragEvent.time;
        event.doit = true;
        this.notifyListeners(2008, event);
        if (!event.doit || !this.canBeginDrag()) {
            return null;
        }
        NSPasteboard dragBoard = NSPasteboard.pasteboardWithName(OS.NSDragPboard);
        NSMutableArray nativeTypeArray = NSMutableArray.arrayWithCapacity(10L);
        int i = 0;
        while (i < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[i];
            if (transfer != null) {
                String[] typeNames = transfer.getTypeNames();
                int j = 0;
                while (j < typeNames.length) {
                    nativeTypeArray.addObject(NSString.stringWith(typeNames[j]));
                    ++j;
                }
            }
            ++i;
        }
        dragBoard.declareTypes(nativeTypeArray, this.dragSourceDelegate);
        this.dragOperations = this.opToOsOp(this.getStyle());
        return event;
    }
}

