/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.neo4j.transforms.cypherbuilder.Parameter;
import org.apache.hop.neo4j.transforms.cypherbuilder.Property;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.IOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.OperationType;

public class BaseOperation
implements IOperation {
    @HopMetadataProperty
    protected String name;
    @HopMetadataProperty
    protected OperationType operationType;
    @HopMetadataProperty
    protected List<String> labels = new ArrayList<String>();
    @HopMetadataProperty
    protected String alias;
    @HopMetadataProperty
    protected List<Property> keys = new ArrayList<Property>();
    @HopMetadataProperty
    protected List<Property> properties = new ArrayList<Property>();

    public BaseOperation() {
    }

    public BaseOperation(BaseOperation o) {
        this();
        this.name = o.name;
        this.operationType = o.operationType;
        this.alias = o.alias;
        this.labels.addAll(o.labels);
        o.keys.forEach(k -> this.keys.add(new Property((Property)k)));
        o.properties.forEach(p -> this.properties.add(new Property((Property)p)));
    }

    @Override
    public BaseOperation clone() {
        return new BaseOperation(this);
    }

    public BaseOperation(OperationType operationType) {
        this();
        this.operationType = operationType;
    }

    @Override
    public String getCypherClause(String unwindAlias, List<Parameter> parameters) throws HopException {
        throw new HopException("Cypher clause generation is not implemented for this operation type: " + this.operationType);
    }

    @Override
    public boolean needsWriteTransaction() {
        throw new RuntimeException("Write transaction information is not provided for operation type " + this.operationType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseOperation that = (BaseOperation)o;
        if (this.operationType != that.operationType) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationType, this.name});
    }

    protected String getLabelsClause() {
        StringBuilder cypher = new StringBuilder();
        cypher.append(this.alias);
        for (String label : this.labels) {
            cypher.append(":").append(label);
        }
        return cypher.toString();
    }

    protected String getKeysClause(String unwindAlias) {
        StringBuilder cypher = new StringBuilder();
        cypher.append(" {");
        for (int k = 0; k < this.keys.size(); ++k) {
            Property key = this.keys.get(k);
            if (k > 0) {
                cypher.append(", ");
            }
            cypher.append(key.getName()).append(":").append(key.formatParameter(unwindAlias));
        }
        cypher.append("} ");
        return cypher.toString();
    }

    protected String getSetClause(String unwindAlias) {
        StringBuilder cypher = new StringBuilder();
        cypher.append("SET ");
        for (int p = 0; p < this.properties.size(); ++p) {
            Property property = this.properties.get(p);
            if (p > 0) {
                cypher.append(", ");
            }
            cypher.append(this.alias).append(".").append(property.getName()).append("=").append(property.formatParameter(unwindAlias));
        }
        cypher.append(" ");
        return cypher.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<Property> getKeys() {
        return this.keys;
    }

    public void setKeys(List<Property> keys) {
        this.keys = keys;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }
}

