/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.ping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="PING", name="i18n::ActionPing.Name", description="i18n::ActionPing.Description", image="Ping.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionPing.keyword"}, documentationUrl="/workflow/actions/ping.html")
public class ActionPing
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionPing.class;
    private String hostname = null;
    private String timeout;
    public String defaultTimeOut = "3000";
    private String nbrPackets = "2";
    private static final String WINDOWS_CHAR = "-n";
    private static final String NIX_CHAR = "-c";
    public String classicPing = "classicPing";
    public int iclassicPing = 0;
    public String systemPing = "systemPing";
    public int isystemPing = 1;
    public String bothPings = "bothPings";
    public int ibothPings = 2;
    public String pingtype = this.classicPing;
    public int ipingtype;

    public ActionPing(String n) {
        super(n, "");
        this.timeout = this.defaultTimeOut;
    }

    public ActionPing() {
        this("");
    }

    public Object clone() {
        ActionPing je = (ActionPing)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(100);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"hostname", (String)this.hostname));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nbr_packets", (String)this.nbrPackets));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nbrpaquets", (String)this.nbrPackets));
        retval.append("      ").append(XmlHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("      ").append(XmlHandler.addTagValue((String)"pingtype", (String)this.pingtype));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.hostname = XmlHandler.getTagValue((Node)entrynode, (String)"hostname");
            this.nbrPackets = XmlHandler.getTagValue((Node)entrynode, (String)"nbr_packets");
            String nbrPaquets = XmlHandler.getTagValue((Node)entrynode, (String)"nbrpaquets");
            if (this.nbrPackets == null && nbrPaquets != null) {
                this.nbrPackets = nbrPaquets;
            }
            this.timeout = XmlHandler.getTagValue((Node)entrynode, (String)"timeout");
            this.pingtype = XmlHandler.getTagValue((Node)entrynode, (String)"pingtype");
            if (Utils.isEmpty((CharSequence)this.pingtype)) {
                this.pingtype = this.classicPing;
                this.ipingtype = this.iclassicPing;
            } else {
                this.ipingtype = this.pingtype.equals(this.systemPing) ? this.isystemPing : (this.pingtype.equals(this.bothPings) ? this.ibothPings : this.iclassicPing);
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'ping' from XML node", (Throwable)xe);
        }
    }

    public String getNbrPackets() {
        return this.nbrPackets;
    }

    public String getRealNbrPackets() {
        return this.resolve(this.getNbrPackets());
    }

    public void setNbrPackets(String nbrPackets) {
        this.nbrPackets = nbrPackets;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getRealHostname() {
        return this.resolve(this.getHostname());
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public String getRealTimeOut() {
        return this.resolve(this.getTimeOut());
    }

    public void setTimeOut(String timeout) {
        this.timeout = timeout;
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String hostname = this.getRealHostname();
        int timeoutInt = Const.toInt((String)this.getRealTimeOut(), (int)300);
        int packets = Const.toInt((String)this.getRealNbrPackets(), (int)2);
        boolean status = false;
        if (Utils.isEmpty((CharSequence)hostname)) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionPing.SpecifyHost.Label", (String[])new String[0]));
            return result;
        }
        try {
            if (this.ipingtype == this.isystemPing || this.ipingtype == this.ibothPings) {
                status = this.systemPing(hostname, timeoutInt);
                if (status) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"ActionPing.SystemPing", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionPing.OK.Label", (String[])new String[]{hostname})});
                    }
                } else {
                    this.log.logError(BaseMessages.getString(PKG, (String)"ActionPing.SystemPing", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionPing.NOK.Label", (String[])new String[]{hostname})});
                }
            }
            if (this.ipingtype == this.iclassicPing || this.ipingtype == this.ibothPings && !status) {
                status = this.classicPing(hostname, packets);
                if (status) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"ActionPing.ClassicPing", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionPing.OK.Label", (String[])new String[]{hostname})});
                    }
                } else {
                    this.log.logError(BaseMessages.getString(PKG, (String)"ActionPing.ClassicPing", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionPing.NOK.Label", (String[])new String[]{hostname})});
                }
            }
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionPing.Error.Label", (String[])new String[0]) + ex.getMessage());
        }
        if (status) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPing.OK.Label", (String[])new String[]{hostname}));
            }
            result.setNrErrors(0L);
            result.setResult(true);
        } else {
            this.logError(BaseMessages.getString(PKG, (String)"ActionPing.NOK.Label", (String[])new String[]{hostname}));
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    private boolean systemPing(String hostname, int timeout) {
        boolean retval = false;
        InetAddress address = null;
        try {
            address = InetAddress.getByName(hostname);
            if (address == null) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionPing.CanNotGetAddress", (String[])new String[]{hostname}));
                return retval;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPing.HostName", (String[])new String[]{address.getHostName()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPing.HostAddress", (String[])new String[]{address.getHostAddress()}));
            }
            retval = address.isReachable(timeout);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionPing.ErrorSystemPing", (String[])new String[]{hostname, e.getMessage()}));
        }
        return retval;
    }

    private boolean classicPing(String hostname, int nrpackets) {
        boolean retval = false;
        try {
            String lignePing = "";
            Object cmdPing = "ping ";
            cmdPing = Const.isWindows() ? (String)cmdPing + hostname + " -n " + nrpackets : (String)cmdPing + hostname + " -c " + nrpackets;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPing.NbrPackets.Label", (String[])new String[]{"" + nrpackets}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPing.ExecClassicPing.Label", (String[])new String[]{cmdPing}));
            }
            Process processPing = Runtime.getRuntime().exec((String)cmdPing);
            try {
                processPing.waitFor();
            }
            catch (InterruptedException e) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPing.ClassicPingInterrupted", (String[])new String[0]));
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPing.Gettingresponse.Label", (String[])new String[]{hostname}));
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(processPing.getInputStream()));
            while ((lignePing = br.readLine()) != null) {
                if (!this.log.isDetailed()) continue;
                this.logDetailed(lignePing);
            }
            if (processPing.exitValue() == 0) {
                retval = true;
            }
        }
        catch (IOException ex) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionPing.Error.Label", (String[])new String[0]) + ex.getMessage());
        }
        return retval;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.hostname)) {
            String realServername = this.resolve(this.hostname);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "hostname", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

