/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow.delegates;

import org.apache.hop.core.gui.IUndo;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;

public class HopGuiWorkflowHopDelegate {
    private static final Class<?> PKG = HopGui.class;
    private HopGui hopGui;
    private HopGuiWorkflowGraph workflowGraph;
    private PropsUi props;

    public HopGuiWorkflowHopDelegate(HopGui hopGui, HopGuiWorkflowGraph workflowGraph) {
        this.hopGui = hopGui;
        this.workflowGraph = workflowGraph;
        this.props = PropsUi.getInstance();
    }

    public void newHop(WorkflowMeta workflowMeta, ActionMeta fr, ActionMeta to) {
        WorkflowHopMeta hi = new WorkflowHopMeta(fr, to);
        this.newHop(workflowMeta, hi);
    }

    public void newHop(WorkflowMeta workflowMeta, WorkflowHopMeta hopMeta) {
        if (this.checkIfHopAlreadyExists(workflowMeta, hopMeta)) {
            workflowMeta.addWorkflowHop(hopMeta);
            int idx = workflowMeta.indexOfWorkflowHop(hopMeta);
            if (!this.performNewWorkflowHopChecks(workflowMeta, hopMeta)) {
                workflowMeta.removeWorkflowHop(idx);
            } else {
                this.hopGui.undoDelegate.addUndoNew((IUndo)workflowMeta, new WorkflowHopMeta[]{hopMeta}, new int[]{workflowMeta.indexOfWorkflowHop(hopMeta)});
            }
            this.workflowGraph.updateGui();
        }
    }

    public boolean checkIfHopAlreadyExists(WorkflowMeta workflowMeta, WorkflowHopMeta newHop) {
        boolean ok = true;
        if (workflowMeta.findWorkflowHop(newHop.getFromAction(), newHop.getToAction()) != null) {
            MessageBox mb = new MessageBox(this.hopGui.getShell(), 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"HopGui.Dialog.HopExists.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"HopGui.Dialog.HopExists.Title", (String[])new String[0]));
            mb.open();
            ok = false;
        }
        return ok;
    }

    public boolean performNewWorkflowHopChecks(WorkflowMeta workflowMeta, WorkflowHopMeta newHop) {
        boolean ok = true;
        if (workflowMeta.hasLoop(newHop.getToAction())) {
            MessageBox mb = new MessageBox(this.hopGui.getShell(), 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopCausesLoop.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopCausesLoop.Title", (String[])new String[0]));
            mb.open();
            ok = false;
        }
        return ok;
    }

    public void delHop(WorkflowMeta workflowMeta, WorkflowHopMeta hopMeta) {
        int index = workflowMeta.indexOfWorkflowHop(hopMeta);
        this.hopGui.undoDelegate.addUndoDelete((IUndo)workflowMeta, new Object[]{hopMeta.clone()}, new int[]{index});
        workflowMeta.removeWorkflowHop(index);
    }
}

