/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.io.range.RangeTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteKeyRangeTracker
implements RangeTracker<ByteKey> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ByteKeyRangeTracker.class);
    private @UnknownKeyFor @NonNull @Initialized ByteKeyRange range;
    private @Nullable @UnknownKeyFor @Initialized ByteKey position;
    private @UnknownKeyFor @NonNull @Initialized long splitPointsSeen;
    private @UnknownKeyFor @NonNull @Initialized boolean done;

    public static @UnknownKeyFor @NonNull @Initialized ByteKeyRangeTracker of(@UnknownKeyFor @NonNull @Initialized ByteKeyRange range) {
        return new ByteKeyRangeTracker(range);
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized ByteKey getStartPosition() {
        return this.range.getStartKey();
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized ByteKey getStopPosition() {
        return this.range.getEndKey();
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized ByteKeyRange getRange() {
        return this.range;
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized boolean tryReturnRecordAt(@UnknownKeyFor @NonNull @Initialized boolean isAtSplitPoint, @UnknownKeyFor @NonNull @Initialized ByteKey recordStart) {
        if (this.done) {
            return false;
        }
        Preconditions.checkState((this.position != null || isAtSplitPoint ? 1 : 0) != 0, (Object)"The first record must be at a split point");
        Preconditions.checkState((recordStart.compareTo(this.range.getStartKey()) >= 0 ? 1 : 0) != 0, (Object)"Trying to return record which is before the start key");
        Preconditions.checkState((this.position == null || recordStart.compareTo(this.position) >= 0 ? 1 : 0) != 0, (Object)"Trying to return record which is before the last-returned record");
        if (this.position == null) {
            LOG.info("Adjusting range start from {} to {} as position of first returned record", (Object)this.range.getStartKey(), (Object)recordStart);
            this.range = this.range.withStartKey(recordStart);
        }
        this.position = recordStart;
        if (isAtSplitPoint) {
            if (!this.range.containsKey(recordStart).booleanValue()) {
                this.done = true;
                return false;
            }
            ++this.splitPointsSeen;
        }
        return true;
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized boolean trySplitAtPosition(@UnknownKeyFor @NonNull @Initialized ByteKey splitPosition) {
        if (!this.range.containsKey(splitPosition).booleanValue()) {
            LOG.warn("{}: Rejecting split request at {} because it is not within the range.", (Object)this, (Object)splitPosition);
            return false;
        }
        if (this.position == null) {
            LOG.warn("{}: Rejecting split request at {} because no records have been returned.", (Object)this, (Object)splitPosition);
            return false;
        }
        if (splitPosition.compareTo(this.position) <= 0) {
            LOG.warn("{}: Rejecting split request at {} because it is not after current position {}.", new Object[]{this, splitPosition, this.position});
            return false;
        }
        this.range = this.range.withEndKey(splitPosition);
        return true;
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized double getFractionConsumed() {
        if (this.position == null) {
            return 0.0;
        }
        if (this.done) {
            return 1.0;
        }
        if (this.position.compareTo(this.range.getEndKey()) >= 0) {
            return 1.0;
        }
        return this.range.estimateFractionForKey(this.position);
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getSplitPointsConsumed() {
        if (this.position == null) {
            return 0L;
        }
        if (this.isDone()) {
            return this.splitPointsSeen;
        }
        Preconditions.checkState((this.splitPointsSeen > 0L ? 1 : 0) != 0, (String)"A started rangeTracker should have seen > 0 split points (is %s)", (long)this.splitPointsSeen);
        return this.splitPointsSeen - 1L;
    }

    private ByteKeyRangeTracker(@UnknownKeyFor @NonNull @Initialized ByteKeyRange range) {
        this.range = range;
        this.position = null;
        this.splitPointsSeen = 0L;
        this.done = false;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized boolean markDone() {
        this.done = true;
        return false;
    }

    @SideEffectFree
    public synchronized @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(ByteKeyRangeTracker.class).add("range", (Object)this.range).add("position", (Object)this.position).toString();
    }
}

