/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.io.Serializable;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.ArrayUtils;
import org.apache.beam.runners.core.InMemoryStateInternals;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.SystemReduceFn;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.GroupByKeyHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.GroupAlsoByWindowViaOutputBufferFn;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.CoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;

class GroupByKeyTranslatorBatch<@UnknownKeyFor K, @UnknownKeyFor V>
extends TransformTranslator<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupByKey<K, V>> {
    private static final @UnknownKeyFor @NonNull @Initialized Expression PANE_NO_FIRING = GroupByKeyTranslatorBatch.lit(CoderHelpers.toByteArray(PaneInfo.NO_FIRING, PaneInfo.PaneInfoCoder.of()));
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Expression> GLOBAL_WINDOW_DETAILS = GroupByKeyTranslatorBatch.windowDetails(GroupByKeyTranslatorBatch.lit(new byte[][]{ArrayUtils.EMPTY_BYTE_ARRAY}));
    private @UnknownKeyFor @NonNull @Initialized boolean useCollectList = true;

    GroupByKeyTranslatorBatch() {
        super(0.2f);
    }

    GroupByKeyTranslatorBatch(@UnknownKeyFor @NonNull @Initialized boolean useCollectList) {
        super(0.2f);
        this.useCollectList = useCollectList;
    }

    @Override
    public void translate(@UnknownKeyFor @NonNull @Initialized GroupByKey<K, V> transform, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context cxt) {
        Dataset result;
        WindowingStrategy windowing = ((PCollection)cxt.getInput()).getWindowingStrategy();
        TimestampCombiner tsCombiner = windowing.getTimestampCombiner();
        Dataset input = cxt.getDataset((PCollection)cxt.getInput());
        KvCoder inputCoder = (KvCoder)((PCollection)cxt.getInput()).getCoder();
        KvCoder outputCoder = (KvCoder)((PCollection)cxt.getOutput()).getCoder();
        Encoder valueEnc = cxt.valueEncoderOf(inputCoder);
        Encoder keyEnc = cxt.keyEncoderOf(inputCoder);
        if (this.useCollectList && GroupByKeyHelpers.eligibleForGlobalGroupBy(windowing, false)) {
            result = input.groupBy(new Column[]{functions.col((String)"value.key").as("key")}).agg(functions.collect_list((Column)functions.col((String)"value.value")).as("values"), GroupByKeyTranslatorBatch.timestampAggregator(tsCombiner)).select(GroupByKeyTranslatorBatch.inGlobalWindow(this.keyValue(functions.col((String)"key").as(keyEnc), functions.col((String)"values").as(this.iterableEnc(valueEnc))), GroupByKeyTranslatorBatch.windowTimestamp(tsCombiner)));
        } else if (GroupByKeyHelpers.eligibleForGlobalGroupBy(windowing, true)) {
            result = cxt.getDataset((PCollection)cxt.getInput()).groupByKey(GroupByKeyHelpers.valueKey(), keyEnc).mapValues(GroupByKeyHelpers.valueValue(), cxt.valueEncoderOf(inputCoder)).mapGroups(ScalaInterop.fun2((k, it) -> KV.of((Object)k, GroupByKeyTranslatorBatch.iterableOnce(it))), cxt.kvEncoderOf(outputCoder)).map(ScalaInterop.fun1(WindowedValue::valueInGlobalWindow), cxt.windowedEncoder(outputCoder));
        } else if (this.useCollectList && GroupByKeyHelpers.eligibleForGroupByWindow(windowing, false) && (windowing.getWindowFn().assignsToOneWindow() || transform.fewKeys())) {
            result = input.select(new Column[]{functions.explode((Column)functions.col((String)"windows")).as("window"), functions.col((String)"value"), functions.col((String)"timestamp")}).groupBy(new Column[]{functions.col((String)"value.key"), functions.col((String)"window")}).agg(functions.collect_list((Column)functions.col((String)"value.value")).as("values"), GroupByKeyTranslatorBatch.timestampAggregator(tsCombiner)).select(GroupByKeyTranslatorBatch.inSingleWindow(this.keyValue(functions.col((String)"key").as(keyEnc), functions.col((String)"values").as(this.iterableEnc(valueEnc))), functions.col((String)"window").as(cxt.windowEncoder()), GroupByKeyTranslatorBatch.windowTimestamp(tsCombiner)));
        } else if (GroupByKeyHelpers.eligibleForGroupByWindow(windowing, true) && (windowing.getWindowFn().assignsToOneWindow() || transform.fewKeys())) {
            Encoder windowedKeyEnc = cxt.tupleEncoder(cxt.windowEncoder(), keyEnc);
            result = cxt.getDataset((PCollection)cxt.getInput()).flatMap(GroupByKeyHelpers.explodeWindowedKey(GroupByKeyHelpers.valueValue()), cxt.tupleEncoder(windowedKeyEnc, valueEnc)).groupByKey(ScalaInterop.fun1(Tuple2::_1), windowedKeyEnc).mapValues(ScalaInterop.fun1(Tuple2::_2), valueEnc).mapGroups(ScalaInterop.fun2((wKey, it) -> GroupByKeyHelpers.windowedKV(wKey, GroupByKeyTranslatorBatch.iterableOnce(it))), cxt.windowedEncoder(outputCoder));
        } else {
            result = input.groupByKey(GroupByKeyHelpers.valueKey(), keyEnc).flatMapGroups(new GroupAlsoByWindowViaOutputBufferFn(windowing, key -> InMemoryStateInternals.forKey((Object)key), SystemReduceFn.buffering((Coder)inputCoder.getValueCoder()), cxt.getOptionsSupplier()), cxt.windowedEncoder(outputCoder));
        }
        cxt.putDataset((PCollection)cxt.getOutput(), result);
    }

    private @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized Iterable<V>> iterableEnc(@UnknownKeyFor @NonNull @Initialized Encoder<V> enc) {
        return EncoderHelpers.collectionEncoder(enc);
    }

    private static @UnknownKeyFor @NonNull @Initialized Column @UnknownKeyFor @NonNull @Initialized [] timestampAggregator(@UnknownKeyFor @NonNull @Initialized TimestampCombiner tsCombiner) {
        if (tsCombiner.equals((Object)TimestampCombiner.END_OF_WINDOW)) {
            return new Column[0];
        }
        Column agg = tsCombiner.equals((Object)TimestampCombiner.EARLIEST) ? functions.min((Column)functions.col((String)"timestamp")) : functions.max((Column)functions.col((String)"timestamp"));
        return new Column[]{agg.as("timestamp")};
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression windowTimestamp(@UnknownKeyFor @NonNull @Initialized TimestampCombiner tsCombiner) {
        if (tsCombiner.equals((Object)TimestampCombiner.END_OF_WINDOW)) {
            return GroupByKeyTranslatorBatch.litNull(DataTypes.LongType);
        }
        return functions.col((String)"timestamp").expr();
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Iterable<T> iterableOnce(@UnknownKeyFor @NonNull @Initialized Iterator<T> it) {
        return () -> {
            Preconditions.checkState((!it.isEmpty() ? 1 : 0) != 0, (Object)"Iterator on values can only be consumed once!");
            return ScalaInterop.javaIterator(it);
        };
    }

    private <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypedColumn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized KV<K, T>> keyValue(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypedColumn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, K> key, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypedColumn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> value) {
        return functions.struct((Column[])new Column[]{key.as("key"), value.as("value")}).as(EncoderHelpers.kvEncoder(key.encoder(), value.encoder()));
    }

    private static <InT, T> @UnknownKeyFor @NonNull @Initialized TypedColumn<InT, @UnknownKeyFor @NonNull @Initialized WindowedValue<T>> inGlobalWindow(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypedColumn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> value, @UnknownKeyFor @NonNull @Initialized Expression ts) {
        List<Expression> fields = ScalaInterop.concat(GroupByKeyTranslatorBatch.timestampedValue(value, ts), GLOBAL_WINDOW_DETAILS);
        Encoder enc = EncoderHelpers.windowedValueEncoder(value.encoder(), EncoderHelpers.encoderOf(GlobalWindow.class));
        return new Column((Expression)new CreateNamedStruct(fields)).as(enc);
    }

    public static <InT, T> @UnknownKeyFor @NonNull @Initialized TypedColumn<InT, @UnknownKeyFor @NonNull @Initialized WindowedValue<T>> inSingleWindow(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypedColumn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> value, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypedColumn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> window, @UnknownKeyFor @NonNull @Initialized Expression ts) {
        CreateArray windows = new CreateArray(ScalaInterop.listOf(window.expr()));
        List<Expression> fields = ScalaInterop.concat(GroupByKeyTranslatorBatch.timestampedValue(value, ts), GroupByKeyTranslatorBatch.windowDetails((Expression)windows));
        Encoder enc = EncoderHelpers.windowedValueEncoder(value.encoder(), window.encoder());
        return new Column((Expression)new CreateNamedStruct(fields)).as(enc);
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Expression> timestampedValue(@UnknownKeyFor @NonNull @Initialized Column value, @UnknownKeyFor @NonNull @Initialized Expression ts) {
        return ScalaInterop.seqOf(GroupByKeyTranslatorBatch.lit("value"), value.expr(), GroupByKeyTranslatorBatch.lit("timestamp"), ts).toList();
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Expression> windowDetails(@UnknownKeyFor @NonNull @Initialized Expression windows) {
        return ScalaInterop.seqOf(GroupByKeyTranslatorBatch.lit("windows"), windows, GroupByKeyTranslatorBatch.lit("pane"), PANE_NO_FIRING).toList();
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression lit(T t) {
        return Literal$.MODULE$.apply(t);
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression litNull(@UnknownKeyFor @NonNull @Initialized DataType dataType) {
        return new Literal(null, dataType);
    }

    private static interface SerStateInternalsFactory<@UnknownKeyFor K>
    extends StateInternalsFactory<K>,
    Serializable {
    }
}

