/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.UUID;
import javax.net.ssl.SSLException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.nio.ssl.BlockingSslHandler;
import org.apache.ignite.internal.util.nio.ssl.GridSslMeta;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.communication.tcp.internal.ClusterStateProvider;
import org.apache.ignite.spi.communication.tcp.internal.HandshakeException;
import org.apache.ignite.spi.communication.tcp.messages.HandshakeMessage;

public class TcpHandshakeExecutor {
    private final IgniteLogger log;
    private final ClusterStateProvider stateProvider;
    private final boolean directBuffer;

    public TcpHandshakeExecutor(IgniteLogger log, ClusterStateProvider stateProvider, boolean directBuffer) {
        this.log = log;
        this.stateProvider = stateProvider;
        this.directBuffer = directBuffer;
    }

    public long tcpHandshake(SocketChannel ch, UUID rmtNodeId, GridSslMeta sslMeta, HandshakeMessage msg) throws IgniteCheckedException {
        BlockingTransport transport = this.stateProvider.isSslEnabled() ? new SslTransport(sslMeta, ch, this.directBuffer, this.log) : new TcpTransport(ch);
        ByteBuffer buf = transport.receiveNodeId();
        if (buf == null) {
            return -3L;
        }
        UUID rmtNodeId0 = U.bytesToUuid(buf.array(), 2);
        if (!rmtNodeId.equals(rmtNodeId0)) {
            throw new HandshakeException("Remote node ID is not as expected [expected=" + rmtNodeId + ", rcvd=" + rmtNodeId0 + "]");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received remote node ID: " + rmtNodeId0);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Writing handshake message [rmtNode=" + rmtNodeId + ", msg=" + msg + "]");
        }
        transport.sendHandshake(msg);
        buf = transport.receiveAcknowledge();
        long rcvCnt = buf.getLong(2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received handshake message [rmtNode=" + rmtNodeId + ", rcvCnt=" + rcvCnt + "]");
        }
        if (rcvCnt == -1L && this.log.isDebugEnabled()) {
            this.log.debug("Connection rejected, will retry client creation [rmtNode=" + rmtNodeId + "]");
        }
        transport.onHandshakeFinished(sslMeta);
        return rcvCnt;
    }

    private static class SslTransport
    extends BlockingTransport {
        private static final int READ_BUFFER_CAPACITY = 1024;
        private final BlockingSslHandler handler;
        private final SocketChannel ch;
        private final ByteBuffer readBuf;

        SslTransport(GridSslMeta meta, SocketChannel ch, boolean directBuf, IgniteLogger log) throws IgniteCheckedException {
            try {
                this.ch = ch;
                this.handler = new BlockingSslHandler(meta.sslEngine(), ch, directBuf, ByteOrder.LITTLE_ENDIAN, log);
                if (!this.handler.handshake()) {
                    throw new HandshakeException("SSL handshake is not completed.");
                }
                this.readBuf = directBuf ? ByteBuffer.allocateDirect(1024) : ByteBuffer.allocate(1024);
                this.readBuf.order(ByteOrder.LITTLE_ENDIAN);
            }
            catch (SSLException e) {
                throw new IgniteCheckedException("SSL handhshake failed", e);
            }
        }

        @Override
        int read(ByteBuffer buf) throws IgniteCheckedException {
            ByteBuffer appBuff = this.handler.applicationBuffer();
            int read = this.copy(appBuff, buf);
            if (read > 0) {
                return read;
            }
            try {
                while (read == 0) {
                    this.readBuf.clear();
                    if (this.ch.read(this.readBuf) < 0) {
                        return -1;
                    }
                    this.readBuf.flip();
                    this.handler.decode(this.readBuf);
                    read = this.copy(appBuff, buf);
                }
            }
            catch (SSLException e) {
                throw new IgniteCheckedException("Failed to decrypt data", e);
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to read from channel", e);
            }
            return read;
        }

        @Override
        void write(ByteBuffer buf) throws IgniteCheckedException {
            try {
                U.writeFully(this.ch, this.handler.encrypt(buf));
            }
            catch (SSLException e) {
                throw new IgniteCheckedException("Failed to encrypt data", e);
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to write to channel", e);
            }
        }

        @Override
        void onHandshakeFinished(GridSslMeta sslMeta) {
            ByteBuffer inBuf;
            ByteBuffer appBuff = this.handler.applicationBuffer();
            if (appBuff.hasRemaining()) {
                sslMeta.decodedBuffer(appBuff);
            }
            if ((inBuf = this.handler.inputBuffer()).position() > 0) {
                inBuf.flip();
                sslMeta.encodedBuffer(inBuf);
            }
        }

        private int copy(ByteBuffer src, ByteBuffer dst) {
            int remaining = Math.min(src.remaining(), dst.remaining());
            if (remaining > 0) {
                int oldLimit = src.limit();
                src.limit(src.position() + remaining);
                dst.put(src);
                src.limit(oldLimit);
            }
            src.compact();
            return remaining;
        }
    }

    private static class TcpTransport
    extends BlockingTransport {
        private final SocketChannel ch;

        TcpTransport(SocketChannel ch) {
            this.ch = ch;
        }

        @Override
        int read(ByteBuffer buf) throws IgniteCheckedException {
            try {
                return this.ch.read(buf);
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to read from channel", e);
            }
        }

        @Override
        void write(ByteBuffer buf) throws IgniteCheckedException {
            try {
                U.writeFully(this.ch, buf);
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to write to channel", e);
            }
        }
    }

    private static abstract class BlockingTransport {
        private BlockingTransport() {
        }

        ByteBuffer receiveNodeId() throws IgniteCheckedException {
            int readBytes;
            ByteBuffer buf = ByteBuffer.allocate(18).order(ByteOrder.LITTLE_ENDIAN);
            for (int totalBytes = 0; totalBytes < 18; totalBytes += readBytes) {
                short msgType;
                readBytes = this.read(buf);
                if (readBytes == -1) {
                    throw new HandshakeException("Failed to read remote node ID (connection closed).");
                }
                if (readBytes < 2 || (msgType = TcpCommunicationSpi.makeMessageType(buf.get(0), buf.get(1))) != -28) continue;
                return null;
            }
            return buf;
        }

        void sendHandshake(HandshakeMessage msg) throws IgniteCheckedException {
            ByteBuffer buf = ByteBuffer.allocate(msg.getMessageSize() + U.IGNITE_HEADER.length).order(ByteOrder.LITTLE_ENDIAN).put(U.IGNITE_HEADER);
            msg.writeTo(buf, null);
            buf.flip();
            this.write(buf);
        }

        ByteBuffer receiveAcknowledge() throws IgniteCheckedException {
            int readBytes;
            ByteBuffer buf = ByteBuffer.allocate(10).order(ByteOrder.LITTLE_ENDIAN);
            for (int totalBytes = 0; totalBytes < 10; totalBytes += readBytes) {
                readBytes = this.read(buf);
                if (readBytes != -1) continue;
                throw new HandshakeException("Failed to read remote node recovery handshake (connection closed).");
            }
            return buf;
        }

        abstract int read(ByteBuffer var1) throws IgniteCheckedException;

        abstract void write(ByteBuffer var1) throws IgniteCheckedException;

        void onHandshakeFinished(GridSslMeta sslMeta) {
        }
    }
}

