/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.basic;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.ignite.internal.storage.DataRow;

public class SimpleDataRow
implements DataRow {
    private final byte[] key;
    private final byte[] value;

    public SimpleDataRow(byte[] key, byte[] value) {
        assert (key != null);
        assert (value != null);
        this.key = key;
        this.value = value;
    }

    @Override
    public ByteBuffer key() {
        return ByteBuffer.wrap(this.key);
    }

    @Override
    public byte[] keyBytes() {
        return this.key;
    }

    @Override
    public ByteBuffer value() {
        return ByteBuffer.wrap(this.value);
    }

    @Override
    public byte[] valueBytes() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataRow)) {
            return false;
        }
        DataRow row = (DataRow)o;
        return Arrays.equals(this.key, row.keyBytes()) && Arrays.equals(this.value, row.valueBytes());
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.key);
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }
}

