/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptor;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptorProvider;
import org.apache.ignite.internal.tostring.S;

public class DefaultRecoveryDescriptorProvider
implements RecoveryDescriptorProvider {
    private static final int DEFAULT_QUEUE_LIMIT = 10;
    private final Map<ChannelKey, RecoveryDescriptor> recoveryDescriptors = new ConcurrentHashMap<ChannelKey, RecoveryDescriptor>();

    @Override
    public RecoveryDescriptor getRecoveryDescriptor(String consistentId, UUID launchId, short connectionIndex, boolean inbound) {
        ChannelKey key = new ChannelKey(consistentId, launchId, connectionIndex, inbound);
        return this.recoveryDescriptors.computeIfAbsent(key, channelKey -> new RecoveryDescriptor(10));
    }

    private static class ChannelKey {
        private final String consistentId;
        private final UUID launchId;
        private final short connectionId;
        private final boolean inbound;

        private ChannelKey(String consistentId, UUID launchId, short connectionId, boolean inbound) {
            this.consistentId = consistentId;
            this.launchId = launchId;
            this.connectionId = connectionId;
            this.inbound = inbound;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChannelKey that = (ChannelKey)o;
            if (this.connectionId != that.connectionId) {
                return false;
            }
            if (this.inbound != that.inbound) {
                return false;
            }
            if (!this.consistentId.equals(that.consistentId)) {
                return false;
            }
            return this.launchId.equals(that.launchId);
        }

        public int hashCode() {
            int result = this.consistentId.hashCode();
            result = 31 * result + this.launchId.hashCode();
            result = 31 * result + this.connectionId;
            result = 31 * result + (this.inbound ? 1 : 0);
            return result;
        }

        public String toString() {
            return S.toString(ChannelKey.class, (Object)this);
        }
    }
}

