/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.common.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.raft.client.WriteCommand;
import org.jetbrains.annotations.NotNull;

public final class WatchExactKeysCommand
implements WriteCommand {
    @NotNull
    private final List<byte[]> keys;
    private final long revision;
    @NotNull
    private final String requesterNodeId;
    @NotNull
    private final IgniteUuid cursorId;

    public WatchExactKeysCommand(@NotNull Set<ByteArray> keys, long revision, @NotNull String requesterNodeId, @NotNull IgniteUuid cursorId) {
        this.keys = new ArrayList<byte[]>(keys.size());
        for (ByteArray key : keys) {
            this.keys.add(key.bytes());
        }
        this.revision = revision;
        this.requesterNodeId = requesterNodeId;
        this.cursorId = cursorId;
    }

    @NotNull
    public List<byte[]> keys() {
        return this.keys;
    }

    @NotNull
    public Long revision() {
        return this.revision;
    }

    @NotNull
    public String requesterNodeId() {
        return this.requesterNodeId;
    }

    @NotNull
    public IgniteUuid getCursorId() {
        return this.cursorId;
    }
}

