/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableSpool;
import org.apache.ignite.internal.sql.engine.rule.ImmutableFilterSpoolMergeToHashIndexSpoolRule;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterSpoolMergeToHashIndexSpoolRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    private FilterSpoolMergeToHashIndexSpoolRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteFilter filter = (IgniteFilter)call.rel(0);
        IgniteTableSpool spool = (IgniteTableSpool)call.rel(1);
        RelOptCluster cluster = spool.getCluster();
        RelTraitSet trait = spool.getTraitSet();
        CorrelationTrait filterCorr = TraitUtils.correlation((RelNode)filter);
        if (filterCorr.correlated()) {
            trait = trait.replace((RelTrait)filterCorr);
        }
        RelNode input = spool.getInput();
        List<RexNode> searchRow = RexUtils.buildHashSearchRow(cluster, filter.getCondition(), spool.getRowType());
        if (CollectionUtils.nullOrEmpty(searchRow)) {
            return;
        }
        IgniteHashIndexSpool res = new IgniteHashIndexSpool(cluster, trait.replace((RelTrait)RelCollations.EMPTY), input, searchRow, filter.getCondition());
        call.transformTo((RelNode)res);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterSpoolMergeToHashIndexSpoolRule.Config.of().withDescription("FilterSpoolMergeToHashIndexSpoolRule").withOperandFor(IgniteFilter.class, IgniteTableSpool.class);

        default public Config withOperandFor(Class<? extends Filter> filterClass, Class<? extends Spool> spoolClass) {
            return (Config)this.withOperandSupplier(o0 -> o0.operand(filterClass).oneInput(o1 -> o1.operand(spoolClass).anyInputs())).as(Config.class);
        }

        default public FilterSpoolMergeToHashIndexSpoolRule toRule() {
            return new FilterSpoolMergeToHashIndexSpoolRule(this);
        }
    }
}

