/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.index.IndexRow;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.table.distributed.IndexLocker;
import org.apache.ignite.internal.tx.LockKey;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.LockMode;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class SortedIndexLocker
implements IndexLocker {
    private static final BinaryTuple POSITIVE_INF = new BinaryTuple(BinaryTupleSchema.create((BinaryTupleSchema.Element[])new BinaryTupleSchema.Element[0]), new BinaryTupleBuilder(0, false).build());
    private final UUID indexId;
    private final LockManager lockManager;
    private final Function<BinaryRow, BinaryTuple> indexRowResolver;

    public SortedIndexLocker(UUID indexId, LockManager lockManager, SortedIndexStorage storage, Function<BinaryRow, BinaryTuple> indexRowResolver) {
        this.indexId = indexId;
        this.lockManager = lockManager;
        this.indexRowResolver = indexRowResolver;
    }

    @Override
    public UUID id() {
        return this.indexId;
    }

    @Override
    public CompletableFuture<?> locksForLookup(UUID txId, BinaryRow tableRow) {
        BinaryTuple key = this.indexRowResolver.apply(tableRow);
        return this.lockManager.acquire(txId, new LockKey(this.indexId, (Object)key.byteBuffer()), LockMode.S);
    }

    public CompletableFuture<IndexRow> locksForScan(UUID txId, Cursor<IndexRow> cursor) {
        if (!cursor.hasNext()) {
            return this.lockManager.acquire(txId, new LockKey(this.indexId, (Object)POSITIVE_INF.byteBuffer()), LockMode.S).thenCompose(ignore -> CompletableFuture.completedFuture(null));
        }
        IndexRow nextRow = (IndexRow)cursor.next();
        return this.lockManager.acquire(txId, new LockKey(this.indexId, (Object)nextRow.indexColumns().byteBuffer()), LockMode.S).thenCompose(ignore -> CompletableFuture.completedFuture(nextRow));
    }

    private BinaryTuple indexKey(@Nullable IndexRow indexRow) {
        return indexRow == null ? POSITIVE_INF : indexRow.indexColumns();
    }

    @Override
    public CompletableFuture<?> locksForInsert(UUID txId, BinaryRow tableRow, RowId rowId) {
        BinaryTuple key = this.indexRowResolver.apply(tableRow);
        return this.lockManager.acquire(txId, new LockKey(this.indexId, (Object)key.byteBuffer()), LockMode.X);
    }

    @Override
    public CompletableFuture<?> locksForRemove(UUID txId, BinaryRow tableRow, RowId rowId) {
        BinaryTuple key = this.indexRowResolver.apply(tableRow);
        return this.lockManager.acquire(txId, new LockKey(this.indexId, (Object)key.byteBuffer()), LockMode.IX);
    }
}

