/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.client.CompoundCondition;
import org.apache.ignite.internal.metastorage.client.Condition;
import org.apache.ignite.internal.metastorage.client.Conditions;
import org.apache.ignite.internal.metastorage.client.Entry;
import org.apache.ignite.internal.metastorage.client.If;
import org.apache.ignite.internal.metastorage.client.Operation;
import org.apache.ignite.internal.metastorage.client.Operations;
import org.apache.ignite.internal.metastorage.client.SimpleCondition;
import org.apache.ignite.internal.metastorage.client.StatementResult;
import org.apache.ignite.internal.metastorage.client.Update;
import org.apache.ignite.internal.raft.server.RaftGroupEventsListener;
import org.apache.ignite.internal.schema.configuration.ExtendedTableChange;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.table.distributed.replicator.TablePartitionId;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.utils.RebalanceUtil;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.raft.client.Peer;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.core.NodeImpl;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;

public class RebalanceRaftGroupEventsListener
implements RaftGroupEventsListener {
    private static final IgniteLogger LOG = Loggers.forClass(RebalanceRaftGroupEventsListener.class);
    private static final int REBALANCE_RETRY_THRESHOLD = 10;
    public static final int REBALANCE_RETRY_DELAY_MS = 200;
    private static final int SWITCH_APPEND_SUCCESS = 1;
    private static final int SWITCH_REDUCE_SUCCESS = 2;
    private static final int SCHEDULE_PENDING_REBALANCE_SUCCESS = 3;
    private static final int FINISH_REBALANCE_SUCCESS = 4;
    private static final int SWITCH_APPEND_FAIL = -1;
    private static final int SWITCH_REDUCE_FAIL = -2;
    private static final int SCHEDULE_PENDING_REBALANCE_FAIL = -3;
    private static final int FINISH_REBALANCE_FAIL = -4;
    private final MetaStorageManager metaStorageMgr;
    private final TableConfiguration tblConfiguration;
    private final TablePartitionId partId;
    private final int partNum;
    private final IgniteSpinBusyLock busyLock;
    private final ScheduledExecutorService rebalanceScheduler;
    private final BiFunction<List<Peer>, Long, CompletableFuture<Void>> movePartitionFn;
    private final AtomicInteger rebalanceAttempts = new AtomicInteger(0);
    private final BiFunction<TableConfiguration, Integer, Set<ClusterNode>> calculateAssignmentsFn;

    public RebalanceRaftGroupEventsListener(MetaStorageManager metaStorageMgr, TableConfiguration tblConfiguration, TablePartitionId partId, int partNum, IgniteSpinBusyLock busyLock, BiFunction<List<Peer>, Long, CompletableFuture<Void>> movePartitionFn, BiFunction<TableConfiguration, Integer, Set<ClusterNode>> calculateAssignmentsFn, ScheduledExecutorService rebalanceScheduler) {
        this.metaStorageMgr = metaStorageMgr;
        this.tblConfiguration = tblConfiguration;
        this.partId = partId;
        this.partNum = partNum;
        this.busyLock = busyLock;
        this.movePartitionFn = movePartitionFn;
        this.calculateAssignmentsFn = calculateAssignmentsFn;
        this.rebalanceScheduler = rebalanceScheduler;
    }

    public void onLeaderElected(long term) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.rebalanceScheduler.schedule(() -> {
                if (!this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    this.rebalanceAttempts.set(0);
                    Entry pendingEntry = (Entry)this.metaStorageMgr.get(RebalanceUtil.pendingPartAssignmentsKey(this.partId)).get();
                    if (!pendingEntry.empty()) {
                        Set pendingNodes = (Set)ByteUtils.fromBytes((byte[])pendingEntry.value());
                        LOG.info("New leader elected. Going to reconfigure peers [group={}, partition={}, table={}, peers={}]", new Object[]{this.partId, this.partNum, this.tblConfiguration.name().value(), pendingNodes});
                        this.movePartitionFn.apply(RebalanceRaftGroupEventsListener.clusterNodesToPeers(pendingNodes), term).join();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn("Unable to start rebalance [partition={}, table={}, term={}]", (Throwable)e, new Object[]{this.partNum, this.tblConfiguration.name().value(), term});
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void onNewPeersConfigurationApplied(List<PeerId> peers) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.rebalanceScheduler.schedule(() -> {
                if (!this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    this.doOnNewPeersConfigurationApplied(peers);
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReconfigurationError(Status status, List<PeerId> peers, long term) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            assert (status != null);
            if (status.equals((Object)NodeImpl.LEADER_STEPPED_DOWN)) {
                LOG.info("Leader stepped down during rebalance [partId={}]", new Object[]{this.partId});
                return;
            }
            RaftError raftError = status.getRaftError();
            assert (raftError == RaftError.ECATCHUP) : "According to the JRaft protocol, " + RaftError.ECATCHUP + " is expected, got " + raftError;
            LOG.debug("Error occurred during rebalance [partId={}]", new Object[]{this.partId});
            if (this.rebalanceAttempts.incrementAndGet() < 10) {
                this.scheduleChangePeers(peers, term);
            } else {
                LOG.info("Number of retries for rebalance exceeded the threshold [partId={}, threshold={}]", new Object[]{this.partId, 10});
                this.scheduleChangePeers(peers, term);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void scheduleChangePeers(List<PeerId> peers, long term) {
        this.rebalanceScheduler.schedule(() -> {
            if (!this.busyLock.enterBusy()) {
                return;
            }
            LOG.info("Going to retry rebalance [attemptNo={}, partId={}]", new Object[]{this.rebalanceAttempts.get(), this.partId});
            try {
                this.movePartitionFn.apply(RebalanceRaftGroupEventsListener.peerIdsToPeers(peers), term).join();
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }, 200L, TimeUnit.MILLISECONDS);
    }

    private void doOnNewPeersConfigurationApplied(List<PeerId> peers) {
        try {
            Update failCase;
            Update successCase;
            ByteArray pendingPartAssignmentsKey = RebalanceUtil.pendingPartAssignmentsKey(this.partId);
            ByteArray stablePartAssignmentsKey = RebalanceUtil.stablePartAssignmentsKey(this.partId);
            ByteArray plannedPartAssignmentsKey = RebalanceUtil.plannedPartAssignmentsKey(this.partId);
            ByteArray switchReduceKey = RebalanceUtil.switchReduceKey(this.partId);
            ByteArray switchAppendKey = RebalanceUtil.switchAppendKey(this.partId);
            Map values = (Map)this.metaStorageMgr.getAll(Set.of(plannedPartAssignmentsKey, pendingPartAssignmentsKey, stablePartAssignmentsKey, switchReduceKey, switchAppendKey)).get();
            Entry stableEntry = (Entry)values.get(stablePartAssignmentsKey);
            Entry pendingEntry = (Entry)values.get(pendingPartAssignmentsKey);
            Entry plannedEntry = (Entry)values.get(plannedPartAssignmentsKey);
            Entry switchReduceEntry = (Entry)values.get(switchReduceKey);
            Entry switchAppendEntry = (Entry)values.get(switchAppendKey);
            Set<ClusterNode> calculatedAssignments = this.calculateAssignmentsFn.apply(this.tblConfiguration, this.partNum);
            Set<ClusterNode> stable = RebalanceUtil.resolveClusterNodes(peers, pendingEntry.value(), stableEntry.value());
            Set<ClusterNode> retrievedSwitchReduce = RebalanceUtil.readClusterNodes(switchReduceEntry);
            Set<ClusterNode> retrievedSwitchAppend = RebalanceUtil.readClusterNodes(switchAppendEntry);
            Set<ClusterNode> retrievedStable = RebalanceUtil.readClusterNodes(stableEntry);
            Set<ClusterNode> reducedNodes = RebalanceUtil.subtract(retrievedSwitchReduce, stable);
            Set<ClusterNode> addedNodes = RebalanceUtil.subtract(stable, retrievedStable);
            Set<ClusterNode> calculatedSwitchReduce = RebalanceUtil.subtract(retrievedSwitchReduce, reducedNodes);
            Set<ClusterNode> calculatedSwitchAppend = RebalanceUtil.union(retrievedSwitchAppend, reducedNodes);
            calculatedSwitchAppend = RebalanceUtil.subtract(calculatedSwitchAppend, addedNodes);
            calculatedSwitchAppend = RebalanceUtil.intersect(calculatedAssignments, calculatedSwitchAppend);
            Set<ClusterNode> calculatedPendingReduction = RebalanceUtil.subtract(stable, retrievedSwitchReduce);
            Set<ClusterNode> calculatedPendingAddition = RebalanceUtil.union(stable, reducedNodes);
            calculatedPendingAddition = RebalanceUtil.intersect(calculatedAssignments, calculatedPendingAddition);
            SimpleCondition con1 = stableEntry.empty() ? Conditions.notExists((ByteArray)stablePartAssignmentsKey) : Conditions.revision((ByteArray)stablePartAssignmentsKey).eq(stableEntry.revision());
            SimpleCondition con2 = Conditions.revision((ByteArray)pendingPartAssignmentsKey).eq(pendingEntry.revision());
            SimpleCondition con3 = switchReduceEntry.empty() ? Conditions.notExists((ByteArray)switchReduceKey) : Conditions.revision((ByteArray)switchReduceKey).eq(switchReduceEntry.revision());
            SimpleCondition con4 = switchAppendEntry.empty() ? Conditions.notExists((ByteArray)switchAppendKey) : Conditions.revision((ByteArray)switchAppendKey).eq(switchAppendEntry.revision());
            CompoundCondition retryPreconditions = CompoundCondition.and((Condition)con1, (Condition)CompoundCondition.and((Condition)con2, (Condition)CompoundCondition.and((Condition)con3, (Condition)con4)));
            this.tblConfiguration.change(ch -> {
                List assignments = (List)ByteUtils.fromBytes((byte[])((ExtendedTableChange)ch).assignments());
                assignments.set(this.partNum, stable);
                ((ExtendedTableChange)ch).changeAssignments(ByteUtils.toBytes((Object)assignments));
            }).get(10L, TimeUnit.SECONDS);
            byte[] stableByteArray = ByteUtils.toBytes(stable);
            byte[] additionByteArray = ByteUtils.toBytes(calculatedPendingAddition);
            byte[] reductionByteArray = ByteUtils.toBytes(calculatedPendingReduction);
            byte[] switchReduceByteArray = ByteUtils.toBytes(calculatedSwitchReduce);
            byte[] switchAppendByteArray = ByteUtils.toBytes(calculatedSwitchAppend);
            if (!calculatedSwitchAppend.isEmpty()) {
                successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])stableByteArray), Operations.put((ByteArray)pendingPartAssignmentsKey, (byte[])additionByteArray), Operations.put((ByteArray)switchReduceKey, (byte[])switchReduceByteArray), Operations.put((ByteArray)switchAppendKey, (byte[])switchAppendByteArray)}).yield(1);
                failCase = Operations.ops((Operation[])new Operation[0]).yield(-1);
            } else if (!calculatedSwitchReduce.isEmpty()) {
                successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])stableByteArray), Operations.put((ByteArray)pendingPartAssignmentsKey, (byte[])reductionByteArray), Operations.put((ByteArray)switchReduceKey, (byte[])switchReduceByteArray), Operations.put((ByteArray)switchAppendKey, (byte[])switchAppendByteArray)}).yield(2);
                failCase = Operations.ops((Operation[])new Operation[0]).yield(-2);
            } else {
                SimpleCondition con5;
                if (plannedEntry.value() != null) {
                    con5 = Conditions.revision((ByteArray)plannedPartAssignmentsKey).eq(plannedEntry.revision());
                    successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])ByteUtils.toBytes(stable)), Operations.put((ByteArray)pendingPartAssignmentsKey, (byte[])plannedEntry.value()), Operations.remove((ByteArray)plannedPartAssignmentsKey)}).yield(3);
                    failCase = Operations.ops((Operation[])new Operation[0]).yield(-3);
                } else {
                    con5 = Conditions.notExists((ByteArray)plannedPartAssignmentsKey);
                    successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])ByteUtils.toBytes(stable)), Operations.remove((ByteArray)pendingPartAssignmentsKey)}).yield(4);
                    failCase = Operations.ops((Operation[])new Operation[0]).yield(-4);
                }
                retryPreconditions = CompoundCondition.and((Condition)retryPreconditions, (Condition)con5);
            }
            int res = ((StatementResult)this.metaStorageMgr.invoke(If.iif((Condition)retryPreconditions, (Update)successCase, (Update)failCase)).get()).getAsInt();
            if (res < 0) {
                switch (res) {
                    case -1: {
                        LOG.info("Rebalance keys changed while trying to update rebalance pending addition information. Going to retry [partition={}, table={}, appliedPeers={}]", new Object[]{this.partNum, this.tblConfiguration.name(), stable});
                        break;
                    }
                    case -2: {
                        LOG.info("Rebalance keys changed while trying to update rebalance pending reduce information. Going to retry [partition={}, table={}, appliedPeers={}]", new Object[]{this.partNum, this.tblConfiguration.name(), stable});
                        break;
                    }
                    case -4: 
                    case -3: {
                        LOG.info("Rebalance keys changed while trying to update rebalance information. Going to retry [partition={}, table={}, appliedPeers={}]", new Object[]{this.partNum, this.tblConfiguration.name(), stable});
                        break;
                    }
                    default: {
                        assert (false) : res;
                        break;
                    }
                }
                this.doOnNewPeersConfigurationApplied(peers);
                return;
            }
            switch (res) {
                case 1: {
                    LOG.info("Rebalance finished. Going to schedule next rebalance with addition [partition={}, table={}, appliedPeers={}, plannedPeers={}]", new Object[]{this.partNum, this.tblConfiguration.name().value(), stable, calculatedPendingAddition});
                    break;
                }
                case 2: {
                    LOG.info("Rebalance finished. Going to schedule next rebalance with reduction [partition={}, table={}, appliedPeers={}, plannedPeers={}]", new Object[]{this.partNum, this.tblConfiguration.name().value(), stable, calculatedPendingReduction});
                    break;
                }
                case 3: {
                    LOG.info("Rebalance finished. Going to schedule next rebalance [partition={}, table={}, appliedPeers={}, plannedPeers={}]", new Object[]{this.partNum, this.tblConfiguration.name().value(), stable, ByteUtils.fromBytes((byte[])plannedEntry.value())});
                    break;
                }
                case 4: {
                    LOG.info("Rebalance finished [partition={}, table={}, appliedPeers={}]", new Object[]{this.partNum, this.tblConfiguration.name().value(), stable});
                    break;
                }
                default: {
                    assert (false) : res;
                    break;
                }
            }
            this.rebalanceAttempts.set(0);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.warn("Unable to commit partition configuration to metastore [table = {}, partition = {}]", (Throwable)e, new Object[]{this.tblConfiguration.name(), this.partNum});
        }
    }

    private static List<Peer> clusterNodesToPeers(Set<ClusterNode> nodes) {
        ArrayList<Peer> peers = new ArrayList<Peer>(nodes.size());
        for (ClusterNode node : nodes) {
            peers.add(new Peer(node.address()));
        }
        return peers;
    }

    private static List<Peer> peerIdsToPeers(List<PeerId> peerIds) {
        ArrayList<Peer> peers = new ArrayList<Peer>(peerIds.size());
        for (PeerId peerId : peerIds) {
            peers.add(new Peer(NetworkAddress.from((String)peerId.getEndpoint().toString())));
        }
        return peers;
    }
}

