/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing;

import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionSnapshotStorage;
import org.apache.ignite.internal.table.distributed.raft.snapshot.SnapshotUri;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.OutgoingSnapshot;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;

public class OutgoingSnapshotReader
extends SnapshotReader {
    private final UUID id = UUID.randomUUID();
    private final PartitionSnapshotStorage snapshotStorage;
    private final RaftOutter.SnapshotMeta snapshotMeta;

    public OutgoingSnapshotReader(PartitionSnapshotStorage snapshotStorage) {
        this.snapshotStorage = snapshotStorage;
        this.snapshotMeta = new RaftMessagesFactory().snapshotMeta().lastIncludedIndex(snapshotStorage.partition().persistedIndex()).lastIncludedTerm(snapshotStorage.startupSnapshotMeta().lastIncludedTerm()).peersList(snapshotStorage.startupSnapshotMeta().peersList()).learnersList(snapshotStorage.startupSnapshotMeta().learnersList()).build();
        OutgoingSnapshot outgoingSnapshot = new OutgoingSnapshot();
        snapshotStorage.outgoingSnapshotsManager().registerOutgoingSnapshot(this.id, outgoingSnapshot);
    }

    public RaftOutter.SnapshotMeta load() {
        return this.snapshotMeta;
    }

    public String generateURIForCopy() {
        String localNodeName = this.snapshotStorage.topologyService().localMember().name();
        return SnapshotUri.toStringUri(this.id, localNodeName);
    }

    public void close() throws IOException {
        this.snapshotStorage.outgoingSnapshotsManager().finishOutgoingSnapshot(this.id);
    }

    public boolean init(Void opts) {
        return true;
    }

    public void shutdown() {
    }

    public String getPath() {
        throw new UnsupportedOperationException("No path for the rebalance snapshot");
    }

    public Set<String> listFiles() {
        return Set.of();
    }

    public Message getFileMeta(String fileName) {
        throw new UnsupportedOperationException("No files in the snapshot");
    }
}

