/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.tostring.S;

public class Columns {
    public static final int[][] EMPTY_FOLDING_TABLE = new int[0][];
    public static final int[] EMPTY_FOLDING_MASK = new int[0];
    private static final int[] NULL_COLUMNS_LOOKUP = new int[256];
    private final Column[] cols;
    private final int firstVarlenColIdx;
    private final int nullMapSize;
    private int fixedSizeMaxLen;
    private int[][] foldingTbl;
    private int[] foldingMask;
    public static final Comparator<Column> COLUMN_COMPARATOR;

    public static int numberOfNullColumns(byte nullMap) {
        return NULL_COLUMNS_LOOKUP[nullMap & 0xFF];
    }

    Columns(int baseSchemaIdx, Column ... cols) {
        this.cols = this.sortedCopy(baseSchemaIdx, cols);
        this.firstVarlenColIdx = this.findFirstVarlenColumn();
        this.nullMapSize = this.hasNullableColumn() ? (cols.length + 7) / 8 : 0;
        this.buildFoldingTable();
    }

    public int foldFixedLength(int i, int maskByte) {
        return this.foldingTbl[i][maskByte & this.foldingMask[i]];
    }

    public int nullMapSize() {
        return this.nullMapSize;
    }

    public boolean isFixedSize(int idx) {
        return this.cols[idx].type().spec().fixedLength();
    }

    public Column column(int idx) {
        return this.cols[idx];
    }

    public Column[] columns() {
        return this.cols;
    }

    public int length() {
        return this.cols.length;
    }

    public int numberOfVarlengthColumns() {
        return this.cols.length - this.numberOfFixsizeColumns();
    }

    public int numberOfFixsizeColumns() {
        return this.firstVarlenColIdx == -1 ? this.cols.length : this.firstVarlenColIdx;
    }

    public int firstVarlengthColumn() {
        return this.firstVarlenColIdx;
    }

    public boolean hasVarlengthColumns() {
        return this.firstVarlenColIdx != -1;
    }

    public int fixsizeMaxLen() {
        return this.fixedSizeMaxLen;
    }

    private Column[] sortedCopy(int schemaBaseIdx, Column[] cols) {
        Column[] cp = Arrays.copyOf(cols, cols.length);
        Arrays.sort(cp, COLUMN_COMPARATOR);
        for (int i = 0; i < cp.length; ++i) {
            Column c = cp[i];
            cp[i] = c.copy(schemaBaseIdx + i);
        }
        return cp;
    }

    private int findFirstVarlenColumn() {
        for (int i = 0; i < this.cols.length; ++i) {
            if (this.cols[i].type().spec().fixedLength()) continue;
            return i;
        }
        return -1;
    }

    private boolean hasNullableColumn() {
        for (int i = 0; i < this.cols.length; ++i) {
            if (!this.cols[i].nullable()) continue;
            return true;
        }
        return false;
    }

    private void buildFoldingTable() {
        int numFixsize = this.numberOfFixsizeColumns();
        if (numFixsize == 0) {
            this.foldingTbl = EMPTY_FOLDING_TABLE;
            this.foldingMask = EMPTY_FOLDING_MASK;
            this.fixedSizeMaxLen = 0;
            return;
        }
        if (this.hasVarlengthColumns()) {
            ++numFixsize;
        }
        int fixsizeNullMapSize = (numFixsize + 7) / 8;
        int maxLen = 0;
        int[][] res = new int[fixsizeNullMapSize][];
        int[] resMask = new int[fixsizeNullMapSize];
        for (int b = 0; b < fixsizeNullMapSize; ++b) {
            int bitsInMask = b == fixsizeNullMapSize - 1 ? numFixsize - 8 * b : 8;
            int totalMasks = 1 << bitsInMask;
            resMask[b] = 255 >>> 8 - bitsInMask;
            res[b] = new int[totalMasks];
            int mask = 0;
            for (int i = 0; i < totalMasks; ++i) {
                res[b][mask] = this.foldManual(b, mask);
                ++mask;
            }
            maxLen += res[b][0];
        }
        this.foldingTbl = res;
        this.foldingMask = resMask;
        this.fixedSizeMaxLen = maxLen;
    }

    private int foldManual(int b, int mask) {
        int size = 0;
        for (int bit = 0; bit < 8; ++bit) {
            boolean hasVal = (mask & 1 << bit) == 0;
            int idx = b * 8 + bit;
            if (!hasVal || idx >= this.numberOfFixsizeColumns()) continue;
            assert (this.cols[idx].type().spec().fixedLength()) : "Expected fixed-size column [b=" + b + ", mask=" + mask + ", cols" + Arrays.toString(this.cols) + "]";
            size += this.cols[idx].type().sizeInBytes();
        }
        return size;
    }

    public int columnIndex(String colName) {
        for (int i = 0; i < this.cols.length; ++i) {
            if (!this.cols[i].name().equalsIgnoreCase(colName)) continue;
            return i;
        }
        throw new NoSuchElementException("No field '" + colName + "' defined");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Columns columns = (Columns)o;
        return Arrays.equals(this.cols, columns.cols);
    }

    public int hashCode() {
        return Arrays.hashCode(this.cols);
    }

    public String toString() {
        return S.arrayToString((Object)this.cols);
    }

    static {
        for (int i = 0; i < 255; ++i) {
            Columns.NULL_COLUMNS_LOOKUP[i] = Integer.bitCount(i);
        }
        COLUMN_COMPARATOR = Comparator.comparing(Column::type).thenComparing(Column::name);
    }
}

