/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.AbstractHttpContentProcessor;
import io.micronaut.http.server.netty.MicronautHttpPostMultipartRequestDecoder;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class FormDataHttpContentProcessor
extends AbstractHttpContentProcessor<HttpData> {
    private final InterfaceHttpPostRequestDecoder decoder;
    private final boolean enabled;
    private final AtomicLong extraMessages = new AtomicLong(0L);
    private final long partMaxSize;
    private volatile boolean pleaseDestroy = false;
    private volatile boolean inFlight = false;
    private boolean destroyed = false;

    FormDataHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, NettyHttpServerConfiguration configuration) {
        super(nettyHttpRequest, configuration);
        Charset characterEncoding = nettyHttpRequest.getCharacterEncoding();
        HttpServerConfiguration.MultipartConfiguration multipart = configuration.getMultipart();
        DefaultHttpDataFactory factory = multipart.isDisk() ? new DefaultHttpDataFactory(true, characterEncoding) : (multipart.isMixed() ? new DefaultHttpDataFactory(multipart.getThreshold(), characterEncoding) : new DefaultHttpDataFactory(false, characterEncoding));
        factory.setMaxLimit(multipart.getMaxFileSize());
        HttpRequest nativeRequest = nettyHttpRequest.getNativeRequest();
        this.decoder = HttpPostRequestDecoder.isMultipart((HttpRequest)nativeRequest) ? new MicronautHttpPostMultipartRequestDecoder((HttpDataFactory)factory, nativeRequest, characterEncoding) : new HttpPostStandardRequestDecoder((HttpDataFactory)factory, nativeRequest, characterEncoding);
        this.enabled = nettyHttpRequest.getContentType().map(type -> type.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)).orElse(false) != false || multipart.isEnabled();
        this.partMaxSize = multipart.getMaxFileSize();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void doOnSubscribe(final Subscription subscription, Subscriber<? super HttpData> subscriber) {
        subscriber.onSubscribe(new Subscription(){

            public void request(long n) {
                FormDataHttpContentProcessor.this.extraMessages.updateAndGet(p -> {
                    long newVal = p - n;
                    if (newVal < 0L) {
                        subscription.request(n - p);
                        return 0L;
                    }
                    return newVal;
                });
            }

            public void cancel() {
                subscription.cancel();
                FormDataHttpContentProcessor.this.pleaseDestroy = true;
                FormDataHttpContentProcessor.this.destroyIfRequested();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void onData(ByteBufHolder message) {
        var3_2 = this;
        synchronized (var3_2) {
            if (this.destroyed) {
                skip = true;
            } else {
                skip = false;
                this.inFlight = true;
            }
        }
        if (skip) {
            message.release();
            return;
        }
        subscriber = this.getSubscriber();
        if (message instanceof HttpContent) {
            httpContent = (HttpContent)message;
            messages = new ArrayList<Object>(1);
            try {
                postRequestDecoder = this.decoder;
                postRequestDecoder.offer(httpContent);
                while (postRequestDecoder.hasNext()) {
                    data = postRequestDecoder.next();
                    data.touch();
                    switch (2.$SwitchMap$io$netty$handler$codec$http$multipart$InterfaceHttpData$HttpDataType[data.getHttpDataType().ordinal()]) {
                        case 1: {
                            attribute = (Attribute)data;
                            messages.add(attribute.retain());
                            postRequestDecoder.removeHttpDataFromClean((InterfaceHttpData)attribute);
                            break;
                        }
                        case 2: {
                            fileUpload = (FileUpload)data;
                            if (!fileUpload.isCompleted()) break;
                            messages.add(fileUpload.retain());
                            postRequestDecoder.removeHttpDataFromClean((InterfaceHttpData)fileUpload);
                            break;
                        }
                    }
                }
                currentPartialHttpData = postRequestDecoder.currentPartialHttpData();
                if (!(currentPartialHttpData instanceof HttpData)) ** GOTO lbl83
                messages.add(currentPartialHttpData.retain());
            }
            catch (HttpPostRequestDecoder.EndOfDataDecoderException postRequestDecoder) {
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                cause = e.getCause();
                if (cause instanceof IOException && cause.getMessage().equals("Size exceed allowed maximum capacity")) {
                    partName = this.decoder.currentPartialHttpData().getName();
                    try {
                        this.onError((Throwable)new ContentLengthExceededException("The part named [" + partName + "] exceeds the maximum allowed content length [" + this.partMaxSize + "]"));
                    }
                    finally {
                        this.parentSubscription.cancel();
                    }
                }
                this.onError(e);
            }
            catch (Throwable e) {
                this.onError(e);
            }
            finally {
                if (messages.isEmpty()) {
                    this.subscription.request(1L);
                } else {
                    this.extraMessages.updateAndGet((LongUnaryOperator)LambdaMetafactory.metafactory(null, null, null, (J)J, lambda$onData$1(java.util.List long ), (J)J)(messages));
                    messages.stream().map((Function<InterfaceHttpData, HttpData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lio/netty/handler/codec/http/multipart/InterfaceHttpData;)Lio/netty/handler/codec/http/multipart/HttpData;)(HttpData.class)).forEach((Consumer<HttpData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, onNext(java.lang.Object ), (Lio/netty/handler/codec/http/multipart/HttpData;)V)((Subscriber)subscriber));
                }
                httpContent.release();
            }
        } else {
            message.release();
        }
lbl83:
        // 7 sources

        this.inFlight = false;
        this.destroyIfRequested();
    }

    protected void doAfterOnError(Throwable throwable) {
        this.pleaseDestroy = true;
        this.destroyIfRequested();
    }

    protected void doAfterComplete() {
        this.pleaseDestroy = true;
        this.destroyIfRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIfRequested() {
        boolean destroy;
        FormDataHttpContentProcessor formDataHttpContentProcessor = this;
        synchronized (formDataHttpContentProcessor) {
            if (this.pleaseDestroy && !this.destroyed && !this.inFlight) {
                destroy = true;
                this.destroyed = true;
            } else {
                destroy = false;
            }
        }
        if (destroy) {
            this.decoder.destroy();
        }
    }

    private static /* synthetic */ long lambda$onData$1(List messages, long p) {
        return p + (long)messages.size() - 1L;
    }
}

