/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.ddl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.index.IndexManager;
import org.apache.ignite.internal.schema.BitmaskNativeType;
import org.apache.ignite.internal.schema.DecimalNativeType;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.NumberNativeType;
import org.apache.ignite.internal.schema.TemporalNativeType;
import org.apache.ignite.internal.schema.VarlenNativeType;
import org.apache.ignite.internal.schema.configuration.ColumnChange;
import org.apache.ignite.internal.schema.configuration.ColumnTypeChange;
import org.apache.ignite.internal.schema.configuration.ColumnView;
import org.apache.ignite.internal.schema.configuration.PrimaryKeyView;
import org.apache.ignite.internal.schema.configuration.TableChange;
import org.apache.ignite.internal.schema.configuration.ValueSerializationHelper;
import org.apache.ignite.internal.schema.configuration.defaultvalue.ConstantValueDefaultChange;
import org.apache.ignite.internal.schema.configuration.defaultvalue.FunctionCallDefaultChange;
import org.apache.ignite.internal.schema.configuration.defaultvalue.NullValueDefaultChange;
import org.apache.ignite.internal.schema.configuration.index.HashIndexChange;
import org.apache.ignite.internal.schema.configuration.index.SortedIndexChange;
import org.apache.ignite.internal.schema.configuration.index.TableIndexChange;
import org.apache.ignite.internal.sql.engine.prepare.ddl.AbstractTableDdlCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.AlterTableAddCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.AlterTableDropCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.ColumnDefinition;
import org.apache.ignite.internal.sql.engine.prepare.ddl.CreateIndexCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.CreateTableCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DdlCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DefaultValueDefinition;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DropIndexCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DropTableCommand;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.lang.ColumnAlreadyExistsException;
import org.apache.ignite.lang.ColumnNotFoundException;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.TableAlreadyExistsException;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.sql.SqlException;

public class DdlCommandHandler {
    private final TableManager tableManager;
    private final IndexManager indexManager;
    private final DataStorageManager dataStorageManager;

    public DdlCommandHandler(TableManager tableManager, IndexManager indexManager, DataStorageManager dataStorageManager) {
        this.tableManager = tableManager;
        this.indexManager = indexManager;
        this.dataStorageManager = dataStorageManager;
    }

    public CompletableFuture<Boolean> handle(DdlCommand cmd) {
        this.validateCommand(cmd);
        if (cmd instanceof CreateTableCommand) {
            return this.handleCreateTable((CreateTableCommand)cmd);
        }
        if (cmd instanceof DropTableCommand) {
            return this.handleDropTable((DropTableCommand)cmd);
        }
        if (cmd instanceof AlterTableAddCommand) {
            return this.handleAlterAddColumn((AlterTableAddCommand)cmd);
        }
        if (cmd instanceof AlterTableDropCommand) {
            return this.handleAlterDropColumn((AlterTableDropCommand)cmd);
        }
        if (cmd instanceof CreateIndexCommand) {
            return this.handleCreateIndex((CreateIndexCommand)cmd);
        }
        if (cmd instanceof DropIndexCommand) {
            return this.handleDropIndex((DropIndexCommand)cmd);
        }
        return CompletableFuture.failedFuture((Throwable)new IgniteInternalCheckedException(ErrorGroups.Sql.UNSUPPORTED_DDL_OPERATION_ERR, "Unsupported DDL operation [cmdName=" + (cmd == null ? null : cmd.getClass().getSimpleName()) + "; cmd=\"" + cmd + "\"]"));
    }

    private void validateCommand(DdlCommand cmd) {
        AbstractTableDdlCommand cmd0;
        if (cmd instanceof AbstractTableDdlCommand && StringUtils.nullOrEmpty((String)(cmd0 = (AbstractTableDdlCommand)cmd).tableName())) {
            throw new IllegalArgumentException("Table name is undefined.");
        }
    }

    private CompletableFuture<Boolean> handleCreateTable(CreateTableCommand cmd) {
        Consumer<TableChange> tblChanger = tableChange -> {
            tableChange.changeColumns(columnsChange -> {
                for (ColumnDefinition col : cmd.columns()) {
                    columnsChange.create(col.name(), columnChange -> this.convertColumnDefinition(col, (ColumnChange)columnChange));
                }
            });
            List<String> colocationKeys = cmd.colocationColumns();
            if (CollectionUtils.nullOrEmpty(colocationKeys)) {
                colocationKeys = cmd.primaryKeyColumns();
            }
            List<String> colocationKeys0 = colocationKeys;
            tableChange.changePrimaryKey(pkChange -> pkChange.changeColumns((String[])cmd.primaryKeyColumns().toArray(String[]::new)).changeColocationColumns((String[])colocationKeys0.toArray(String[]::new)));
            tableChange.changeDataStorage(this.dataStorageManager.tableDataStorageConsumer(cmd.dataStorage(), cmd.dataStorageOptions()));
            if (cmd.partitions() != null) {
                tableChange.changePartitions(cmd.partitions().intValue());
            }
            if (cmd.replicas() != null) {
                tableChange.changeReplicas(cmd.replicas().intValue());
            }
        };
        return ((CompletableFuture)this.tableManager.createTableAsync(cmd.tableName(), tblChanger).thenApply(Objects::nonNull)).handle(DdlCommandHandler.handleTableModificationResult(cmd.ifTableExists()));
    }

    private CompletableFuture<Boolean> handleDropTable(DropTableCommand cmd) {
        return ((CompletableFuture)this.tableManager.dropTableAsync(cmd.tableName()).thenApply(v -> Boolean.TRUE)).handle(DdlCommandHandler.handleTableModificationResult(cmd.ifTableExists()));
    }

    private CompletableFuture<Boolean> handleAlterAddColumn(AlterTableAddCommand cmd) {
        if (CollectionUtils.nullOrEmpty(cmd.columns())) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        return this.addColumnInternal(cmd.tableName(), cmd.columns(), cmd.ifColumnNotExists()).handle(DdlCommandHandler.handleTableModificationResult(cmd.ifTableExists()));
    }

    private CompletableFuture<Boolean> handleAlterDropColumn(AlterTableDropCommand cmd) {
        if (CollectionUtils.nullOrEmpty(cmd.columns())) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        return this.dropColumnInternal(cmd.tableName(), cmd.columns(), cmd.ifColumnExists()).handle(DdlCommandHandler.handleTableModificationResult(cmd.ifTableExists()));
    }

    private static BiFunction<Object, Throwable, Boolean> handleTableModificationResult(boolean ignoreTableExistenceErrors) {
        return (val, err) -> {
            if (err == null) {
                return val instanceof Boolean ? (Boolean)val : Boolean.TRUE;
            }
            if (ignoreTableExistenceErrors) {
                Throwable err0;
                Throwable throwable = err0 = err instanceof CompletionException ? err.getCause() : err;
                if (err0 instanceof TableAlreadyExistsException || err0 instanceof TableNotFoundException) {
                    return Boolean.FALSE;
                }
            }
            throw err instanceof RuntimeException ? (RuntimeException)err : new CompletionException((Throwable)err);
        };
    }

    private CompletableFuture<Boolean> handleCreateIndex(CreateIndexCommand cmd) {
        Consumer<TableIndexChange> indexChanger = tableIndexChange -> {
            switch (cmd.type()) {
                case SORTED: {
                    this.createSortedIndexInternal(cmd, (SortedIndexChange)tableIndexChange.convert(SortedIndexChange.class));
                    break;
                }
                case HASH: {
                    this.createHashIndexInternal(cmd, (HashIndexChange)tableIndexChange.convert(HashIndexChange.class));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown index type [type=" + cmd.type() + "]"));
                }
            }
        };
        return this.indexManager.createIndexAsync(cmd.schemaName(), cmd.indexName(), cmd.tableName(), !cmd.ifNotExists(), indexChanger);
    }

    private CompletableFuture<Boolean> handleDropIndex(DropIndexCommand cmd) {
        return this.indexManager.dropIndexAsync(cmd.schemaName(), cmd.indexName(), !cmd.ifNotExists());
    }

    private void createSortedIndexInternal(CreateIndexCommand cmd, SortedIndexChange indexChange) {
        indexChange.changeColumns(colsInit -> {
            for (int i = 0; i < cmd.columns().size(); ++i) {
                String columnName = cmd.columns().get(i);
                IgniteIndex.Collation collation = cmd.collations().get(i);
                colsInit.create(columnName, colInit -> colInit.changeAsc(collation.asc));
            }
        });
    }

    private void createHashIndexInternal(CreateIndexCommand cmd, HashIndexChange indexChange) {
        indexChange.changeColumnNames(cmd.columns().toArray(ArrayUtils.STRING_EMPTY_ARRAY));
    }

    private CompletableFuture<Boolean> addColumnInternal(String fullName, List<ColumnDefinition> colsDef, boolean ignoreColumnExistance) {
        AtomicBoolean ret = new AtomicBoolean(true);
        return this.tableManager.alterTableAsync(fullName, chng -> chng.changeColumns(cols -> {
            List colsDef0;
            ret.set(true);
            Map<String, String> colNamesToOrders = DdlCommandHandler.columnOrdersToNames((NamedListView<? extends ColumnView>)chng.columns());
            if (ignoreColumnExistance) {
                colsDef0 = colsDef.stream().filter(k -> {
                    if (colNamesToOrders.containsKey(k.name())) {
                        ret.set(false);
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
            } else {
                colsDef.stream().filter(k -> colNamesToOrders.containsKey(k.name())).findAny().ifPresent(c -> {
                    throw new ColumnAlreadyExistsException(c.name());
                });
                colsDef0 = colsDef;
            }
            for (ColumnDefinition col : colsDef0) {
                cols.create(col.name(), colChg -> this.convertColumnDefinition(col, (ColumnChange)colChg));
            }
        })).thenApply(v -> ret.get());
    }

    private void convertColumnDefinition(ColumnDefinition definition, ColumnChange columnChange) {
        NativeType columnType = IgniteTypeFactory.relDataTypeToNative(definition.type());
        columnChange.changeType(columnTypeChange -> DdlCommandHandler.convert(columnType, columnTypeChange));
        columnChange.changeNullable(definition.nullable());
        columnChange.changeDefaultValueProvider(defaultChange -> {
            switch (((DefaultValueDefinition)definition.defaultValueDefinition()).type()) {
                case CONSTANT: {
                    DefaultValueDefinition.ConstantValue constantValue = (DefaultValueDefinition.ConstantValue)definition.defaultValueDefinition();
                    Object val = constantValue.value();
                    if (val != null) {
                        ((ConstantValueDefaultChange)defaultChange.convert(ConstantValueDefaultChange.class)).changeDefaultValue(ValueSerializationHelper.toString((Object)val, (NativeType)columnType));
                        break;
                    }
                    defaultChange.convert(NullValueDefaultChange.class);
                    break;
                }
                case FUNCTION_CALL: {
                    DefaultValueDefinition.FunctionCall functionCall = (DefaultValueDefinition.FunctionCall)definition.defaultValueDefinition();
                    ((FunctionCallDefaultChange)defaultChange.convert(FunctionCallDefaultChange.class)).changeFunctionName(functionCall.functionName());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown default value definition type [type=" + ((DefaultValueDefinition)definition.defaultValueDefinition()).type() + "]");
                }
            }
        });
    }

    private CompletableFuture<Boolean> dropColumnInternal(String tableName, Set<String> colNames, boolean ignoreColumnExistence) {
        AtomicBoolean ret = new AtomicBoolean(true);
        return this.tableManager.alterTableAsync(tableName, chng -> chng.changeColumns(cols -> {
            ret.set(true);
            PrimaryKeyView priKey = chng.primaryKey();
            Map<String, String> colNamesToOrders = DdlCommandHandler.columnOrdersToNames((NamedListView<? extends ColumnView>)chng.columns());
            HashSet<String> colNames0 = new HashSet<String>();
            Set<String> primaryCols = Set.of(priKey.columns());
            for (String colName : colNames) {
                if (!colNamesToOrders.containsKey(colName)) {
                    ret.set(false);
                    if (!ignoreColumnExistence) {
                        throw new ColumnNotFoundException("PUBLIC", tableName, colName);
                    }
                } else {
                    colNames0.add(colName);
                }
                if (!primaryCols.contains(colName)) continue;
                throw new SqlException(ErrorGroups.Sql.DEL_PK_COMUMN_CONSTRAINT_ERR, IgniteStringFormatter.format((String)"Can`t delete column, belongs to primary key: [name={}]", (Object[])new Object[]{colName}));
            }
            colNames0.forEach(k -> cols.delete((String)colNamesToOrders.get(k)));
        })).thenApply(v -> ret.get());
    }

    private static void convert(NativeType colType, ColumnTypeChange colTypeChg) {
        NativeTypeSpec spec = colType.spec();
        String typeName = spec.name().toUpperCase();
        colTypeChg.changeType(typeName);
        switch (spec) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case UUID: {
                break;
            }
            case BITMASK: {
                BitmaskNativeType bitmaskColType = (BitmaskNativeType)colType;
                colTypeChg.changeLength(bitmaskColType.bits());
                break;
            }
            case BYTES: 
            case STRING: {
                VarlenNativeType varLenColType = (VarlenNativeType)colType;
                colTypeChg.changeLength(varLenColType.length());
                break;
            }
            case DECIMAL: {
                DecimalNativeType numColType = (DecimalNativeType)colType;
                colTypeChg.changePrecision(numColType.precision());
                colTypeChg.changeScale(numColType.scale());
                break;
            }
            case NUMBER: {
                NumberNativeType numType = (NumberNativeType)colType;
                colTypeChg.changePrecision(numType.precision());
                break;
            }
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                TemporalNativeType temporalColType = (TemporalNativeType)colType;
                colTypeChg.changePrecision(temporalColType.precision());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + colType.spec().name());
            }
        }
    }

    private static Map<String, String> columnOrdersToNames(NamedListView<? extends ColumnView> cols) {
        HashMap<String, String> colNames = new HashMap<String, String>(cols.size());
        for (String colOrder : cols.namedListKeys()) {
            colNames.put(((ColumnView)cols.get(colOrder)).name(), colOrder);
        }
        return colNames;
    }
}

