/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.impl;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.LogId;
import org.apache.ignite.raft.jraft.option.LogStorageOptions;
import org.apache.ignite.raft.jraft.storage.LogStorage;
import org.apache.ignite.raft.jraft.storage.VolatileStorage;
import org.apache.ignite.raft.jraft.storage.impl.LogStorageBudget;
import org.apache.ignite.raft.jraft.storage.impl.Logs;
import org.apache.ignite.raft.jraft.util.Describer;
import org.apache.ignite.raft.jraft.util.Requires;

public class VolatileLogStorage
implements LogStorage,
Describer,
VolatileStorage {
    private static final IgniteLogger LOG = Loggers.forClass(VolatileLogStorage.class);
    private final LogStorageBudget inMemoryBudget;
    private final Logs inMemoryLogs;
    private final Logs spiltOnDisk;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private volatile long firstLogIndex = -1L;
    private volatile long lastLogIndex = -1L;
    private volatile long lastSpiltLogIndex = -1L;
    private volatile boolean initialized = false;

    public VolatileLogStorage(LogStorageBudget inMemoryBudget, Logs inMemoryLogs, Logs spiltOnDisk) {
        this.inMemoryBudget = inMemoryBudget;
        this.inMemoryLogs = inMemoryLogs;
        this.spiltOnDisk = spiltOnDisk;
    }

    @Override
    public boolean init(LogStorageOptions opts) {
        Requires.requireNonNull(opts.getLogEntryCodecFactory(), "Null log entry codec factory");
        this.writeLock.lock();
        try {
            if (this.initialized) {
                LOG.warn("VolatileLogStorage init() was already called.", new Object[0]);
                boolean bl = true;
                return bl;
            }
            this.inMemoryLogs.init(opts);
            this.spiltOnDisk.init(opts);
            this.initialized = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.writeLock.lock();
        try {
            this.initialized = false;
            this.inMemoryLogs.shutdown();
            this.spiltOnDisk.shutdown();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getFirstLogIndex() {
        this.readLock.lock();
        try {
            long l = this.hasAnyEntries() ? this.firstLogIndex : 1L;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean hasAnyEntries() {
        return this.firstLogIndex != -1L;
    }

    @Override
    public long getLastLogIndex() {
        this.readLock.lock();
        try {
            long l = this.hasAnyEntries() ? this.lastLogIndex : 0L;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry getEntry(long index) {
        this.readLock.lock();
        try {
            if (!this.hasAnyEntries() || index < this.firstLogIndex) {
                LogEntry logEntry = null;
                return logEntry;
            }
            if (this.isSomethingSpilt() && index <= this.lastSpiltLogIndex) {
                LogEntry logEntry = this.spiltOnDisk.getEntry(index);
                return logEntry;
            }
            LogEntry logEntry = this.inMemoryLogs.getEntry(index);
            return logEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getTerm(long index) {
        LogEntry entry = this.getEntry(index);
        if (entry != null) {
            return entry.getId().getTerm();
        }
        return 0L;
    }

    @Override
    public boolean appendEntry(LogEntry entry) {
        this.readLock.lock();
        try {
            if (!this.initialized) {
                LOG.warn("DB not initialized or destroyed.", new Object[0]);
                boolean bl = false;
                return bl;
            }
            this.appendEntryInternal(entry);
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void appendEntryInternal(LogEntry entry) {
        boolean hadAnyEntries = this.hasAnyEntries();
        this.spillToDiskUntilEnoughInMemorySpaceIsAvailable(entry);
        long entryIndex = entry.getId().getIndex();
        if (!this.inMemoryBudget.hasRoomFor(entry)) {
            this.spiltOnDisk.appendEntry(entry);
            this.lastSpiltLogIndex = entryIndex;
        } else {
            this.inMemoryLogs.appendEntry(entry);
        }
        this.lastLogIndex = entryIndex;
        if (!hadAnyEntries) {
            this.firstLogIndex = entryIndex;
        }
        this.inMemoryBudget.onAppended(entry);
    }

    private void spillToDiskUntilEnoughInMemorySpaceIsAvailable(LogEntry entry) {
        while (!this.inMemoryBudget.hasRoomFor(entry)) {
            long indexToSpill;
            long l = indexToSpill = this.isSomethingSpilt() ? this.lastSpiltLogIndex + 1L : this.getFirstLogIndex();
            assert (indexToSpill >= this.getFirstLogIndex()) : indexToSpill + " must be after " + this.getFirstLogIndex();
            if (indexToSpill > this.lastLogIndex) break;
            LogEntry entryToSpill = this.inMemoryLogs.getEntry(indexToSpill);
            assert (entryToSpill != null);
            this.spiltOnDisk.appendEntry(entryToSpill);
            this.inMemoryLogs.truncatePrefix(indexToSpill + 1L);
            this.inMemoryBudget.onTruncatedPrefix(indexToSpill + 1L);
            this.lastSpiltLogIndex = indexToSpill;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int appendEntries(List<LogEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return 0;
        }
        int entriesCount = entries.size();
        this.readLock.lock();
        try {
            if (!this.initialized) {
                LOG.warn("DB not initialized or destroyed.", new Object[0]);
                int n = 0;
                return n;
            }
            for (LogEntry entry : entries) {
                this.appendEntryInternal(entry);
            }
            int n = entriesCount;
            return n;
        }
        catch (Exception e) {
            LOG.error("Fail to append entry.", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncatePrefix(long firstIndexKept) {
        this.readLock.lock();
        try {
            if (!this.hasAnyEntries() || firstIndexKept <= this.firstLogIndex) {
                boolean bl = true;
                return bl;
            }
            if (this.isSomethingSpilt()) {
                this.spiltOnDisk.truncatePrefix(Math.min(firstIndexKept, this.lastSpiltLogIndex + 1L));
            }
            this.inMemoryLogs.truncatePrefix(firstIndexKept);
            boolean stillNotEmpty = firstIndexKept <= this.lastLogIndex;
            this.firstLogIndex = stillNotEmpty ? firstIndexKept : -1L;
            long l = this.lastLogIndex = stillNotEmpty ? this.lastLogIndex : -1L;
            if (this.isSomethingSpilt() && stillNotEmpty) {
                if (this.lastSpiltLogIndex < firstIndexKept) {
                    this.lastSpiltLogIndex = -1L;
                }
            } else {
                this.lastSpiltLogIndex = -1L;
            }
            this.inMemoryBudget.onTruncatedPrefix(firstIndexKept);
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isSomethingSpilt() {
        return this.lastSpiltLogIndex > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncateSuffix(long lastIndexKept) {
        this.readLock.lock();
        try {
            if (!this.hasAnyEntries() || lastIndexKept >= this.lastLogIndex) {
                boolean bl = true;
                return bl;
            }
            if (this.isSomethingSpilt() && lastIndexKept < this.lastSpiltLogIndex) {
                this.spiltOnDisk.truncateSuffix(lastIndexKept);
                this.lastSpiltLogIndex = lastIndexKept < this.firstLogIndex ? -1L : lastIndexKept;
            }
            this.inMemoryLogs.truncateSuffix(lastIndexKept);
            boolean stillNotEmpty = lastIndexKept >= this.firstLogIndex;
            this.firstLogIndex = stillNotEmpty ? this.firstLogIndex : -1L;
            this.lastLogIndex = stillNotEmpty ? lastIndexKept : -1L;
            this.inMemoryBudget.onTruncatedSuffix(lastIndexKept);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Fail to truncateSuffix {}.", (Throwable)e, new Object[]{lastIndexKept});
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(long nextLogIndex) {
        if (nextLogIndex <= 0L) {
            throw new IllegalArgumentException("Invalid next log index.");
        }
        this.writeLock.lock();
        try {
            LogEntry entry = this.getEntry(nextLogIndex);
            this.inMemoryLogs.reset();
            this.spiltOnDisk.reset();
            this.firstLogIndex = -1L;
            this.lastLogIndex = -1L;
            if (entry == null) {
                entry = new LogEntry();
                entry.setType(EnumOutter.EntryType.ENTRY_TYPE_NO_OP);
                entry.setId(new LogId(nextLogIndex, 0L));
                LOG.warn("Entry not found for nextLogIndex {} when reset.", new Object[]{nextLogIndex});
            }
            this.inMemoryBudget.onReset();
            boolean bl = this.appendEntry(entry);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void describe(Describer.Printer out) {
        this.readLock.lock();
        try {
            out.println("firstLogIndex=" + this.firstLogIndex);
            out.println("lastLogIndex=" + this.lastLogIndex);
        }
        catch (Exception e) {
            out.println(e);
        }
        finally {
            this.readLock.unlock();
        }
    }
}

