/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.beans;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.beans.BeanConstructorElement;
import io.micronaut.inject.ast.beans.BeanFieldElement;
import io.micronaut.inject.ast.beans.BeanMethodElement;
import io.micronaut.inject.ast.beans.BeanParameterElement;
import io.micronaut.inject.ast.beans.ConfigurableElement;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface BeanElementBuilder
extends ConfigurableElement {
    @NonNull
    default public BeanElementBuilder intercept(AnnotationValue<?> ... annotationValue) {
        if (annotationValue != null) {
            for (AnnotationValue<?> value : annotationValue) {
                this.annotate(value);
            }
        }
        return this;
    }

    @NonNull
    public Element getOriginatingElement();

    @NonNull
    public ClassElement getBeanType();

    @NonNull
    default public Element getProducingElement() {
        return this.getBeanType();
    }

    @NonNull
    default public ClassElement getDeclaringElement() {
        return this.getBeanType();
    }

    @NonNull
    public BeanElementBuilder createWith(@NonNull MethodElement var1);

    @NonNull
    public BeanElementBuilder typed(ClassElement ... var1);

    @Override
    @NonNull
    public BeanElementBuilder typeArguments(ClassElement ... var1);

    @NonNull
    public BeanElementBuilder typeArgumentsForType(@Nullable ClassElement var1, ClassElement ... var2);

    @NonNull
    default public BeanElementBuilder scope(@NonNull AnnotationValue<?> scope) {
        Objects.requireNonNull(scope, "Scope cannot be null");
        this.annotate(scope.getAnnotationName(), builder -> builder.members(scope.getValues()));
        return this;
    }

    @NonNull
    default public BeanElementBuilder scope(@NonNull String scope) {
        Objects.requireNonNull(scope, "Scope cannot be null");
        this.annotate(scope);
        return this;
    }

    @NonNull
    public BeanElementBuilder withConstructor(@NonNull Consumer<BeanConstructorElement> var1);

    @NonNull
    public BeanElementBuilder withMethods(@NonNull ElementQuery<MethodElement> var1, @NonNull Consumer<BeanMethodElement> var2);

    @NonNull
    public BeanElementBuilder withFields(@NonNull ElementQuery<FieldElement> var1, @NonNull Consumer<BeanFieldElement> var2);

    @NonNull
    public BeanElementBuilder withParameters(Consumer<BeanParameterElement[]> var1);

    @Override
    @NonNull
    default public BeanElementBuilder qualifier(@Nullable String qualifier) {
        return (BeanElementBuilder)ConfigurableElement.super.qualifier(qualifier);
    }

    @Override
    @NonNull
    default public BeanElementBuilder qualifier(@NonNull AnnotationValue<?> qualifier) {
        return (BeanElementBuilder)ConfigurableElement.super.qualifier(qualifier);
    }

    @Override
    @NonNull
    default public <T extends Annotation> BeanElementBuilder annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        return (BeanElementBuilder)ConfigurableElement.super.annotate(annotationType, consumer);
    }

    @Override
    default public BeanElementBuilder removeAnnotation(@NonNull String annotationType) {
        return (BeanElementBuilder)ConfigurableElement.super.removeAnnotation(annotationType);
    }

    @Override
    default public <T extends Annotation> BeanElementBuilder removeAnnotation(@NonNull Class<T> annotationType) {
        return (BeanElementBuilder)ConfigurableElement.super.removeAnnotation(annotationType);
    }

    @Override
    default public <T extends Annotation> BeanElementBuilder removeAnnotationIf(@NonNull Predicate<AnnotationValue<T>> predicate) {
        return (BeanElementBuilder)ConfigurableElement.super.removeAnnotationIf(predicate);
    }

    @Override
    default public BeanElementBuilder removeStereotype(@NonNull String annotationType) {
        return (BeanElementBuilder)ConfigurableElement.super.removeStereotype(annotationType);
    }

    @Override
    default public <T extends Annotation> BeanElementBuilder removeStereotype(@NonNull Class<T> annotationType) {
        return (BeanElementBuilder)ConfigurableElement.super.removeStereotype(annotationType);
    }

    @Override
    @NonNull
    default public BeanElementBuilder annotate(@NonNull String annotationType) {
        return (BeanElementBuilder)ConfigurableElement.super.annotate(annotationType);
    }

    @Override
    @NonNull
    default public <T extends Annotation> BeanElementBuilder annotate(@NonNull Class<T> annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        return (BeanElementBuilder)ConfigurableElement.super.annotate(annotationType, consumer);
    }

    @Override
    @NonNull
    default public <T extends Annotation> BeanElementBuilder annotate(@NonNull Class<T> annotationType) {
        return (BeanElementBuilder)ConfigurableElement.super.annotate(annotationType);
    }

    public BeanElementBuilder inject();

    public <E extends MemberElement> BeanElementBuilder produceBeans(ElementQuery<E> var1, @Nullable Consumer<BeanElementBuilder> var2);

    default public <E extends MemberElement> BeanElementBuilder produceBeans(ElementQuery<E> methodsOrFields) {
        return this.produceBeans(methodsOrFields, null);
    }
}

