/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.client.RetryLimitPolicy;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.AbstractClientView;
import org.apache.ignite.internal.client.table.ClientDataStreamer;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.TupleStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.ReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class ClientRecordBinaryView
extends AbstractClientView<Tuple>
implements RecordView<Tuple> {
    private final ClientTupleSerializer ser;

    ClientRecordBinaryView(ClientTable tbl, ClientSql sql) {
        super(tbl, sql);
        this.ser = new ClientTupleSerializer(tbl.tableId());
    }

    public Tuple get(@Nullable Transaction tx, Tuple keyRec) {
        return (Tuple)ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(12, (s, w) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, true), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, keyRec), tx);
    }

    public List<Tuple> getAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return (List)ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    public CompletableFuture<List<Tuple>> getAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, (String)"keyRecs", (String)"key");
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(15, (s, w) -> this.ser.writeTuples(tx, keyRecs, (ClientSchema)s, (PayloadOutputChannel)w, true), (s, r) -> ClientTupleSerializer.readTuplesNullable(s, r.in()), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, keyRecs.iterator().next()), tx);
    }

    public boolean contains(@Nullable Transaction tx, Tuple key) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(33, (s, w) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, true), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, key), tx);
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.tbl.doSchemaOutOpAsync(67, (s, w) -> this.ser.writeTuples(tx, keys, (ClientSchema)s, (PayloadOutputChannel)w, true), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, keys.iterator().next()), tx);
    }

    public void upsert(@Nullable Transaction tx, Tuple rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(10, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    public void upsertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        if (recs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.tbl.doSchemaOutOpAsync(13, (s, w) -> this.ser.writeTuples(tx, recs, (ClientSchema)s, (PayloadOutputChannel)w, false), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, recs.iterator().next()), tx);
    }

    public Tuple getAndUpsert(@Nullable Transaction tx, Tuple rec) {
        return (Tuple)ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    public CompletableFuture<Tuple> getAndUpsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(16, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, false), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    public boolean insert(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.insertAsync(tx, rec));
    }

    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(18, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, false), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    public List<Tuple> insertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        return (List)ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    public CompletableFuture<List<Tuple>> insertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(20, (s, w) -> this.ser.writeTuples(tx, recs, (ClientSchema)s, (PayloadOutputChannel)w, false), (s, r) -> ClientTupleSerializer.readTuples(s, r.in()), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, recs.iterator().next()), tx);
    }

    public boolean replace(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(22, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, false), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.tbl.doSchemaOutOpAsync(24, (s, w) -> {
            this.ser.writeTuple(tx, oldRec, (ClientSchema)s, (PayloadOutputChannel)w, false, false);
            this.ser.writeTuple(tx, newRec, (ClientSchema)s, (PayloadOutputChannel)w, false, true);
        }, r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, oldRec), tx);
    }

    public Tuple getAndReplace(@Nullable Transaction tx, Tuple rec) {
        return (Tuple)ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(26, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, false), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    public boolean delete(@Nullable Transaction tx, Tuple keyRec) {
        return (Boolean)ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutOpAsync(28, (s, w) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, true), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, keyRec), tx);
    }

    public boolean deleteExact(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(30, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, false), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    public Tuple getAndDelete(@Nullable Transaction tx, Tuple keyRec) {
        return (Tuple)ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    public CompletableFuture<Tuple> getAndDeleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(32, (s, w) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, true), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, keyRec), tx);
    }

    public List<Tuple> deleteAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return (List)ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    public CompletableFuture<List<Tuple>> deleteAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(29, (s, w) -> this.ser.writeTuples(tx, keyRecs, (ClientSchema)s, (PayloadOutputChannel)w, true), (s, r) -> ClientTupleSerializer.readTuples(s, r.in(), true), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, keyRecs.iterator().next()), tx);
    }

    public List<Tuple> deleteAllExact(@Nullable Transaction tx, Collection<Tuple> recs) {
        return (List)ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    public CompletableFuture<List<Tuple>> deleteAllExactAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(31, (s, w) -> this.ser.writeTuples(tx, recs, (ClientSchema)s, (PayloadOutputChannel)w, false), (s, r) -> ClientTupleSerializer.readTuples(s, r.in()), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, recs.iterator().next()), tx);
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Tuple>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        TupleStreamerPartitionAwarenessProvider provider = new TupleStreamerPartitionAwarenessProvider(this.tbl);
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partitionId, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (s, w) -> this.ser.writeStreamerTuples((int)partitionId, items, deleted, (ClientSchema)s, (PayloadOutputChannel)w), r -> null, PartitionAwarenessProvider.of(partitionId), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    public <E, V, R, A> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, Tuple> keyFunc, Function<E, V> payloadFunc, ReceiverDescriptor<A> receiver, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options, A receiverArg) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new TupleStreamerPartitionAwarenessProvider(this.tbl), this.tbl, resultSubscriber, receiver.units(), receiver.receiverClassName(), receiverArg, receiver.argumentMarshaller());
    }
}

