/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.event.AbstractEventProducer;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.IgniteThrottledLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.placementdriver.message.PlacementDriverMessageGroup;
import org.apache.ignite.internal.placementdriver.message.PlacementDriverMessagesFactory;
import org.apache.ignite.internal.placementdriver.message.PlacementDriverReplicaMessage;
import org.apache.ignite.internal.placementdriver.message.StopLeaseProlongationMessageResponse;
import org.apache.ignite.internal.raft.Loza;
import org.apache.ignite.internal.raft.Marshaller;
import org.apache.ignite.internal.raft.Peer;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.RaftGroupEventsListener;
import org.apache.ignite.internal.raft.RaftGroupOptionsConfigurer;
import org.apache.ignite.internal.raft.RaftManager;
import org.apache.ignite.internal.raft.RaftNodeId;
import org.apache.ignite.internal.raft.RaftServiceFactory;
import org.apache.ignite.internal.raft.client.TopologyAwareRaftGroupService;
import org.apache.ignite.internal.raft.client.TopologyAwareRaftGroupServiceFactory;
import org.apache.ignite.internal.raft.configuration.LogStorageBudgetView;
import org.apache.ignite.internal.raft.server.RaftGroupOptions;
import org.apache.ignite.internal.raft.service.RaftGroupListener;
import org.apache.ignite.internal.raft.service.RaftGroupService;
import org.apache.ignite.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.LogStorageFactoryCreator;
import org.apache.ignite.internal.raft.storage.impl.VolatileRaftMetaStorage;
import org.apache.ignite.internal.replicator.LocalReplicaEvent;
import org.apache.ignite.internal.replicator.LocalReplicaEventParameters;
import org.apache.ignite.internal.replicator.Replica;
import org.apache.ignite.internal.replicator.ReplicaImpl;
import org.apache.ignite.internal.replicator.ReplicaResult;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionReplicaImpl;
import org.apache.ignite.internal.replicator.exception.ExpectedReplicationException;
import org.apache.ignite.internal.replicator.exception.ReplicaStoppingException;
import org.apache.ignite.internal.replicator.exception.ReplicaUnavailableException;
import org.apache.ignite.internal.replicator.listener.ReplicaListener;
import org.apache.ignite.internal.replicator.message.AwaitReplicaRequest;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReadOnlyDirectReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicaMessageGroup;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicaSafeTimeSyncRequest;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.TimestampAware;
import org.apache.ignite.internal.thread.ExecutorChooser;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteStripedReadWriteLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public class ReplicaManager
extends AbstractEventProducer<LocalReplicaEvent, LocalReplicaEventParameters>
implements IgniteComponent {
    private static final long STOP_LEASE_PROLONGATION_RETRIES_TIMEOUT_MS = 60000L;
    private static final IgniteLogger LOG = Loggers.forClass(ReplicaManager.class);
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private static final PlacementDriverMessagesFactory PLACEMENT_DRIVER_MESSAGES_FACTORY = new PlacementDriverMessagesFactory();
    private final IgniteThrottledLogger throttledLog;
    private final IgniteStripedReadWriteLock busyLock = new IgniteStripedReadWriteLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final CompletableFuture<Set<String>> msNodes = new CompletableFuture();
    private final ClusterService clusterNetSvc;
    private final ClusterManagementGroupManager cmgMgr;
    private final NetworkMessageHandler handler;
    private final RaftManager raftManager;
    private final TopologyAwareRaftGroupServiceFactory raftGroupServiceFactory;
    private final LogStorageFactoryCreator volatileLogStorageFactoryCreator;
    private final Marshaller raftCommandsMarshaller;
    private final NetworkMessageHandler placementDriverMessageHandler;
    private final PlacementDriver placementDriver;
    private final LongSupplier idleSafeTimePropagationPeriodMsSupplier;
    private final ConcurrentHashMap<ReplicationGroupId, CompletableFuture<Replica>> replicas = new ConcurrentHashMap();
    private final ClockService clockService;
    private final ScheduledExecutorService scheduledIdleSafeTimeSyncExecutor;
    private final Executor requestsExecutor;
    private final FailureManager failureManager;
    private final Set<Class<?>> messageGroupsToHandle;
    private final RaftGroupOptionsConfigurer partitionRaftConfigurer;
    private final ExecutorService executor;
    private final ReplicaStateManager replicaStateManager;
    private final ExecutorService replicasCreationExecutor;
    private volatile UUID localNodeId;
    private volatile String localNodeConsistentId;
    private Function<ReplicaRequest, ReplicationGroupId> groupIdConverter = r -> r.groupId().asReplicationGroupId();
    @Nullable
    private volatile HybridTimestamp lastIdleSafeTimeProposal;
    private final Function<ReplicationGroupId, CompletableFuture<byte[]>> getPendingAssignmentsSupplier;

    @TestOnly
    public ReplicaManager(String nodeName, ClusterService clusterNetSvc, ClusterManagementGroupManager cmgMgr, ClockService clockService, Set<Class<?>> messageGroupsToHandle, PlacementDriver placementDriver, Executor requestsExecutor, LongSupplier idleSafeTimePropagationPeriodMsSupplier, FailureManager failureManager, Marshaller raftCommandsMarshaller, TopologyAwareRaftGroupServiceFactory raftGroupServiceFactory, RaftManager raftManager, RaftGroupOptionsConfigurer partitionRaftConfigurer, LogStorageFactoryCreator volatileLogStorageFactoryCreator, Executor replicaStartStopExecutor, Function<ReplicaRequest, ReplicationGroupId> groupIdConverter, Function<ReplicationGroupId, CompletableFuture<byte[]>> getPendingAssignmentsSupplier) {
        this(nodeName, clusterNetSvc, cmgMgr, clockService, messageGroupsToHandle, placementDriver, requestsExecutor, idleSafeTimePropagationPeriodMsSupplier, failureManager, raftCommandsMarshaller, raftGroupServiceFactory, raftManager, partitionRaftConfigurer, volatileLogStorageFactoryCreator, replicaStartStopExecutor, getPendingAssignmentsSupplier);
        this.groupIdConverter = groupIdConverter;
    }

    public ReplicaManager(String nodeName, ClusterService clusterNetSvc, ClusterManagementGroupManager cmgMgr, ClockService clockService, Set<Class<?>> messageGroupsToHandle, PlacementDriver placementDriver, Executor requestsExecutor, LongSupplier idleSafeTimePropagationPeriodMsSupplier, FailureManager failureManager, @Nullable Marshaller raftCommandsMarshaller, TopologyAwareRaftGroupServiceFactory raftGroupServiceFactory, RaftManager raftManager, RaftGroupOptionsConfigurer partitionRaftConfigurer, LogStorageFactoryCreator volatileLogStorageFactoryCreator, Executor replicaStartStopExecutor, Function<ReplicationGroupId, CompletableFuture<byte[]>> getPendingAssignmentsSupplier) {
        this.clusterNetSvc = clusterNetSvc;
        this.cmgMgr = cmgMgr;
        this.clockService = clockService;
        this.messageGroupsToHandle = messageGroupsToHandle;
        this.volatileLogStorageFactoryCreator = volatileLogStorageFactoryCreator;
        this.handler = this::onReplicaMessageReceived;
        this.placementDriverMessageHandler = this::onPlacementDriverMessageReceived;
        this.placementDriver = placementDriver;
        this.requestsExecutor = requestsExecutor;
        this.idleSafeTimePropagationPeriodMsSupplier = idleSafeTimePropagationPeriodMsSupplier;
        this.failureManager = failureManager;
        this.raftCommandsMarshaller = raftCommandsMarshaller;
        this.raftGroupServiceFactory = raftGroupServiceFactory;
        this.raftManager = raftManager;
        this.partitionRaftConfigurer = partitionRaftConfigurer;
        this.getPendingAssignmentsSupplier = getPendingAssignmentsSupplier;
        this.replicaStateManager = new ReplicaStateManager(replicaStartStopExecutor, clockService, placementDriver, this);
        this.scheduledIdleSafeTimeSyncExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"scheduled-idle-safe-time-sync-thread", (IgniteLogger)LOG));
        int threadCount = Runtime.getRuntime().availableProcessors();
        this.executor = new ThreadPoolExecutor(threadCount, threadCount, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"replica", (IgniteLogger)LOG));
        this.replicasCreationExecutor = new ThreadPoolExecutor(threadCount, threadCount, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create((String)nodeName, (String)"replica-manager", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
        this.throttledLog = Loggers.toThrottledLogger((IgniteLogger)LOG, (ExecutorService)this.executor);
    }

    private void onReplicaMessageReceived(NetworkMessage message, ClusterNode sender, @Nullable Long correlationId) {
        if (!(message instanceof ReplicaRequest)) {
            return;
        }
        assert (correlationId != null);
        ReplicaRequest request = (ReplicaRequest)message;
        if (IgniteUtils.shouldSwitchToRequestsExecutor((ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE, ThreadOperation.TX_STATE_STORAGE_ACCESS})) {
            this.requestsExecutor.execute(() -> this.handleReplicaRequest(request, sender, correlationId));
        } else {
            this.handleReplicaRequest(request, sender, correlationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReplicaRequest(ReplicaRequest request, ClusterNode sender, @Nullable Long correlationId) {
        if (!this.enterBusy()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Failed to process replica request (the node is stopping) [request={}].", new Object[]{request});
            }
            return;
        }
        ReplicationGroupId groupId = this.groupIdConverter.apply(request);
        String senderConsistentId = sender.name();
        try {
            if (request instanceof AwaitReplicaRequest) {
                this.replicas.compute(groupId, (replicationGroupId, replicaFut) -> {
                    if (replicaFut == null) {
                        replicaFut = new CompletableFuture();
                    }
                    if (!replicaFut.isDone()) {
                        replicaFut.whenComplete((createdReplica, ex) -> {
                            if (ex != null) {
                                this.clusterNetSvc.messagingService().respond(senderConsistentId, (NetworkMessage)REPLICA_MESSAGES_FACTORY.errorReplicaResponse().throwable((Throwable)ex).build(), correlationId.longValue());
                            } else {
                                this.sendAwaitReplicaResponse(senderConsistentId, correlationId);
                            }
                        });
                    } else {
                        this.sendAwaitReplicaResponse(senderConsistentId, correlationId);
                    }
                    return replicaFut;
                });
                return;
            }
            CompletableFuture<Replica> replicaFut2 = this.replicas.get(groupId);
            HybridTimestamp requestTimestamp = ReplicaManager.extractTimestamp(request);
            if (replicaFut2 == null || !replicaFut2.isDone()) {
                this.sendReplicaUnavailableErrorResponse(senderConsistentId, correlationId, groupId, requestTimestamp);
                return;
            }
            if (requestTimestamp != null) {
                this.clockService.updateClock(requestTimestamp);
            }
            boolean sendTimestamp = request instanceof TimestampAware || request instanceof ReadOnlyDirectReplicaRequest;
            Replica replica = replicaFut2.join();
            CompletableFuture<ReplicaResult> resFut = replica.processRequest(request, sender.id());
            resFut.whenComplete((res, ex) -> {
                NetworkMessage msg;
                if (ex == null) {
                    msg = this.prepareReplicaResponse(sendTimestamp, (ReplicaResult)res);
                } else {
                    if (ReplicaManager.indicatesUnexpectedProblem(ex)) {
                        this.throttledLog.warn("Failed to process replica request [request={}].", ex, new Object[]{request});
                    } else {
                        this.throttledLog.debug("Failed to process replica request [request={}].", ex, new Object[]{request});
                    }
                    msg = this.prepareReplicaErrorResponse(sendTimestamp, (Throwable)ex);
                }
                this.clusterNetSvc.messagingService().respond(senderConsistentId, msg, correlationId.longValue());
                if (request instanceof PrimaryReplicaRequest && ReplicaManager.isConnectivityRelatedException(ex)) {
                    LOG.info("The replica does not meet the requirements for the leaseholder [groupId={}].", new Object[]{groupId});
                    this.stopLeaseProlongation(groupId, null);
                }
                if (ex == null && res.applyResult().replicationFuture() != null) {
                    res.applyResult().replicationFuture().whenComplete((res0, ex0) -> {
                        NetworkMessage msg0;
                        LOG.debug("Sending delayed response for replica request [request={}]", new Object[]{request});
                        if (ex0 == null) {
                            msg0 = this.prepareReplicaResponse(sendTimestamp, new ReplicaResult(res0, null));
                        } else {
                            LOG.warn("Failed to process delayed response [request={}]", ex0, new Object[]{request});
                            msg0 = this.prepareReplicaErrorResponse(sendTimestamp, (Throwable)ex0);
                        }
                        this.clusterNetSvc.messagingService().send(senderConsistentId, ChannelType.DEFAULT, msg0);
                    });
                }
            });
        }
        finally {
            this.leaveBusy();
        }
    }

    private static boolean indicatesUnexpectedProblem(Throwable ex) {
        return !(ExceptionUtils.unwrapCause((Throwable)ex) instanceof ExpectedReplicationException);
    }

    private static boolean isConnectivityRelatedException(@Nullable Throwable ex) {
        if (ex instanceof ExecutionException || ex instanceof CompletionException) {
            ex = ex.getCause();
        }
        return ex instanceof TimeoutException || ex instanceof IOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlacementDriverMessageReceived(NetworkMessage msg0, ClusterNode sender, @Nullable Long correlationId) {
        if (!(msg0 instanceof PlacementDriverReplicaMessage)) {
            return;
        }
        String senderConsistentId = sender.name();
        assert (correlationId != null);
        PlacementDriverReplicaMessage msg = (PlacementDriverReplicaMessage)msg0;
        if (!this.enterBusy()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Failed to process placement driver message (the node is stopping) [msg={}].", new Object[]{msg});
            }
            return;
        }
        try {
            CompletableFuture replicaFut = this.replicas.computeIfAbsent(msg.groupId(), k -> new CompletableFuture());
            ((CompletableFuture)replicaFut.thenCompose(replica -> replica.processPlacementDriverMessage(msg))).whenComplete((response, ex) -> {
                if (ex == null) {
                    this.clusterNetSvc.messagingService().respond(senderConsistentId, response, correlationId.longValue());
                } else if (!(ExceptionUtils.unwrapCause((Throwable)ex) instanceof NodeStoppingException)) {
                    LOG.error("Failed to process placement driver message [msg={}].", ex, new Object[]{msg});
                }
            });
        }
        finally {
            this.leaveBusy();
        }
    }

    private CompletableFuture<HybridTimestamp> stopLeaseProlongation(ReplicationGroupId groupId, @Nullable String redirectNodeId) {
        long startTime = System.currentTimeMillis();
        return this.stopLeaseProlongation(groupId, redirectNodeId, startTime + 60000L);
    }

    private CompletableFuture<HybridTimestamp> stopLeaseProlongation(ReplicationGroupId groupId, @Nullable String redirectNodeId, long endTime) {
        long timeout = endTime - System.currentTimeMillis();
        if (timeout <= 0L) {
            return CompletableFuture.failedFuture((Throwable)new IgniteException(ErrorGroups.Common.INTERNAL_ERR, IgniteStringFormatter.format((String)"Failed to stop lease prolongation within timeout [groupId={}]", (Object[])new Object[]{groupId})));
        }
        return this.msNodes.thenCompose(nodeIds -> {
            ArrayList<CompletionStage> futs = new ArrayList<CompletionStage>();
            for (String nodeId : nodeIds) {
                ClusterNode node = this.clusterNetSvc.topologyService().getByConsistentId(nodeId);
                if (node == null) continue;
                futs.add(this.clusterNetSvc.messagingService().invoke(node, (NetworkMessage)PLACEMENT_DRIVER_MESSAGES_FACTORY.stopLeaseProlongationMessage().groupId(groupId).redirectProposal(redirectNodeId).build(), timeout).exceptionally(th -> null));
            }
            return CompletableFutures.allOf(futs).thenCompose(unused -> {
                NetworkMessage response = futs.stream().map(CompletableFuture::join).filter(resp -> resp instanceof StopLeaseProlongationMessageResponse && ((StopLeaseProlongationMessageResponse)resp).deniedLeaseExpirationTime() != null).findAny().orElse(null);
                if (response == null) {
                    return CompletableFuture.supplyAsync(() -> null, CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS)).thenComposeAsync(un -> this.stopLeaseProlongation(groupId, redirectNodeId, endTime), this.requestsExecutor);
                }
                return CompletableFuture.completedFuture(((StopLeaseProlongationMessageResponse)response).deniedLeaseExpirationTime());
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Replica> startReplica(RaftGroupEventsListener raftGroupEventsListener, RaftGroupListener raftGroupListener, boolean isVolatileStorage, @Nullable SnapshotStorageFactory snapshotStorageFactory, Function<RaftGroupService, ReplicaListener> createListener, PendingComparableValuesTracker<Long, Void> storageIndexTracker, ReplicationGroupId replicaGrpId, PeersAndLearners newConfiguration) throws NodeStoppingException {
        if (!this.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            CompletableFuture<Replica> completableFuture = this.startReplicaInternal(replicaGrpId, snapshotStorageFactory, newConfiguration, raftGroupListener, raftGroupEventsListener, isVolatileStorage, raftClient -> new ReplicaImpl(replicaGrpId, (ReplicaListener)createListener.apply((RaftGroupService)raftClient), storageIndexTracker, this.clusterNetSvc.topologyService().localMember(), this.executor, this.placementDriver, this.clockService, this.replicaStateManager::reserveReplica, this.getPendingAssignmentsSupplier, this.failureManager));
            return completableFuture;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Replica> startReplica(ReplicationGroupId replicaGrpId, Function<RaftGroupService, ReplicaListener> createListener, SnapshotStorageFactory snapshotStorageFactory, PeersAndLearners newConfiguration, RaftGroupListener raftGroupListener, RaftGroupEventsListener raftGroupEventsListener, IgniteSpinBusyLock busyLock) throws NodeStoppingException {
        if (!busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletableFuture<Replica> completableFuture = this.startReplicaInternal(replicaGrpId, snapshotStorageFactory, newConfiguration, raftGroupListener, raftGroupEventsListener, false, raftClient -> new ZonePartitionReplicaImpl(replicaGrpId, (ReplicaListener)createListener.apply((RaftGroupService)raftClient), (TopologyAwareRaftGroupService)raftClient));
            return completableFuture;
        }
        finally {
            busyLock.leaveBusy();
        }
    }

    private CompletableFuture<Replica> startReplicaInternal(ReplicationGroupId replicaGrpId, @Nullable SnapshotStorageFactory snapshotStorageFactory, PeersAndLearners newConfiguration, RaftGroupListener raftGroupListener, RaftGroupEventsListener raftGroupEventsListener, boolean isVolatileStorage, Function<TopologyAwareRaftGroupService, Replica> createReplica) throws NodeStoppingException {
        RaftNodeId raftNodeId = new RaftNodeId(replicaGrpId, new Peer(this.localNodeConsistentId));
        RaftGroupOptions groupOptions = this.groupOptionsForPartition(isVolatileStorage, snapshotStorageFactory);
        TopologyAwareRaftGroupService raftClient = (TopologyAwareRaftGroupService)((Loza)this.raftManager).startRaftGroupNode(raftNodeId, newConfiguration, raftGroupListener, raftGroupEventsListener, groupOptions, (RaftServiceFactory)this.raftGroupServiceFactory);
        LOG.info("Replica is about to start [replicationGroupId={}].", new Object[]{replicaGrpId});
        Replica newReplica = createReplica.apply(raftClient);
        CompletableFuture newReplicaFuture = this.replicas.compute(replicaGrpId, (k, existingReplicaFuture) -> {
            if (existingReplicaFuture == null || existingReplicaFuture.isDone()) {
                assert (existingReplicaFuture == null || CompletableFutures.isCompletedSuccessfully((CompletableFuture)existingReplicaFuture));
                LOG.info("Replica is started [replicationGroupId={}].", new Object[]{replicaGrpId});
                return CompletableFuture.completedFuture(newReplica);
            }
            LOG.info("Replica is started, existing replica waiter was completed [replicationGroupId={}].", new Object[]{replicaGrpId});
            existingReplicaFuture.complete(newReplica);
            return existingReplicaFuture;
        });
        LocalReplicaEventParameters eventParams = new LocalReplicaEventParameters(replicaGrpId);
        return ((CompletableFuture)this.fireEvent(LocalReplicaEvent.AFTER_REPLICA_STARTED, eventParams).exceptionally(e -> {
            LOG.error("Error when notifying about AFTER_REPLICA_STARTED event.", e);
            return null;
        })).thenCompose(v -> newReplicaFuture);
    }

    public CompletableFuture<Replica> replica(ReplicationGroupId replicationGroupId) {
        return this.replicas.get(replicationGroupId);
    }

    public void resetPeers(ReplicationGroupId replicaGrpId, PeersAndLearners peersAndLearners) {
        RaftNodeId raftNodeId = new RaftNodeId(replicaGrpId, new Peer(this.localNodeConsistentId));
        ((Loza)this.raftManager).resetPeers(raftNodeId, peersAndLearners);
    }

    private RaftGroupOptions groupOptionsForPartition(boolean isVolatileStorage, @Nullable SnapshotStorageFactory snapshotFactory) {
        RaftGroupOptions raftGroupOptions;
        if (isVolatileStorage) {
            LogStorageBudgetView view = (LogStorageBudgetView)((Loza)this.raftManager).volatileRaft().logStorageBudget().value();
            raftGroupOptions = RaftGroupOptions.forVolatileStores().setLogStorageFactory(this.volatileLogStorageFactoryCreator.factory(view)).raftMetaStorageFactory((groupId, raftOptions) -> new VolatileRaftMetaStorage());
        } else {
            raftGroupOptions = RaftGroupOptions.forPersistentStores();
        }
        raftGroupOptions.snapshotStorageFactory(snapshotFactory);
        raftGroupOptions.maxClockSkew((int)this.clockService.maxClockSkewMillis());
        raftGroupOptions.commandsMarshaller(this.raftCommandsMarshaller);
        this.partitionRaftConfigurer.configure((Object)raftGroupOptions);
        return raftGroupOptions;
    }

    public CompletableFuture<Boolean> stopReplica(ReplicationGroupId replicaGrpId) throws NodeStoppingException {
        if (!this.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            CompletableFuture<Boolean> completableFuture = this.stopReplicaInternal(replicaGrpId);
            return completableFuture;
        }
        finally {
            this.leaveBusy();
        }
    }

    private CompletableFuture<Boolean> stopReplicaInternal(ReplicationGroupId replicaGrpId) {
        CompletableFuture isRemovedFuture = new CompletableFuture();
        LocalReplicaEventParameters eventParams = new LocalReplicaEventParameters(replicaGrpId);
        this.fireEvent(LocalReplicaEvent.BEFORE_REPLICA_STOPPED, eventParams).whenComplete((v, e) -> {
            if (e != null) {
                LOG.error("Error when notifying about BEFORE_REPLICA_STOPPED event.", e);
            }
            if (!this.enterBusy()) {
                isRemovedFuture.completeExceptionally(new NodeStoppingException());
                return;
            }
            try {
                this.replicas.compute(replicaGrpId, (grpId, replicaFuture) -> {
                    if (replicaFuture == null) {
                        isRemovedFuture.complete(false);
                    } else if (!replicaFuture.isDone()) {
                        ClusterNode localMember = this.clusterNetSvc.topologyService().localMember();
                        replicaFuture.completeExceptionally((Throwable)((Object)new ReplicaStoppingException((ReplicationGroupId)grpId, localMember)));
                        isRemovedFuture.complete(true);
                    } else if (!CompletableFutures.isCompletedSuccessfully((CompletableFuture)replicaFuture)) {
                        isRemovedFuture.complete(true);
                    } else {
                        ((CompletableFuture)replicaFuture.thenCompose(Replica::shutdown)).whenComplete((notUsed, throwable) -> {
                            if (throwable != null) {
                                LOG.error("Failed to stop replica [replicaGrpId={}].", throwable, new Object[]{grpId});
                            }
                            isRemovedFuture.complete(throwable == null);
                        });
                    }
                    return null;
                });
            }
            finally {
                this.leaveBusy();
            }
        });
        return isRemovedFuture.thenApplyAsync(v -> {
            try {
                this.raftManager.stopRaftNodes(replicaGrpId);
            }
            catch (NodeStoppingException nodeStoppingException) {
                // empty catch block
            }
            return v;
        }, this.replicaStateManager.replicaStartStopPool);
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        ExecutorChooser replicaMessagesExecutorChooser = message -> this.requestsExecutor;
        this.clusterNetSvc.messagingService().addMessageHandler(ReplicaMessageGroup.class, replicaMessagesExecutorChooser, this.handler);
        this.clusterNetSvc.messagingService().addMessageHandler(PlacementDriverMessageGroup.class, this.placementDriverMessageHandler);
        this.messageGroupsToHandle.forEach(mg -> this.clusterNetSvc.messagingService().addMessageHandler(mg, replicaMessagesExecutorChooser, this.handler));
        this.scheduledIdleSafeTimeSyncExecutor.scheduleAtFixedRate(this::idleSafeTimeSync, 0L, this.idleSafeTimePropagationPeriodMsSupplier.getAsLong(), TimeUnit.MILLISECONDS);
        this.cmgMgr.metaStorageNodes().whenComplete((nodes, e) -> {
            if (e != null) {
                this.msNodes.completeExceptionally((Throwable)e);
            } else {
                this.msNodes.complete((Set<String>)nodes);
            }
        });
        this.localNodeId = this.clusterNetSvc.topologyService().localMember().id();
        this.localNodeConsistentId = this.clusterNetSvc.topologyService().localMember().name();
        this.replicaStateManager.start(this.localNodeId);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.replicaStateManager.stop();
        this.blockBusy();
        int shutdownTimeoutSeconds = 10;
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.scheduledIdleSafeTimeSyncExecutor, (long)shutdownTimeoutSeconds, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)shutdownTimeoutSeconds, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.replicasCreationExecutor, (long)shutdownTimeoutSeconds, (TimeUnit)TimeUnit.SECONDS);
        try {
            IgniteUtils.closeAllManually((ManuallyCloseable[])new ManuallyCloseable[]{() -> {
                assert (this.replicas.values().stream().noneMatch(CompletableFuture::isDone)) : "There are replicas alive [replicas=" + String.valueOf(this.replicas.entrySet().stream().filter(e -> ((CompletableFuture)e.getValue()).isDone()).map(Map.Entry::getKey).collect(Collectors.toSet())) + "]";
                this.replicas.values().forEach(replicaFuture -> replicaFuture.completeExceptionally(new NodeStoppingException()));
            }});
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Nullable
    private static HybridTimestamp extractTimestamp(ReplicaRequest request) {
        if (request instanceof TimestampAware) {
            return ((TimestampAware)((Object)request)).timestamp();
        }
        return null;
    }

    private void sendReplicaUnavailableErrorResponse(String senderConsistentId, long correlationId, ReplicationGroupId groupId, @Nullable HybridTimestamp requestTimestamp) {
        if (requestTimestamp != null) {
            this.clusterNetSvc.messagingService().respond(senderConsistentId, (NetworkMessage)REPLICA_MESSAGES_FACTORY.errorTimestampAwareReplicaResponse().throwable((Throwable)((Object)new ReplicaUnavailableException(groupId, this.clusterNetSvc.topologyService().localMember()))).timestamp(this.clockService.updateClock(requestTimestamp)).build(), correlationId);
        } else {
            this.clusterNetSvc.messagingService().respond(senderConsistentId, (NetworkMessage)REPLICA_MESSAGES_FACTORY.errorReplicaResponse().throwable((Throwable)((Object)new ReplicaUnavailableException(groupId, this.clusterNetSvc.topologyService().localMember()))).build(), correlationId);
        }
    }

    private void sendAwaitReplicaResponse(String senderConsistentId, long correlationId) {
        this.clusterNetSvc.messagingService().respond(senderConsistentId, (NetworkMessage)REPLICA_MESSAGES_FACTORY.awaitReplicaResponse().build(), correlationId);
    }

    private NetworkMessage prepareReplicaResponse(boolean sendTimestamp, ReplicaResult result) {
        if (sendTimestamp) {
            HybridTimestamp commitTs = result.applyResult().commitTimestamp();
            return REPLICA_MESSAGES_FACTORY.timestampAwareReplicaResponse().result(result.result()).timestamp(commitTs == null ? this.clockService.current() : commitTs).build();
        }
        return REPLICA_MESSAGES_FACTORY.replicaResponse().result(result.result()).build();
    }

    private NetworkMessage prepareReplicaErrorResponse(boolean sendTimestamp, Throwable ex) {
        if (sendTimestamp) {
            return REPLICA_MESSAGES_FACTORY.errorTimestampAwareReplicaResponse().throwable(ex).timestamp(this.clockService.now()).build();
        }
        return REPLICA_MESSAGES_FACTORY.errorReplicaResponse().throwable(ex).build();
    }

    private void idleSafeTimeSync() {
        if (!this.shouldAdvanceIdleSafeTime()) {
            return;
        }
        this.lastIdleSafeTimeProposal = this.clockService.now();
        for (Map.Entry<ReplicationGroupId, CompletableFuture<Replica>> entry : this.replicas.entrySet()) {
            try {
                this.sendSafeTimeSyncIfReplicaReady(entry.getValue());
            }
            catch (AssertionError | Exception e) {
                LOG.warn("Error while trying to send a safe time sync request [groupId={}]", (Throwable)e, new Object[]{entry.getKey()});
            }
            catch (Error e) {
                LOG.error("Error while trying to send a safe time sync request [groupId={}]", (Throwable)e, new Object[]{entry.getKey()});
                this.failureManager.process(new FailureContext(FailureType.CRITICAL_ERROR, (Throwable)e));
            }
        }
    }

    private void sendSafeTimeSyncIfReplicaReady(CompletableFuture<Replica> replicaFuture) {
        if (!CompletableFutures.isCompletedSuccessfully(replicaFuture)) {
            return;
        }
        Replica replica = replicaFuture.join();
        ReplicaSafeTimeSyncRequest req = REPLICA_MESSAGES_FACTORY.replicaSafeTimeSyncRequest().groupId(ReplicaManager.toReplicationGroupIdMessage(replica.groupId())).build();
        replica.processRequest(req, this.localNodeId).whenComplete((res, ex) -> {
            if (ex != null && !ExceptionUtils.hasCauseOrSuppressed((Throwable)ex, (Class[])new Class[]{NodeStoppingException.class}) && !ExceptionUtils.hasCauseOrSuppressed((Throwable)ex, (Class[])new Class[]{CancellationException.class})) {
                LOG.error("Could not advance safe time for {} to {}", ex, new Object[]{replica.groupId()});
            }
        });
    }

    private boolean shouldAdvanceIdleSafeTime() {
        HybridTimestamp lastProposal = this.lastIdleSafeTimeProposal;
        if (lastProposal == null) {
            return true;
        }
        HybridTimestamp requiredLastAttemptActualityTime = lastProposal.addPhysicalTime(this.clockService.maxClockSkewMillis());
        return this.placementDriver.isActualAt(requiredLastAttemptActualityTime);
    }

    @Deprecated
    @TestOnly
    @VisibleForTesting
    public boolean isReplicaStarted(ReplicationGroupId replicaGrpId) {
        CompletableFuture<Replica> replicaFuture = this.replicas.get(replicaGrpId);
        return replicaFuture != null && CompletableFutures.isCompletedSuccessfully(replicaFuture);
    }

    public CompletableFuture<Boolean> weakStartReplica(ReplicationGroupId groupId, Supplier<CompletableFuture<Boolean>> startOperation, @Nullable Assignments forcedAssignments) {
        return this.replicaStateManager.weakStartReplica(groupId, startOperation, forcedAssignments);
    }

    public CompletableFuture<Void> weakStopReplica(ReplicationGroupId groupId, WeakReplicaStopReason reason, Supplier<CompletableFuture<Void>> stopOperation) {
        return this.replicaStateManager.weakStopReplica(groupId, reason, stopOperation);
    }

    @TestOnly
    public boolean isReplicaTouched(ReplicationGroupId replicaGrpId) {
        return this.replicas.containsKey(replicaGrpId);
    }

    @TestOnly
    public Set<ReplicationGroupId> startedGroups() {
        return this.replicas.entrySet().stream().filter(entry -> CompletableFutures.isCompletedSuccessfully((CompletableFuture)((CompletableFuture)entry.getValue()))).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void destroyReplicationProtocolStorages(ReplicationGroupId replicaGrpId, boolean isVolatileStorage) throws NodeStoppingException {
        RaftNodeId raftNodeId = new RaftNodeId(replicaGrpId, new Peer(this.localNodeConsistentId));
        RaftGroupOptions groupOptions = this.groupOptionsForPartition(isVolatileStorage, null);
        ((Loza)this.raftManager).destroyRaftNodeStorages(raftNodeId, groupOptions);
    }

    private static ReplicationGroupIdMessage toReplicationGroupIdMessage(ReplicationGroupId replicationGroupId) {
        if (replicationGroupId instanceof TablePartitionId) {
            return ReplicaMessageUtils.toTablePartitionIdMessage(REPLICA_MESSAGES_FACTORY, (TablePartitionId)replicationGroupId);
        }
        if (replicationGroupId instanceof ZonePartitionId) {
            return ReplicaMessageUtils.toZonePartitionIdMessage(REPLICA_MESSAGES_FACTORY, (ZonePartitionId)replicationGroupId);
        }
        throw new AssertionError((Object)("Not supported: " + String.valueOf(replicationGroupId)));
    }

    private boolean enterBusy() {
        return !this.busyLock.isWriteLockedByCurrentThread() && this.busyLock.readLock().tryLock();
    }

    private void leaveBusy() {
        this.busyLock.readLock().unlock();
    }

    private void blockBusy() {
        this.busyLock.writeLock().lock();
    }

    private static class ReplicaStateManager {
        private static final IgniteLogger LOG = Loggers.forClass(ReplicaStateManager.class);
        final Map<ReplicationGroupId, ReplicaStateContext> replicaContexts = new ConcurrentHashMap<ReplicationGroupId, ReplicaStateContext>();
        final Executor replicaStartStopPool;
        final ClockService clockService;
        final PlacementDriver placementDriver;
        final ReplicaManager replicaManager;
        volatile UUID localNodeId;
        private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();

        ReplicaStateManager(Executor replicaStartStopPool, ClockService clockService, PlacementDriver placementDriver, ReplicaManager replicaManager) {
            this.replicaStartStopPool = replicaStartStopPool;
            this.clockService = clockService;
            this.placementDriver = placementDriver;
            this.replicaManager = replicaManager;
        }

        void start(UUID localNodeId) {
            this.localNodeId = localNodeId;
            this.placementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, this::onPrimaryElected);
            this.placementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, this::onPrimaryExpired);
        }

        void stop() {
            this.busyLock.block();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<Boolean> onPrimaryElected(PrimaryReplicaEventParameters parameters) {
            if (!this.busyLock.enterBusy()) {
                return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
            }
            try {
                ReplicationGroupId replicationGroupId = parameters.groupId();
                ReplicaStateContext context = this.getContext(replicationGroupId);
                Object object = context;
                synchronized (object) {
                    if (this.localNodeId.equals(parameters.leaseholderId())) {
                        assert (context.replicaState != ReplicaState.STOPPED) : "Unexpected primary replica state STOPPED [groupId=" + String.valueOf(replicationGroupId) + ", leaseStartTime=" + String.valueOf(parameters.startTime()) + ", reservedForPrimary=" + context.reservedForPrimary + ", contextLeaseStartTime=" + String.valueOf(context.leaseStartTime) + "].";
                    } else if (context.reservedForPrimary) {
                        context.assertReservation(replicationGroupId, parameters.startTime());
                        if (parameters.startTime().compareTo(context.leaseStartTime) > 0) {
                            context.unreserve();
                            if (context.replicaState == ReplicaState.PRIMARY_ONLY) {
                                ReplicaStateManager.executeDeferredReplicaStop(replicationGroupId, context);
                            }
                        }
                    }
                }
                object = CompletableFutures.falseCompletedFuture();
                return object;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<Boolean> onPrimaryExpired(PrimaryReplicaEventParameters parameters) {
            if (!this.busyLock.enterBusy()) {
                return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
            }
            try {
                ReplicaStateContext context;
                if (this.localNodeId.equals(parameters.leaseholderId()) && (context = this.replicaContexts.get(parameters.groupId())) != null) {
                    ReplicaStateContext replicaStateContext = context;
                    synchronized (replicaStateContext) {
                        context.assertReservation(parameters.groupId(), parameters.startTime());
                        if (parameters.startTime().equals((Object)context.leaseStartTime)) {
                            context.unreserve();
                            if (context.replicaState == ReplicaState.RESTART_PLANNED) {
                                ReplicaStateManager.executeDeferredReplicaStop(parameters.groupId(), context);
                            }
                        }
                    }
                }
                CompletableFuture completableFuture = CompletableFutures.falseCompletedFuture();
                return completableFuture;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }

        ReplicaStateContext getContext(ReplicationGroupId groupId) {
            return this.replicaContexts.computeIfAbsent(groupId, k -> new ReplicaStateContext(ReplicaState.STOPPED, CompletableFutures.nullCompletedFuture()));
        }

        CompletableFuture<Boolean> weakStartReplica(ReplicationGroupId groupId, Supplier<CompletableFuture<Boolean>> startOperation, @Nullable Assignments forcedAssignments) {
            ReplicaStateContext context;
            ReplicaStateContext replicaStateContext = context = this.getContext(groupId);
            synchronized (replicaStateContext) {
                ReplicaState state = context.replicaState;
                LOG.debug("Weak replica start [grp={}, state={}, future={}].", new Object[]{groupId, state, context.previousOperationFuture});
                if (state == ReplicaState.STOPPED || state == ReplicaState.STOPPING) {
                    return this.startReplica(groupId, context, startOperation);
                }
                if (state == ReplicaState.ASSIGNED) {
                    if (forcedAssignments != null) {
                        assert (forcedAssignments.force()) : IgniteStringFormatter.format((String)"Unexpected assignments to force [assignments={}, groupId={}].", (Object[])new Object[]{forcedAssignments, groupId});
                        this.replicaManager.resetPeers(groupId, PeersAndLearners.fromAssignments((Collection)forcedAssignments.nodes()));
                    }
                    return CompletableFutures.trueCompletedFuture();
                }
                if (state == ReplicaState.PRIMARY_ONLY) {
                    context.replicaState = ReplicaState.ASSIGNED;
                    LOG.debug("Weak replica start complete [state={}].", new Object[]{context.replicaState});
                    return CompletableFutures.trueCompletedFuture();
                }
                if (state == ReplicaState.RESTART_PLANNED) {
                    throw new AssertionError((Object)("Replica start cannot begin before stop on replica restart is completed [groupId=" + String.valueOf(groupId) + "]."));
                }
                throw new AssertionError((Object)("Replica start cannot begin while the replica is being started [groupId=" + String.valueOf(groupId) + "]."));
            }
        }

        private CompletableFuture<Boolean> startReplica(ReplicationGroupId groupId, ReplicaStateContext context, Supplier<CompletableFuture<Boolean>> startOperation) {
            context.replicaState = ReplicaState.STARTING;
            context.previousOperationFuture = ((CompletableFuture)((CompletableFuture)context.previousOperationFuture.handleAsync((v, e) -> (CompletableFuture)startOperation.get(), this.replicaStartStopPool)).thenCompose(startOperationFuture -> startOperationFuture.thenApply(partitionStarted -> {
                ReplicaStateContext replicaStateContext = context;
                synchronized (replicaStateContext) {
                    if (partitionStarted.booleanValue()) {
                        context.replicaState = ReplicaState.ASSIGNED;
                    } else {
                        context.replicaState = ReplicaState.STOPPED;
                        this.replicaContexts.remove(groupId);
                    }
                }
                LOG.debug("Weak replica start complete [state={}, partitionStarted={}].", new Object[]{context.replicaState, partitionStarted});
                return partitionStarted;
            }))).exceptionally(e -> {
                LOG.error("Replica start failed [groupId={}]", e, new Object[]{groupId});
                throw new CompletionException((Throwable)e);
            });
            return context.previousOperationFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        CompletableFuture<Void> weakStopReplica(ReplicationGroupId groupId, WeakReplicaStopReason reason, Supplier<CompletableFuture<Void>> stopOperation) {
            ReplicaStateContext context;
            ReplicaStateContext replicaStateContext = context = this.getContext(groupId);
            synchronized (replicaStateContext) {
                ReplicaState state = context.replicaState;
                LOG.debug("Weak replica stop [grpId={}, state={}, reason={}, reservedForPrimary={}, future={}].", new Object[]{groupId, state, reason, context.reservedForPrimary, context.previousOperationFuture});
                if (reason == WeakReplicaStopReason.EXCLUDED_FROM_ASSIGNMENTS) {
                    if (state == ReplicaState.ASSIGNED) {
                        if (!context.reservedForPrimary) {
                            return this.stopReplica(groupId, context, stopOperation);
                        }
                        context.replicaState = ReplicaState.PRIMARY_ONLY;
                        this.planDeferredReplicaStop(groupId, context, null, stopOperation);
                    } else {
                        if (state == ReplicaState.STARTING) {
                            return this.stopReplica(groupId, context, stopOperation);
                        }
                        if (state == ReplicaState.STOPPED) {
                            return this.stopReplica(groupId, context, stopOperation);
                        }
                    }
                } else {
                    if (reason == WeakReplicaStopReason.RESTART) {
                        if (context.reservedForPrimary) {
                            context.replicaState = ReplicaState.RESTART_PLANNED;
                            return this.replicaManager.stopLeaseProlongation(groupId, null).thenCompose(leaseExpirationTime -> this.planDeferredReplicaStop(groupId, context, (HybridTimestamp)leaseExpirationTime, stopOperation));
                        }
                        return this.stopReplica(groupId, context, stopOperation);
                    }
                    assert (reason == WeakReplicaStopReason.PRIMARY_EXPIRED) : "Unknown replica stop reason: " + String.valueOf((Object)reason);
                    if (state == ReplicaState.PRIMARY_ONLY) {
                        return this.stopReplica(groupId, context, stopOperation);
                    }
                }
                LOG.debug("Weak replica stop (sync part) complete [grpId={}, state={}].", new Object[]{groupId, context.replicaState});
                return CompletableFutures.nullCompletedFuture();
            }
        }

        private CompletableFuture<Void> stopReplica(ReplicationGroupId groupId, ReplicaStateContext context, Supplier<CompletableFuture<Void>> stopOperation) {
            context.replicaState = ReplicaState.STOPPING;
            context.previousOperationFuture = ((CompletableFuture)((CompletableFuture)context.previousOperationFuture.handleAsync((v, e) -> (CompletableFuture)stopOperation.get(), this.replicaStartStopPool)).thenCompose(stopOperationFuture -> stopOperationFuture.thenApply(v -> {
                ReplicaStateContext replicaStateContext = context;
                synchronized (replicaStateContext) {
                    context.replicaState = ReplicaState.STOPPED;
                }
                LOG.debug("Weak replica stop complete [grpId={}, state={}].", new Object[]{groupId, context.replicaState});
                return true;
            }))).exceptionally(e -> {
                LOG.error("Replica stop failed [groupId={}]", e, new Object[]{groupId});
                throw new CompletionException((Throwable)e);
            });
            return context.previousOperationFuture.thenApply(v -> null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<Void> planDeferredReplicaStop(ReplicationGroupId groupId, ReplicaStateContext context, @Nullable HybridTimestamp leaseExpirationTime, Supplier<CompletableFuture<Void>> deferredStopOperation) {
            ReplicaStateContext replicaStateContext = context;
            synchronized (replicaStateContext) {
                context.deferredStopReadyFuture = leaseExpirationTime == null ? new CompletableFuture() : this.replicaManager.clockService.waitFor(leaseExpirationTime);
                return context.deferredStopReadyFuture.thenComposeAsync(unused -> this.stopReplica(groupId, context, deferredStopOperation), this.replicaManager.requestsExecutor);
            }
        }

        private static void executeDeferredReplicaStop(ReplicationGroupId groupId, ReplicaStateContext context) {
            assert (context.deferredStopReadyFuture != null) : "Stop operation future is not set [groupId=" + String.valueOf(groupId) + "].";
            context.deferredStopReadyFuture.complete(null);
            context.deferredStopReadyFuture = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reserveReplica(ReplicationGroupId groupId, HybridTimestamp leaseStartTime) {
            ReplicaStateContext context;
            ReplicaStateContext replicaStateContext = context = this.getContext(groupId);
            synchronized (replicaStateContext) {
                ReplicaState state = context.replicaState;
                if (state == ReplicaState.STOPPING || state == ReplicaState.STOPPED) {
                    if (state == ReplicaState.STOPPED) {
                        this.replicaContexts.remove(groupId);
                    }
                    if (context.reservedForPrimary) {
                        throw new AssertionError((Object)("Unexpected replica reservation with " + String.valueOf((Object)state) + " state [groupId=" + String.valueOf(groupId) + "]."));
                    }
                } else if (state != ReplicaState.RESTART_PLANNED) {
                    context.reserve(groupId, leaseStartTime);
                }
                return context.reservedForPrimary;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TestOnly
        boolean isReplicaPrimaryOnly(ReplicationGroupId groupId) {
            ReplicaStateContext context;
            ReplicaStateContext replicaStateContext = context = this.getContext(groupId);
            synchronized (replicaStateContext) {
                return context.replicaState == ReplicaState.PRIMARY_ONLY;
            }
        }
    }

    public static enum WeakReplicaStopReason {
        EXCLUDED_FROM_ASSIGNMENTS,
        PRIMARY_EXPIRED,
        RESTART;

    }

    private static enum ReplicaState {
        STARTING,
        ASSIGNED,
        PRIMARY_ONLY,
        RESTART_PLANNED,
        STOPPING,
        STOPPED;

    }

    private static class ReplicaStateContext {
        ReplicaState replicaState;
        CompletableFuture<Boolean> previousOperationFuture;
        boolean reservedForPrimary;
        @Nullable
        HybridTimestamp leaseStartTime;
        @Nullable
        CompletableFuture<Void> deferredStopReadyFuture;

        ReplicaStateContext(ReplicaState replicaState, CompletableFuture<Boolean> previousOperationFuture) {
            this.replicaState = replicaState;
            this.previousOperationFuture = previousOperationFuture;
        }

        void reserve(ReplicationGroupId groupId, HybridTimestamp leaseStartTime) {
            if (this.reservedForPrimary && this.leaseStartTime != null && leaseStartTime.compareTo(this.leaseStartTime) < 0) {
                throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Replica reservation failed: newer lease has already reserved this replica [groupId={}, requestedLeaseStartTime={}, newerLeaseStartTime={}].", (Object[])new Object[]{groupId, leaseStartTime, this.leaseStartTime}));
            }
            this.leaseStartTime = leaseStartTime;
            this.reservedForPrimary = true;
        }

        void unreserve() {
            this.reservedForPrimary = false;
            this.leaseStartTime = null;
        }

        void assertReservation(ReplicationGroupId groupId, HybridTimestamp leaseStartTime) {
            assert (this.reservedForPrimary) : "Replica is elected as primary but not reserved [groupId=" + String.valueOf(groupId) + ", leaseStartTime=" + String.valueOf(leaseStartTime) + "].";
            assert (leaseStartTime != null) : "Replica is reserved but lease start time is null [groupId=" + String.valueOf(groupId) + ", leaseStartTime=" + String.valueOf(leaseStartTime) + "].";
        }
    }
}

