/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format.compiled;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DayOfWeek;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.CapitalizationEnum;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class DayOfWeekCompiledPattern
extends CompiledPattern {
    private final CapitalizationEnum capitalization;
    private final TextStyle textStyle;

    public DayOfWeekCompiledPattern(Set<PatternModifier> modifiers, CapitalizationEnum capitalization, TextStyle textStyle) {
        super(ChronoUnitEnum.DAYS_IN_WEEK, modifiers);
        this.capitalization = capitalization;
        this.textStyle = textStyle;
    }

    @Override
    public String convertToString(ZonedDateTime dateTime, Locale locale) {
        Locale localeToUse = this.modifiers.contains((Object)PatternModifier.TM) ? locale : Locale.US;
        int intValue = dateTime.getDayOfWeek().getValue();
        String stringValue = this.capitalization.apply(DayOfWeek.of(intValue).getDisplayName(this.textStyle, localeToUse), localeToUse);
        if (this.textStyle == TextStyle.FULL && !this.modifiers.contains((Object)PatternModifier.FM) && !this.modifiers.contains((Object)PatternModifier.TM)) {
            return String.format(locale, "%-9s", stringValue);
        }
        return stringValue;
    }

    @Override
    public int parseValue(ParsePosition inputPosition, String input, boolean enforceLength, Locale locale) throws ParseException {
        Locale localeToUse = this.modifiers.contains((Object)PatternModifier.TM) ? locale : Locale.US;
        String inputTrimmed = input.substring(inputPosition.getIndex());
        for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
            String expectedValue = this.capitalization.apply(dayOfWeek.getDisplayName(this.textStyle, localeToUse), localeToUse);
            if (!inputTrimmed.startsWith(expectedValue)) continue;
            inputPosition.setIndex(inputPosition.getIndex() + expectedValue.length());
            return dayOfWeek.getValue();
        }
        throw new ParseException("Unable to parse value", inputPosition.getIndex());
    }

    @Override
    protected int getBaseFormatPatternLength() {
        return this.textStyle == TextStyle.FULL ? 3 : 2;
    }
}

