/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format.compiled;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class TimeZoneMinutesCompiledPattern
extends CompiledPattern {
    public TimeZoneMinutesCompiledPattern(Set<PatternModifier> modifiers) {
        super(ChronoUnitEnum.TIMEZONE_MINUTES, modifiers);
    }

    @Override
    public String convertToString(ZonedDateTime dateTime, Locale locale) {
        return String.format(Locale.ROOT, "%02d", dateTime.getOffset().getTotalSeconds() % 3600 / 60);
    }

    @Override
    public int parseValue(ParsePosition inputPosition, String input, boolean enforceLength, Locale locale) throws ParseException {
        if (inputPosition.getIndex() + 2 > input.length()) {
            throw new ParseException("Unable to parse value", inputPosition.getIndex());
        }
        if (!Character.isDigit(input.charAt(inputPosition.getIndex())) || !Character.isDigit(input.charAt(inputPosition.getIndex() + 1))) {
            throw new ParseException("Unable to parse value", inputPosition.getIndex());
        }
        int timezoneMinutes = Integer.parseInt(input.substring(inputPosition.getIndex(), inputPosition.getIndex() + 2));
        if (timezoneMinutes >= 60) {
            throw new ParseException("Value outside of valid range", inputPosition.getIndex());
        }
        inputPosition.setIndex(inputPosition.getIndex() + 2);
        return timezoneMinutes;
    }

    @Override
    protected int getBaseFormatPatternLength() {
        return 3;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }
}

