/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.throttling;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.throttling.IntervalBasedMeasurement;
import org.apache.ignite.internal.pagememory.persistence.throttling.ProgressSpeedCalculation;

class SpeedBasedMemoryConsumptionThrottlingStrategy {
    private final double minDirtyPages;
    private final double maxDirtyPages;
    private final PersistentPageMemory pageMemory;
    private final Supplier<CheckpointProgress> cpProgress;
    private volatile long pageMemTotalPages;
    private volatile long speedForMarkAll;
    private volatile double targetDirtyRatio;
    private volatile double currDirtyRatio;
    private final Set<Long> threadIds = ConcurrentHashMap.newKeySet();
    private final AtomicInteger lastObservedWritten = new AtomicInteger(0);
    private volatile double initDirtyRatioAtCpBegin;
    private volatile double writeVsFsyncCoefficient = 0.8333333333333334;
    private final ProgressSpeedCalculation cpWriteSpeed = new ProgressSpeedCalculation();
    private final IntervalBasedMeasurement markSpeedAndAvgParkTime;

    SpeedBasedMemoryConsumptionThrottlingStrategy(double minDirtyPages, double maxDirtyPages, PersistentPageMemory pageMemory, Supplier<CheckpointProgress> cpProgress, IntervalBasedMeasurement markSpeedAndAvgParkTime) {
        this.minDirtyPages = minDirtyPages;
        this.maxDirtyPages = maxDirtyPages;
        this.pageMemory = pageMemory;
        this.cpProgress = cpProgress;
        this.markSpeedAndAvgParkTime = markSpeedAndAvgParkTime;
        this.initDirtyRatioAtCpBegin = minDirtyPages;
    }

    long protectionParkTime(long curNanoTime) {
        boolean checkpointProgressIsNotYetReported;
        CheckpointProgress progress = this.cpProgress.get();
        boolean bl = checkpointProgressIsNotYetReported = progress == null;
        if (checkpointProgressIsNotYetReported) {
            this.resetStatistics();
            return Long.MIN_VALUE;
        }
        this.threadIds.add(Thread.currentThread().getId());
        int writtenPages = progress.writtenPages() + progress.evictedPagesCounter().get();
        return this.computeParkTime(writtenPages, curNanoTime);
    }

    private void resetStatistics() {
        this.speedForMarkAll = 0L;
        this.targetDirtyRatio = -1.0;
        this.currDirtyRatio = -1.0;
    }

    private long computeParkTime(int cpWrittenPages, long curNanoTime) {
        long donePages = this.cpDonePagesEstimation(cpWrittenPages);
        long instantaneousMarkDirtySpeed = this.markSpeedAndAvgParkTime.getSpeedOpsPerSec(curNanoTime);
        this.cpWriteSpeed.setProgress(donePages, curNanoTime);
        long avgCpWriteSpeed = this.cpWriteSpeed.getOpsPerSecond(curNanoTime);
        int cpTotalPages = this.cpTotalPages();
        if (cpTotalPages == 0) {
            return this.parkTimeToThrottleByJustCpSpeed(instantaneousMarkDirtySpeed, avgCpWriteSpeed);
        }
        return this.speedBasedParkTime(cpWrittenPages, donePages, cpTotalPages, instantaneousMarkDirtySpeed, avgCpWriteSpeed);
    }

    private int cpDonePagesEstimation(int cpWrittenPages) {
        double coefficient = this.writeVsFsyncCoefficient;
        return (int)((double)cpWrittenPages * coefficient + (double)this.cpSyncedPages() * (1.0 - coefficient));
    }

    private long parkTimeToThrottleByJustCpSpeed(long markDirtySpeed, long curCpWriteSpeed) {
        boolean throttleByCpSpeed;
        boolean bl = throttleByCpSpeed = curCpWriteSpeed > 0L && markDirtySpeed > curCpWriteSpeed;
        if (throttleByCpSpeed) {
            return this.nsPerOperation(curCpWriteSpeed);
        }
        return 0L;
    }

    private long speedBasedParkTime(int cpWrittenPages, long donePages, int cpTotalPages, long instantaneousMarkDirtySpeed, long avgCpWriteSpeed) {
        double dirtyPagesRatio;
        this.currDirtyRatio = dirtyPagesRatio = this.pageMemory.dirtyPagesRatio();
        this.detectCpPagesWriteStart(cpWrittenPages, dirtyPagesRatio);
        if (dirtyPagesRatio >= this.maxDirtyPages) {
            return 0L;
        }
        return this.getParkTime(dirtyPagesRatio, donePages, cpTotalPages, this.threadIds.size(), instantaneousMarkDirtySpeed, avgCpWriteSpeed);
    }

    private int notEvictedPagesTotal(int cpTotalPages) {
        return Math.max(cpTotalPages - this.cpEvictedPages(), 0);
    }

    long getParkTime(double dirtyPagesRatio, long donePages, int cpTotalPages, int threads, long instantaneousMarkDirtySpeed, long avgCpWriteSpeed) {
        long targetSpeedToMarkAll = this.calcSpeedToMarkAllSpaceTillEndOfCp(dirtyPagesRatio, donePages, avgCpWriteSpeed, cpTotalPages);
        double targetCurrentDirtyRatio = this.targetCurrentDirtyRatio(donePages, cpTotalPages);
        this.publishSpeedAndRatioForMetrics(targetSpeedToMarkAll, targetCurrentDirtyRatio);
        return this.delayIfMarkingFasterThanTargetSpeedAllows(instantaneousMarkDirtySpeed, dirtyPagesRatio, threads, targetSpeedToMarkAll, targetCurrentDirtyRatio);
    }

    private long delayIfMarkingFasterThanTargetSpeedAllows(long instantaneousMarkDirtySpeed, double dirtyPagesRatio, int threads, long targetSpeedToMarkAll, double targetCurrentDirtyRatio) {
        boolean lowSpaceLeft = SpeedBasedMemoryConsumptionThrottlingStrategy.lowCleanSpaceLeft(dirtyPagesRatio, targetCurrentDirtyRatio);
        int slowdown = SpeedBasedMemoryConsumptionThrottlingStrategy.slowdownIfLowSpaceLeft(lowSpaceLeft);
        double multiplierForSpeedToMarkAll = lowSpaceLeft ? 0.8 : 1.0;
        boolean markingTooFastNow = targetSpeedToMarkAll > 0L && (double)instantaneousMarkDirtySpeed > multiplierForSpeedToMarkAll * (double)targetSpeedToMarkAll;
        boolean markedTooFastSinceCpStart = dirtyPagesRatio > targetCurrentDirtyRatio;
        boolean markingTooFast = markedTooFastSinceCpStart && markingTooFastNow;
        return markingTooFast ? this.nsPerOperation(targetSpeedToMarkAll, threads, slowdown) : 0L;
    }

    private static int slowdownIfLowSpaceLeft(boolean lowSpaceLeft) {
        return lowSpaceLeft ? 3 : 1;
    }

    private static boolean lowCleanSpaceLeft(double dirtyPagesRatio, double targetDirtyRatio) {
        return dirtyPagesRatio > targetDirtyRatio && dirtyPagesRatio + 0.05 > 0.9;
    }

    private void publishSpeedAndRatioForMetrics(long speedForMarkAll, double targetDirtyRatio) {
        this.speedForMarkAll = speedForMarkAll;
        this.targetDirtyRatio = targetDirtyRatio;
    }

    private long calcSpeedToMarkAllSpaceTillEndOfCp(double dirtyPagesRatio, long donePages, long avgCpWriteSpeed, int cpTotalPages) {
        if (avgCpWriteSpeed == 0L) {
            return 0L;
        }
        if (cpTotalPages <= 0) {
            return 0L;
        }
        if (dirtyPagesRatio >= this.maxDirtyPages) {
            return 0L;
        }
        double remainedCleanPages = (this.maxDirtyPages - dirtyPagesRatio) * (double)this.pageMemTotalPages();
        double secondsTillCpEnd = 1.0 * (double)((long)cpTotalPages - donePages) / (double)avgCpWriteSpeed;
        return (long)(remainedCleanPages / secondsTillCpEnd);
    }

    private long pageMemTotalPages() {
        long currentTotalPages = this.pageMemTotalPages;
        if (currentTotalPages == 0L) {
            this.pageMemTotalPages = currentTotalPages = this.pageMemory.totalPages();
        }
        assert (currentTotalPages > 0L) : "PageMemory.totalPages() is still 0";
        return currentTotalPages;
    }

    private double targetCurrentDirtyRatio(long donePages, int cpTotalPages) {
        double cpProgress = (double)donePages / (double)cpTotalPages;
        double constStart = this.initDirtyRatioAtCpBegin;
        double fractionToVaryDirtyRatio = 1.0 - constStart;
        return (cpProgress * fractionToVaryDirtyRatio + constStart) * this.maxDirtyPages;
    }

    double getTargetDirtyRatio() {
        return this.targetDirtyRatio;
    }

    double getCurrDirtyRatio() {
        double ratio = this.currDirtyRatio;
        if (ratio >= 0.0) {
            return ratio;
        }
        return this.pageMemory.dirtyPagesRatio();
    }

    long getLastEstimatedSpeedForMarkAll() {
        return this.speedForMarkAll;
    }

    long getCpWriteSpeed() {
        return this.cpWriteSpeed.getOpsPerSecondReadOnly();
    }

    int cpSyncedPages() {
        CheckpointProgress progress = this.cpProgress.get();
        if (progress == null) {
            return 0;
        }
        AtomicInteger syncedPagesCounter = progress.syncedPagesCounter();
        return syncedPagesCounter == null ? 0 : syncedPagesCounter.get();
    }

    int cpTotalPages() {
        CheckpointProgress progress = this.cpProgress.get();
        if (progress == null) {
            return 0;
        }
        return progress.currentCheckpointPagesCount();
    }

    int cpEvictedPages() {
        CheckpointProgress progress = this.cpProgress.get();
        if (progress == null) {
            return 0;
        }
        AtomicInteger evictedPagesCounter = progress.evictedPagesCounter();
        return evictedPagesCounter == null ? 0 : evictedPagesCounter.get();
    }

    double getWriteVsFsyncCoefficient() {
        return this.writeVsFsyncCoefficient;
    }

    long nsPerOperation(long baseSpeed) {
        return this.nsPerOperation(baseSpeed, this.threadIds.size());
    }

    private long nsPerOperation(long speedPagesPerSec, int threads) {
        return this.nsPerOperation(speedPagesPerSec, threads, 1);
    }

    private long nsPerOperation(long speedPagesPerSec, int threads, int factor) {
        if (factor <= 0) {
            throw new IllegalStateException("Coefficient should be positive");
        }
        if (speedPagesPerSec <= 0L) {
            return 0L;
        }
        long updTimeNsForOnePage = TimeUnit.SECONDS.toNanos(1L) * (long)threads / speedPagesPerSec;
        return (long)factor * updTimeNsForOnePage;
    }

    private void detectCpPagesWriteStart(int cpWrittenPages, double dirtyPagesRatio) {
        if (cpWrittenPages > 0 && this.lastObservedWritten.get() == 0 && this.lastObservedWritten.compareAndSet(0, cpWrittenPages)) {
            double newMinRatio = dirtyPagesRatio;
            if (newMinRatio < this.minDirtyPages) {
                newMinRatio = this.minDirtyPages;
            }
            if (newMinRatio > 1.0) {
                newMinRatio = 1.0;
            }
            this.initDirtyRatioAtCpBegin = newMinRatio;
        }
    }

    void reset() {
        this.cpWriteSpeed.forceProgress(0L, System.nanoTime());
        this.initDirtyRatioAtCpBegin = this.minDirtyPages;
        this.lastObservedWritten.set(0);
    }

    void finish() {
        CheckpointProgress checkpointProgress = this.cpProgress.get();
        assert (checkpointProgress != null) : "Checkpoint progress is already null while checkpoint is finishing";
        this.cpWriteSpeed.forceProgress(checkpointProgress.currentCheckpointPagesCount(), System.nanoTime());
        this.cpWriteSpeed.closeInterval();
        this.threadIds.clear();
        this.updateWriteVsFsyncCoefficient();
    }

    private void updateWriteVsFsyncCoefficient() {
        long fsyncTimeMillis;
        CheckpointProgress progress = this.cpProgress.get();
        assert (progress != null);
        if (progress.currentCheckpointPagesCount() == 0) {
            return;
        }
        long pagesWriteTimeMillis = progress.getPagesWriteTimeMillis();
        double coefficient = (double)pagesWriteTimeMillis / (double)(pagesWriteTimeMillis + (fsyncTimeMillis = progress.getFsyncTimeMillis()));
        if (Double.isNaN(coefficient)) {
            return;
        }
        double newCoefficient = this.writeVsFsyncCoefficient * 0.85 + coefficient * 0.15;
        if (newCoefficient < 0.1) {
            newCoefficient = 0.1;
        } else if (newCoefficient > 0.9) {
            newCoefficient = 0.9;
        }
        this.writeVsFsyncCoefficient = newCoefficient;
    }
}

