/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.io.IOException;
import java.util.List;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;

public class CatalogSystemViewDescriptorSerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class SystemViewDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogSystemViewDescriptor> {
        SystemViewDescriptorSerializerV2() {
        }

        @Override
        public CatalogSystemViewDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            int schemaId = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp(updateTimestampLong);
            List<CatalogTableColumnDescriptor> columns = input.readEntryList(CatalogTableColumnDescriptor.class);
            byte sysViewTypeId = input.readByte();
            CatalogSystemViewDescriptor.SystemViewType sysViewType = CatalogSystemViewDescriptor.SystemViewType.forId(sysViewTypeId);
            return new CatalogSystemViewDescriptor(id, schemaId, name, columns, sysViewType, updateTimestamp);
        }

        @Override
        public void writeTo(CatalogSystemViewDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeVarInt(descriptor.schemaId());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeEntryList(descriptor.columns());
            output.writeByte(descriptor.systemViewType().id());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class SystemViewDescriptorSerializerV1
    implements CatalogObjectSerializer<CatalogSystemViewDescriptor> {
        private final CatalogEntrySerializerProvider serializers;

        public SystemViewDescriptorSerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public CatalogSystemViewDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer columnSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_COLUMN.id());
            int id = input.readVarIntAsInt();
            int schemaId = input.readVarIntAsInt();
            String name = input.readUTF();
            input.readVarInt();
            List<CatalogTableColumnDescriptor> columns = CatalogSerializationUtils.readList(columnSerializer, input);
            byte sysViewTypeId = input.readByte();
            CatalogSystemViewDescriptor.SystemViewType sysViewType = CatalogSystemViewDescriptor.SystemViewType.forId(sysViewTypeId);
            return new CatalogSystemViewDescriptor(id, schemaId, name, columns, sysViewType, CatalogManager.INITIAL_TIMESTAMP);
        }

        @Override
        public void writeTo(CatalogSystemViewDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            CatalogObjectSerializer columnSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_COLUMN.id());
            output.writeVarInt(descriptor.id());
            output.writeVarInt(descriptor.schemaId());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            CatalogSerializationUtils.writeList(descriptor.columns(), columnSerializer, output);
            output.writeByte(descriptor.systemViewType().id());
        }
    }
}

