/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc.impl.cli;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.conf.Configuration;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class ChangePeersAndLearnersRequestProcessor
extends BaseCliRequestProcessor<CliRequests.ChangePeersAndLearnersRequest> {
    public ChangePeersAndLearnersRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.ChangePeersAndLearnersRequest request) {
        return request.leaderId();
    }

    @Override
    protected String getGroupId(CliRequests.ChangePeersAndLearnersRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.ChangePeersAndLearnersRequest request, IgniteCliRpcRequestClosure done) {
        List<PeerId> oldPeers = ctx.node.listPeers();
        List<PeerId> oldLearners = ctx.node.listLearners();
        Configuration conf = new Configuration();
        Iterator<String> iterator = request.newPeersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerIdStr = iterator.next();
            if (peer.parse(peerIdStr)) {
                conf.addPeer(peer);
                continue;
            }
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", peerIdStr);
        }
        iterator = request.newLearnersList().iterator();
        while (iterator.hasNext()) {
            PeerId learner = new PeerId();
            String learnerIdStr = iterator.next();
            if (learner.parse(learnerIdStr)) {
                conf.addLearner(learner);
                continue;
            }
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse learner id %s", learnerIdStr);
        }
        long term = request.term();
        LOG.info("Receive ChangePeersAndLearnersRequest with term {} to {} from {}, new conf is {}", term, ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), conf);
        ctx.node.changePeersAndLearners(conf, term, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                CliRequests.ChangePeersAndLearnersResponse req = this.msgFactory().changePeersAndLearnersResponse().oldPeersList(ChangePeersAndLearnersRequestProcessor.toStringList(oldPeers)).newPeersList(ChangePeersAndLearnersRequestProcessor.toStringList(conf.getPeers())).oldLearnersList(ChangePeersAndLearnersRequestProcessor.toStringList(oldLearners)).newLearnersList(ChangePeersAndLearnersRequestProcessor.toStringList(conf.getLearners())).build();
                done.sendResponse(req);
            }
        });
        return null;
    }

    private static List<String> toStringList(Collection<?> collection) {
        return collection.stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public String interest() {
        return CliRequests.ChangePeersAndLearnersRequest.class.getName();
    }
}

