/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cluster;

import java.util.Arrays;
import java.util.UUID;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cluster.ClientClusterGroupGetNodesDetailsResponse;

public class ClientClusterGroupGetNodesDetailsRequest
extends ClientRequest {
    private final UUID[] nodeIds;

    public ClientClusterGroupGetNodesDetailsRequest(BinaryRawReader reader) {
        super(reader);
        int cnt = reader.readInt();
        this.nodeIds = new UUID[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.nodeIds[i] = new UUID(reader.readLong(), reader.readLong());
        }
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        IgniteClusterEx cluster = ctx.kernalContext().grid().cluster();
        ClusterGroup clusterGrp = cluster.forNodeIds(Arrays.asList(this.nodeIds));
        return new ClientClusterGroupGetNodesDetailsResponse(this.requestId(), clusterGrp.nodes());
    }
}

