/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.messaging;

import java.util.UUID;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.message.PlatformMessageFilter;

public class PlatformMessageLocalFilter
implements PlatformMessageFilter {
    private static final long serialVersionUID = 0L;
    protected final long hnd;
    protected final PlatformContext platformCtx;

    public PlatformMessageLocalFilter(long hnd, PlatformContext ctx) {
        assert (ctx != null);
        assert (hnd != 0L);
        this.hnd = hnd;
        this.platformCtx = ctx;
    }

    @Override
    public boolean apply(UUID uuid, Object m) {
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            writer.writeObject(uuid);
            writer.writeObject(m);
            out.synchronize();
            int res = this.platformCtx.gateway().messagingFilterApply(this.hnd, mem.pointer());
            boolean bl = res != 0;
            return bl;
        }
    }

    @Override
    public void onClose() {
        this.platformCtx.gateway().messagingFilterDestroy(this.hnd);
    }

    @Override
    public void initialize(GridKernalContext ctx) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformMessageLocalFilter filter = (PlatformMessageLocalFilter)o;
        return this.hnd == filter.hnd;
    }

    public int hashCode() {
        return (int)(this.hnd ^ this.hnd >>> 32);
    }
}

