/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.netty;

import io.netty.util.internal.StringUtil;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ByteProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;

class WrappedBuffer
implements Buffer {
    final Buffer buffer;

    WrappedBuffer(Buffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public Buffer capacity(int newCapacity) {
        this.buffer.capacity(newCapacity);
        return this;
    }

    public int maxCapacity() {
        return this.buffer.maxCapacity();
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public Buffer readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
        return this;
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public Buffer writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
        return this;
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    public int maxWritableBytes() {
        return this.buffer.maxWritableBytes();
    }

    public Buffer ensureWritable(int minWritableBytes) {
        this.buffer.ensureWritable(minWritableBytes);
        return this;
    }

    public int ensureWritable(int minWritableBytes, boolean force) {
        return this.buffer.ensureWritable(minWritableBytes, force);
    }

    public Buffer clear() {
        this.buffer.clear();
        return this;
    }

    public boolean getBoolean(int index) {
        return this.buffer.getBoolean(index);
    }

    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    public short getUnsignedByte(int index) {
        return this.buffer.getUnsignedByte(index);
    }

    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public short getShortLE(int index) {
        return this.buffer.getShortLE(index);
    }

    public int getUnsignedShort(int index) {
        return this.buffer.getUnsignedShort(index);
    }

    public int getUnsignedShortLE(int index) {
        return this.buffer.getUnsignedShortLE(index);
    }

    public int getMedium(int index) {
        return this.buffer.getMedium(index);
    }

    public int getMediumLE(int index) {
        return this.buffer.getMediumLE(index);
    }

    public int getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(index);
    }

    public int getUnsignedMediumLE(int index) {
        return this.buffer.getUnsignedMediumLE(index);
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public int getIntLE(int index) {
        return this.buffer.getIntLE(index);
    }

    public long getUnsignedInt(int index) {
        return this.buffer.getUnsignedInt(index);
    }

    public long getUnsignedIntLE(int index) {
        return this.buffer.getUnsignedIntLE(index);
    }

    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public long getLongLE(int index) {
        return this.buffer.getLongLE(index);
    }

    public char getChar(int index) {
        return this.buffer.getChar(index);
    }

    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    public Buffer getBytes(int index, Buffer dst) {
        this.buffer.getBytes(index, dst);
        return this;
    }

    public Buffer getBytes(int index, Buffer dst, int length) {
        this.buffer.getBytes(index, dst, length);
        return this;
    }

    public Buffer getBytes(int index, Buffer dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public Buffer getBytes(int index, byte[] dst) {
        this.buffer.getBytes(index, dst);
        return this;
    }

    public Buffer getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public Buffer getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
        return this;
    }

    public Buffer setBoolean(int index, boolean value) {
        this.buffer.setBoolean(index, value);
        return this;
    }

    public Buffer setByte(int index, int value) {
        this.buffer.setByte(index, value);
        return this;
    }

    public Buffer setShort(int index, int value) {
        this.buffer.setShort(index, value);
        return this;
    }

    public Buffer setShortLE(int index, int value) {
        this.buffer.setShortLE(index, value);
        return this;
    }

    public Buffer setMedium(int index, int value) {
        this.buffer.setMedium(index, value);
        return this;
    }

    public Buffer setMediumLE(int index, int value) {
        this.buffer.setMediumLE(index, value);
        return this;
    }

    public Buffer setInt(int index, int value) {
        this.buffer.setInt(index, value);
        return this;
    }

    public Buffer setIntLE(int index, int value) {
        this.buffer.setIntLE(index, value);
        return this;
    }

    public Buffer setLong(int index, long value) {
        this.buffer.setLong(index, value);
        return this;
    }

    public Buffer setLongLE(int index, long value) {
        this.buffer.setLongLE(index, value);
        return this;
    }

    public Buffer setChar(int index, int value) {
        this.buffer.setChar(index, value);
        return this;
    }

    public Buffer setFloat(int index, float value) {
        this.buffer.setFloat(index, value);
        return this;
    }

    public Buffer setDouble(int index, double value) {
        this.buffer.setDouble(index, value);
        return this;
    }

    public Buffer setBytes(int index, Buffer src) {
        this.buffer.setBytes(index, src);
        return this;
    }

    public Buffer setBytes(int index, Buffer src, int length) {
        this.buffer.setBytes(index, src, length);
        return this;
    }

    public Buffer setBytes(int index, Buffer src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
        return this;
    }

    public Buffer setBytes(int index, byte[] src) {
        this.buffer.setBytes(index, src);
        return this;
    }

    public Buffer setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
        return this;
    }

    public Buffer setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
        return this;
    }

    public int setBytes(int index, InputStream src, int length) throws IOException {
        return this.buffer.setBytes(index, src, length);
    }

    public int setBytesUntilEndStream(int index, InputStream src, int chunkSize) throws IOException {
        return this.buffer.setBytesUntilEndStream(index, src, chunkSize);
    }

    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    public byte readByte() {
        return this.buffer.readByte();
    }

    public short readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public short readShort() {
        return this.buffer.readShort();
    }

    public short readShortLE() {
        return this.buffer.readShortLE();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.buffer.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.buffer.readMedium();
    }

    public int readMediumLE() {
        return this.buffer.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.buffer.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public int readIntLE() {
        return this.buffer.readIntLE();
    }

    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.buffer.readUnsignedIntLE();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public long readLongLE() {
        return this.buffer.readLongLE();
    }

    public char readChar() {
        return this.buffer.readChar();
    }

    public float readFloat() {
        return this.buffer.readFloat();
    }

    public double readDouble() {
        return this.buffer.readDouble();
    }

    public Buffer readSlice(int length) {
        return this.buffer.readSlice(length);
    }

    public Buffer readBytes(int length) {
        return this.buffer.readBytes(length);
    }

    public Buffer readBytes(Buffer dst) {
        this.buffer.readBytes(dst);
        return this;
    }

    public Buffer readBytes(Buffer dst, int length) {
        this.buffer.readBytes(dst, length);
        return this;
    }

    public Buffer readBytes(Buffer dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
        return this;
    }

    public Buffer readBytes(byte[] dst) {
        this.buffer.readBytes(dst);
        return this;
    }

    public Buffer readBytes(byte[] dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
        return this;
    }

    public Buffer readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
        return this;
    }

    public Buffer skipBytes(int length) {
        this.buffer.skipBytes(length);
        return this;
    }

    public Buffer writeBoolean(boolean value) {
        this.buffer.writeBoolean(value);
        return this;
    }

    public Buffer writeByte(int value) {
        this.buffer.writeByte(value);
        return this;
    }

    public Buffer writeShort(int value) {
        this.buffer.writeShort(value);
        return this;
    }

    public Buffer writeShortLE(int value) {
        this.buffer.writeShortLE(value);
        return this;
    }

    public Buffer writeMedium(int value) {
        this.buffer.writeMedium(value);
        return this;
    }

    public Buffer writeMediumLE(int value) {
        this.buffer.writeMediumLE(value);
        return this;
    }

    public Buffer writeInt(int value) {
        this.buffer.writeInt(value);
        return this;
    }

    public Buffer writeIntLE(int value) {
        this.buffer.writeIntLE(value);
        return this;
    }

    public Buffer writeLong(long value) {
        this.buffer.writeLong(value);
        return this;
    }

    public Buffer writeLongLE(long value) {
        this.buffer.writeLongLE(value);
        return this;
    }

    public Buffer writeChar(int value) {
        this.buffer.writeChar(value);
        return this;
    }

    public Buffer writeFloat(float value) {
        this.buffer.writeFloat(value);
        return this;
    }

    public Buffer writeDouble(double value) {
        this.buffer.writeDouble(value);
        return this;
    }

    public Buffer writeBytes(Buffer src) {
        this.buffer.writeBytes(src);
        return this;
    }

    public Buffer writeBytes(Buffer src, int length) {
        this.buffer.writeBytes(src, length);
        return this;
    }

    public Buffer writeBytes(Buffer src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
        return this;
    }

    public Buffer writeBytes(byte[] src) {
        this.buffer.writeBytes(src);
        return this;
    }

    public Buffer writeBytes(byte[] src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
        return this;
    }

    public Buffer writeBytes(ByteBuffer src) {
        this.buffer.writeBytes(src);
        return this;
    }

    public int writeBytes(InputStream src, int length) throws IOException {
        return this.buffer.writeBytes(src, length);
    }

    public int writeBytesUntilEndStream(InputStream src, int chunkSize) throws IOException {
        return this.buffer.writeBytesUntilEndStream(src, chunkSize);
    }

    public Buffer writeAscii(CharSequence seq) {
        this.buffer.writeAscii(seq);
        return this;
    }

    public Buffer writeUtf8(CharSequence seq) {
        this.buffer.writeUtf8(seq);
        return this;
    }

    public Buffer writeUtf8(CharSequence seq, int ensureWritable) {
        this.buffer.writeUtf8(seq, ensureWritable);
        return this;
    }

    public Buffer writeCharSequence(CharSequence seq, Charset charset) {
        this.buffer.writeCharSequence(seq, charset);
        return this;
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        return this.buffer.indexOf(fromIndex, toIndex, value);
    }

    public int bytesBefore(byte value) {
        return this.buffer.bytesBefore(value);
    }

    public int bytesBefore(int length, byte value) {
        return this.buffer.bytesBefore(length, value);
    }

    public int bytesBefore(int index, int length, byte value) {
        return this.buffer.bytesBefore(index, length, value);
    }

    public Buffer copy() {
        return this.buffer.copy();
    }

    public Buffer copy(int index, int length) {
        return this.buffer.copy(index, length);
    }

    public Buffer slice() {
        return this.buffer.slice();
    }

    public Buffer slice(int index, int length) {
        return this.buffer.slice(index, length);
    }

    public Buffer duplicate() {
        return this.buffer.duplicate();
    }

    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    public ByteBuffer toNioBuffer() {
        return this.buffer.toNioBuffer();
    }

    public ByteBuffer toNioBuffer(int index, int length) {
        return this.buffer.toNioBuffer(index, length);
    }

    public ByteBuffer[] toNioBuffers() {
        return this.buffer.toNioBuffers();
    }

    public ByteBuffer[] toNioBuffers(int index, int length) {
        return this.buffer.toNioBuffers(index, length);
    }

    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    public Buffer asReadOnly() {
        return this.buffer.asReadOnly();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public String toString(Charset charset) {
        return this.buffer.toString(charset);
    }

    public String toString(int index, int length, Charset charset) {
        return this.buffer.toString(index, length, charset);
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + '(' + this.buffer.toString() + ')';
    }

    public int forEachByte(ByteProcessor processor) {
        return this.buffer.forEachByte(processor);
    }

    public int forEachByte(int index, int length, ByteProcessor processor) {
        return this.buffer.forEachByte(index, length, processor);
    }

    public int forEachByteDesc(ByteProcessor processor) {
        return this.buffer.forEachByteDesc(processor);
    }

    public int forEachByteDesc(int index, int length, ByteProcessor processor) {
        return this.buffer.forEachByteDesc(index, length, processor);
    }

    public boolean equals(Object o) {
        return this.buffer.equals(o);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }
}

