/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.runtime.nodes.ExpectStringOrTruffleObjectNodeGen;
import com.oracle.truffle.regex.tregex.string.Encodings;

@GenerateUncached
public abstract class ExpectStringOrTruffleObjectNode
extends Node {
    public abstract Object execute(Object var1, Encodings.Encoding var2) throws UnsupportedTypeException;

    @Specialization
    static String doString(String input, Encodings.Encoding encoding) {
        return input;
    }

    @Specialization
    static TruffleString doTString(TruffleString input, Encodings.Encoding encoding, @Cached TruffleString.MaterializeNode materializeNode) {
        materializeNode.execute((AbstractTruffleString)input, encoding.getTStringEncoding());
        return input;
    }

    @Specialization(guards={"inputs.isString(input)"}, limit="2")
    static String doBoxedString(Object input, Encodings.Encoding encoding, @CachedLibrary(value="input") InteropLibrary inputs) throws UnsupportedTypeException {
        try {
            return inputs.asString(input);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedTypeException.create((Object[])new Object[]{input});
        }
    }

    @Specialization(guards={"inputs.hasArrayElements(input)"}, limit="2")
    static Object doBoxedCharArray(Object input, Encodings.Encoding encoding, @CachedLibrary(value="input") InteropLibrary inputs) throws UnsupportedTypeException {
        try {
            long inputLength = inputs.getArraySize(input);
            if (inputLength > Integer.MAX_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedTypeException.create((Object[])new Object[]{input});
            }
            return input;
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedTypeException.create((Object[])new Object[]{input});
        }
    }

    public static ExpectStringOrTruffleObjectNode create() {
        return ExpectStringOrTruffleObjectNodeGen.create();
    }
}

