/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.io.Resources;
import io.swagger.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Singleton
@Path(value="/")
public class ApiResource {
    @Context
    UriInfo uriInfo;
    private static final String SWAGGER = "swagger.html";
    private static final String MAP = "map.html";
    private static final String OPENAPI = "ogcapi.yaml";

    @GET
    @Path(value="/swagger")
    @Produces(value={"text/html"})
    public Response getSwaggerUI() throws IOException {
        try (InputStream inputStream = Resources.getResource((String)SWAGGER).openStream();){
            Response response = Response.ok().entity((Object)inputStream.readAllBytes()).build();
            return response;
        }
    }

    @GET
    @Path(value="/map")
    @Produces(value={"text/html"})
    public Response getMap() throws IOException {
        try (InputStream inputStream = Resources.getResource((String)MAP).openStream();){
            Response response = Response.ok((Object)inputStream.readAllBytes()).build();
            return response;
        }
    }

    @GET
    @Path(value="/api")
    @Produces(value={"application/json"})
    public Response getJsonSpecification() throws IOException {
        try (InputStream inputStream = Resources.getResource((String)OPENAPI).openStream();){
            OpenAPI openAPI = new OpenAPIV3Parser().readContents(new String(inputStream.readAllBytes(), StandardCharsets.UTF_8)).getOpenAPI();
            openAPI.setServers(List.of(new Server().url(String.format("%s://%s:%s/", this.uriInfo.getBaseUri().getScheme(), this.uriInfo.getBaseUri().getHost(), this.uriInfo.getBaseUri().getPort()))));
            ObjectMapper mapper = Json.mapper();
            mapper.registerModule((Module)new JavaTimeModule());
            String json = mapper.writeValueAsString((Object)openAPI);
            Response response = Response.ok((Object)json).build();
            return response;
        }
    }
}

