/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiCurve;
import mil.nga.sf.util.GeometryUtils;

public class MultiLineString
extends MultiCurve<LineString> {
    private static final long serialVersionUID = 1L;

    public MultiLineString() {
        this(false, false);
    }

    public MultiLineString(boolean hasZ, boolean hasM) {
        super(GeometryType.MULTILINESTRING, hasZ, hasM);
    }

    public MultiLineString(List<LineString> lineStrings) {
        this(GeometryUtils.hasZ(lineStrings), GeometryUtils.hasM(lineStrings));
        this.setLineStrings(lineStrings);
    }

    public MultiLineString(LineString lineString) {
        this(lineString.hasZ(), lineString.hasM());
        this.addLineString(lineString);
    }

    public MultiLineString(MultiLineString multiLineString) {
        this(multiLineString.hasZ(), multiLineString.hasM());
        for (LineString lineString : multiLineString.getLineStrings()) {
            this.addLineString((LineString)lineString.copy());
        }
    }

    public List<LineString> getLineStrings() {
        return this.getCurves();
    }

    public void setLineStrings(List<LineString> lineStrings) {
        this.setCurves(lineStrings);
    }

    public void addLineString(LineString lineString) {
        this.addCurve(lineString);
    }

    public void addLineStrings(List<LineString> lineStrings) {
        this.addCurves(lineStrings);
    }

    public int numLineStrings() {
        return this.numCurves();
    }

    public LineString getLineString(int n) {
        return (LineString)this.getCurve(n);
    }

    @Override
    public Geometry copy() {
        return new MultiLineString(this);
    }
}

