/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.HashSet;
import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.Point;
import mil.nga.sf.util.GeometryUtils;

public class MultiPoint
extends GeometryCollection<Point> {
    private static final long serialVersionUID = 1L;

    public MultiPoint() {
        this(false, false);
    }

    public MultiPoint(boolean hasZ, boolean hasM) {
        super(GeometryType.MULTIPOINT, hasZ, hasM);
    }

    public MultiPoint(List<Point> points) {
        this(GeometryUtils.hasZ(points), GeometryUtils.hasM(points));
        this.setPoints(points);
    }

    public MultiPoint(Point point) {
        this(point.hasZ(), point.hasM());
        this.addPoint(point);
    }

    public MultiPoint(MultiPoint multiPoint) {
        this(multiPoint.hasZ(), multiPoint.hasM());
        for (Point point : multiPoint.getPoints()) {
            this.addPoint((Point)point.copy());
        }
    }

    public List<Point> getPoints() {
        return this.getGeometries();
    }

    public void setPoints(List<Point> points) {
        this.setGeometries(points);
    }

    public void addPoint(Point point) {
        this.addGeometry(point);
    }

    public void addPoints(List<Point> points) {
        this.addGeometries(points);
    }

    public int numPoints() {
        return this.numGeometries();
    }

    public Point getPoint(int n) {
        return (Point)this.getGeometry(n);
    }

    @Override
    public Geometry copy() {
        return new MultiPoint(this);
    }

    @Override
    public boolean isSimple() {
        HashSet<Point> points = new HashSet<Point>(this.getPoints());
        return points.size() == this.numPoints();
    }
}

