/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.geopackage;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.geom.GeoPackageGeometryData;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.Polygon;
import org.apache.baremaps.database.collection.AbstractDataCollection;
import org.apache.baremaps.database.schema.DataColumn;
import org.apache.baremaps.database.schema.DataColumnImpl;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataRowType;
import org.apache.baremaps.database.schema.DataRowTypeImpl;
import org.apache.baremaps.database.schema.DataTable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;

public class GeoPackageDataTable
extends AbstractDataCollection<DataRow>
implements DataTable {
    private final FeatureDao featureDao;
    private final DataRowType rowType;
    private final GeometryFactory geometryFactory;

    public GeoPackageDataTable(FeatureDao featureDao) {
        this.featureDao = featureDao;
        String name = featureDao.getTableName();
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        for (FeatureColumn column : featureDao.getColumns()) {
            String propertyName = column.getName();
            DataColumn.Type propertyType = this.classType(column);
            columns.add(new DataColumnImpl(propertyName, propertyType));
        }
        this.rowType = new DataRowTypeImpl(name, columns);
        this.geometryFactory = new GeometryFactory(new PrecisionModel(), (int)featureDao.getSrs().getId());
    }

    protected DataColumn.Type classType(FeatureColumn column) {
        if (column.isGeometry()) {
            return DataColumn.Type.fromBinding(Geometry.class);
        }
        return DataColumn.Type.fromBinding(column.getDataType().getClassType());
    }

    @Override
    public Iterator<DataRow> iterator() {
        return new GeopackageIterator((FeatureResultSet)this.featureDao.queryForAll(), this.rowType);
    }

    @Override
    public long sizeAsLong() {
        return this.featureDao.count();
    }

    @Override
    public DataRowType rowType() {
        return this.rowType;
    }

    private Object asJavaValue(Object value) {
        if (value instanceof GeoPackageGeometryData) {
            GeoPackageGeometryData geometry = (GeoPackageGeometryData)value;
            return this.asJtsGeometry(geometry.getGeometry());
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return value.toString();
        }
        return value;
    }

    private Geometry asJtsGeometry(mil.nga.sf.Geometry geometry) {
        if (geometry instanceof mil.nga.sf.Point) {
            mil.nga.sf.Point point = (mil.nga.sf.Point)geometry;
            return this.asJtsPoint(point);
        }
        if (geometry instanceof mil.nga.sf.LineString) {
            mil.nga.sf.LineString lineString = (mil.nga.sf.LineString)geometry;
            return this.asJtsLineString(lineString);
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            return this.asJtsPolygon(polygon);
        }
        if (geometry instanceof mil.nga.sf.MultiPoint) {
            mil.nga.sf.MultiPoint multiPoint = (mil.nga.sf.MultiPoint)geometry;
            return this.asJtsMultiPoint(multiPoint);
        }
        if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            return this.asJtsMultiLineString(multiLineString);
        }
        if (geometry instanceof mil.nga.sf.MultiPolygon) {
            mil.nga.sf.MultiPolygon multiPolygon = (mil.nga.sf.MultiPolygon)geometry;
            return this.asJtsMultiPolygon(multiPolygon);
        }
        if (geometry instanceof mil.nga.sf.GeometryCollection) {
            mil.nga.sf.GeometryCollection geometryCollection = (mil.nga.sf.GeometryCollection)geometry;
            return this.asJstGeometryCollection(geometryCollection);
        }
        return null;
    }

    private GeometryCollection asJstGeometryCollection(mil.nga.sf.GeometryCollection geometryCollection) {
        List geometries = geometryCollection.getGeometries();
        return this.geometryFactory.createGeometryCollection((Geometry[])geometries.stream().map(this::asJtsGeometry).toArray(Geometry[]::new));
    }

    private MultiPolygon asJtsMultiPolygon(mil.nga.sf.MultiPolygon multiPolygon) {
        return this.geometryFactory.createMultiPolygon((org.locationtech.jts.geom.Polygon[])multiPolygon.getPolygons().stream().map(this::asJtsPolygon).toArray(org.locationtech.jts.geom.Polygon[]::new));
    }

    private org.locationtech.jts.geom.MultiLineString asJtsMultiLineString(MultiLineString multiLineString) {
        return this.geometryFactory.createMultiLineString((LineString[])multiLineString.getLineStrings().stream().map(this::asJtsLineString).toArray(LineString[]::new));
    }

    private MultiPoint asJtsMultiPoint(mil.nga.sf.MultiPoint multiPoint) {
        return this.geometryFactory.createMultiPoint((Point[])multiPoint.getPoints().stream().map(this::asJtsPoint).toArray(Point[]::new));
    }

    private org.locationtech.jts.geom.Polygon asJtsPolygon(Polygon polygon) {
        LinearRing shell = this.geometryFactory.createLinearRing((Coordinate[])((mil.nga.sf.LineString)polygon.getExteriorRing()).getPoints().stream().map(point -> new Coordinate(point.getX(), point.getY())).toArray(Coordinate[]::new));
        LinearRing[] holes = (LinearRing[])polygon.getRings().stream().skip(1L).map(lineString -> this.geometryFactory.createLinearRing((Coordinate[])lineString.getPoints().stream().map(point -> new Coordinate(point.getX(), point.getY())).toArray(Coordinate[]::new))).toArray(LinearRing[]::new);
        return this.geometryFactory.createPolygon(shell, holes);
    }

    private LineString asJtsLineString(mil.nga.sf.LineString lineString) {
        Coordinate[] coordinates = (Coordinate[])lineString.getPoints().stream().map(point -> new Coordinate(point.getX(), point.getY())).toArray(Coordinate[]::new);
        return this.geometryFactory.createLineString(coordinates);
    }

    private Point asJtsPoint(mil.nga.sf.Point point) {
        return this.geometryFactory.createPoint(new Coordinate(point.getX(), point.getY()));
    }

    public class GeopackageIterator
    implements Iterator<DataRow> {
        private final FeatureResultSet featureResultSet;
        private final DataRowType rowType;
        private boolean hasNext;

        public GeopackageIterator(FeatureResultSet featureResultSet, DataRowType rowType) {
            this.featureResultSet = featureResultSet;
            this.rowType = rowType;
            this.hasNext = featureResultSet.moveToFirst();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public DataRow next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            DataRow row = this.rowType.createRow();
            for (FeatureColumn featureColumn : this.featureResultSet.getColumns().getColumns()) {
                Object value = this.featureResultSet.getValue(featureColumn);
                if (value == null) continue;
                row.set(featureColumn.getName(), GeoPackageDataTable.this.asJavaValue(value));
            }
            this.hasNext = this.featureResultSet.moveToNext();
            return row;
        }
    }
}

