/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.Weigher;
import java.nio.ByteBuffer;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.checkerframework.checker.index.qual.NonNegative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileCache
implements TileStore {
    private static final Logger logger = LoggerFactory.getLogger(TileCache.class);
    private final TileStore tileStore;
    private final Cache<TileCoord, ByteBuffer> cache;

    public TileCache(TileStore tileStore, CaffeineSpec spec) {
        this.tileStore = tileStore;
        this.cache = Caffeine.from((CaffeineSpec)spec).weigher((Weigher)new Weigher<TileCoord, ByteBuffer>(){

            public @NonNegative int weigh(TileCoord tileCoord, ByteBuffer blob) {
                return 28 + blob.capacity();
            }
        }).build();
    }

    @Override
    public ByteBuffer read(TileCoord tileCoord) throws TileStoreException {
        ByteBuffer buffer = (ByteBuffer)this.cache.get((Object)tileCoord, t -> {
            try {
                return this.tileStore.read((TileCoord)t);
            }
            catch (TileStoreException e) {
                logger.error("Unable to read the tile.", (Throwable)e);
                return null;
            }
        });
        if (buffer == null) {
            return null;
        }
        return buffer.duplicate();
    }

    @Override
    public void write(TileCoord tileCoord, ByteBuffer bytes) throws TileStoreException {
        this.tileStore.write(tileCoord, bytes);
        this.cache.invalidate((Object)tileCoord);
    }

    @Override
    public void delete(TileCoord tileCoord) throws TileStoreException {
        this.tileStore.delete(tileCoord);
        this.cache.invalidate((Object)tileCoord);
    }
}

